/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.gbif.dwc.text.ArchiveFile;
import org.gbif.dwc.text.UnkownCharsetException;
import org.gbif.dwc.text.UnkownDelimitersException;
import org.gbif.file.CSVReader;
import org.gbif.utils.file.CharsetDetection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVReaderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CSVReaderFactory.class);
    private static final int ROWS_TO_INSPECT = 10;

    public static CSVReader build(ArchiveFile source) throws IOException {
        return new CSVReader(source.getLocationFile(), source.getEncoding(), source.getFieldsTerminatedBy(), source.getFieldsEnclosedBy(), source.getIgnoreHeaderLines());
    }

    public static CSVReader build(File source) throws IOException {
        String encoding = CSVReaderFactory.detectEncoding(source);
        ArchiveFile af = CSVReaderFactory.buildArchiveFile(source, encoding);
        return CSVReaderFactory.build(af);
    }

    public static CSVReader build(File source, String delimiter, boolean header) throws IOException {
        return new CSVReader(source, CSVReaderFactory.detectEncoding(source), delimiter, null, (Integer)(header ? 1 : 0));
    }

    public static CSVReader build(File source, String encoding, String delimiter, Character quotes, Integer headerRows) throws IOException {
        return new CSVReader(source, encoding, delimiter, quotes, headerRows);
    }

    public static CSVReader build(File source, String encoding, String delimiter, Integer headerRows) throws IOException {
        return new CSVReader(source, encoding, delimiter, Character.valueOf('\"'), headerRows);
    }

    public static CSVReader build(InputStream stream, String encoding, String delimiter, Character quotes, Integer headerRows) throws IOException {
        return new CSVReader(stream, encoding, delimiter, quotes, headerRows);
    }

    private static ArchiveFile buildArchiveFile(File source, String encoding) throws UnkownDelimitersException {
        String[] potentialDelimiters;
        ArchiveFile dwcFile = new ArchiveFile();
        dwcFile.addLocation(source.getAbsolutePath());
        dwcFile.setEncoding(encoding);
        dwcFile.setIgnoreHeaderLines(1);
        int maxColumns = 0;
        for (String delim : potentialDelimiters = new String[]{",", "\t", ";", "|"}) {
            CSVReader reader;
            ArrayList<Character> potentialQuotes = new ArrayList<Character>();
            try {
                reader = CSVReader.build(source, encoding, delim, null, 1);
                Character firstChar = CSVReaderFactory.likelyQuoteChar(reader);
                reader.close();
                if (firstChar != null) {
                    potentialQuotes.add(firstChar);
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (delim.equals(",")) {
                potentialQuotes.add(Character.valueOf('\"'));
                potentialQuotes.add(Character.valueOf('\''));
                potentialQuotes.add(null);
            } else {
                potentialQuotes.add(null);
                potentialQuotes.add(Character.valueOf('\"'));
                potentialQuotes.add(Character.valueOf('\''));
            }
            for (Character quote : potentialQuotes) {
                try {
                    reader = CSVReader.build(source, encoding, delim, quote, 0);
                    int x = CSVReaderFactory.consistentRowSize(reader);
                    if (x > maxColumns) {
                        dwcFile.setFieldsTerminatedBy(delim);
                        dwcFile.setFieldsEnclosedBy(quote);
                        maxColumns = x;
                    }
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
        if (maxColumns < 1) {
            throw new UnkownDelimitersException("Unable to detect field delimiter");
        }
        String msg = "Detected field delimiter >>>" + dwcFile.getFieldsTerminatedBy() + "<<<";
        if (dwcFile.getFieldsEnclosedBy() != null) {
            msg = msg + " and quoted by >>>" + dwcFile.getFieldsEnclosedBy() + "<<<";
        }
        LOG.debug(msg);
        return dwcFile;
    }

    private static int consistentRowSize(CSVReader reader) {
        int columns = 0;
        boolean plusMinusOne = false;
        for (int rowNum = 0; reader.hasNext() && rowNum < 10; ++rowNum) {
            String[] row = reader.next();
            if (rowNum == 0) {
                columns = row.length;
            }
            if (Math.abs(columns - row.length) > 1) {
                return -1;
            }
            if (columns == row.length) continue;
            plusMinusOne = true;
        }
        if (plusMinusOne) {
            return columns - 2;
        }
        return columns;
    }

    private static String detectEncoding(File source) throws UnkownCharsetException {
        Charset encoding;
        try {
            encoding = CharsetDetection.detectEncoding((File)source, (int)16384);
            if (encoding == null) {
                throw new UnkownCharsetException("Unable to detect the files character encoding");
            }
        }
        catch (IOException e) {
            throw new UnkownCharsetException(e);
        }
        return encoding.displayName();
    }

    private static Character likelyQuoteChar(CSVReader reader) {
        Character quote = null;
        int line = 0;
        block0: while (reader.hasNext() && line < 10) {
            ++line;
            String[] row = reader.next();
            if (row == null) continue;
            for (String col : row) {
                if (col == null || col.length() <= 0 || col.length() <= 1 || col.charAt(0) != col.charAt(col.length() - 1)) continue;
                char potQuote = col.charAt(0);
                if (Character.isLetterOrDigit(potQuote)) continue block0;
                if (quote == null) {
                    quote = Character.valueOf(potQuote);
                    continue;
                }
                if (quote.equals(Character.valueOf(potQuote))) continue;
                quote = null;
                continue block0;
            }
        }
        return quote;
    }
}

