/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.record;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class CleanUtils {
    private static final Pattern NULL_REPL = Pattern.compile("^\\s*(null|\\\\N)?\\s*$", 2);

    private CleanUtils() {
    }

    public static String clean(String value, boolean nulls, boolean entities) {
        if (value == null || nulls && NULL_REPL.matcher(value).find()) {
            return null;
        }
        return entities ? StringEscapeUtils.unescapeHtml4((String)value) : value;
    }
}

