/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.load.DataLoader;
import au.org.ala.biocache.load.DataLoader$class;
import au.org.ala.biocache.load.DataResourceConfig;
import au.org.ala.biocache.load.DwCALoader$;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Multimedia;
import au.org.ala.biocache.model.Multimedia$;
import au.org.ala.biocache.model.Raw$;
import au.org.ala.biocache.model.Version;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.vocab.DwC$;
import au.org.ala.biocache.vocab.Term;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.record.StarRecord;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveFactory;
import org.gbif.dwc.text.ArchiveField;
import org.gbif.utils.file.ClosableIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005=u!B\u0001\u0003\u0011\u0003i\u0011A\u0003#x\u0007\u0006cu.\u00193fe*\u00111\u0001B\u0001\u0005Y>\fGM\u0003\u0002\u0006\r\u0005A!-[8dC\u000eDWM\u0003\u0002\b\u0011\u0005\u0019\u0011\r\\1\u000b\u0005%Q\u0011aA8sO*\t1\"\u0001\u0002bk\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"A\u0003#x\u0007\u0006cu.\u00193feN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u000f\u0010\u0005\u0004%\t!H\u0001\u000b\u00136\u000bu)R0U3B+U#\u0001\u0010\u0011\u0005}9S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013!\u0002;fe6\u001c(BA\u0012%\u0003\r!wo\u0019\u0006\u0003K\u0019\nAa\u001a2jM*\t\u0011\"\u0003\u0002)A\tAqIY5g)\u0016\u0014X\u000e\u0003\u0004+\u001f\u0001\u0006IAH\u0001\f\u00136\u000bu)R0U3B+\u0005\u0005C\u0004-\u001f\t\u0007I\u0011A\u000f\u0002\u001f5+F\nV%N\u000b\u0012K\u0015i\u0018+Z!\u0016CaAL\b!\u0002\u0013q\u0012\u0001E'V\u0019RKU*\u0012#J\u0003~#\u0016\fU#!\u0011\u0015\u0001t\u0002\"\u00012\u0003\u0011i\u0017-\u001b8\u0015\u0005I*\u0004CA\n4\u0013\t!DC\u0001\u0003V]&$\b\"\u0002\u001c0\u0001\u00049\u0014\u0001B1sON\u00042a\u0005\u001d;\u0013\tIDCA\u0003BeJ\f\u0017\u0010\u0005\u0002<}9\u00111\u0003P\u0005\u0003{Q\ta\u0001\u0015:fI\u00164\u0017BA A\u0005\u0019\u0019FO]5oO*\u0011Q\b\u0006\u0004\u0005!\t\u0001!iE\u0002B%\r\u0003\"A\u0004#\n\u0005\u0015\u0013!A\u0003#bi\u0006du.\u00193fe\")\u0011$\u0011C\u0001\u000fR\t\u0001\n\u0005\u0002\u000f\u0003\")1!\u0011C\u0001\u0015R)!gS'S)\")A*\u0013a\u0001u\u0005Y!/Z:pkJ\u001cW-V5e\u0011\u001dq\u0015\n%AA\u0002=\u000b!\u0002\\8h%><8*Z=t!\t\u0019\u0002+\u0003\u0002R)\t9!i\\8mK\u0006t\u0007bB*J!\u0003\u0005\raT\u0001\ti\u0016\u001cHOR5mK\"9Q+\u0013I\u0001\u0002\u0004y\u0015!\u00034pe\u000e,Gj\\1e\u0011\u00159\u0016\t\"\u0001Y\u0003%aw.\u00193M_\u000e\fG\u000eF\u000333jcV\fC\u0003M-\u0002\u0007!\bC\u0003\\-\u0002\u0007!(\u0001\u0005gS2,g*Y7f\u0011\u0015qe\u000b1\u0001P\u0011\u0015\u0019f\u000b1\u0001P\u0011\u0015y\u0016\t\"\u0001a\u0003\u001d9W\r^+vS\u0012$b!Y6om\u0006=\u0001\u0003B\ncI\u0016L!a\u0019\u000b\u0003\rQ+\b\u000f\\33!\u0011\u0019\"MO(\u0011\u0007M1\u0007.\u0003\u0002h)\t1q\n\u001d;j_:\u0004BaO5;u%\u0011!\u000e\u0011\u0002\u0004\u001b\u0006\u0004\b\"\u00027_\u0001\u0004i\u0017\u0001C;oSF,X-\u0013#\u0011\u0007M1'\bC\u0003p=\u0002\u0007\u0001/\u0001\u0003ti\u0006\u0014\bCA9u\u001b\u0005\u0011(BA:#\u0003\u0019\u0011XmY8sI&\u0011QO\u001d\u0002\u000b'R\f'OU3d_J$\u0007\"B<_\u0001\u0004A\u0018aC;oSF,X\rV3s[N\u0004R!_A\u0002\u0003\u0013q!A_@\u000f\u0005mtX\"\u0001?\u000b\u0005ud\u0011A\u0002\u001fs_>$h(C\u0001\u0016\u0013\r\t\t\u0001F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)!a\u0002\u0003\u0007M+\u0017OC\u0002\u0002\u0002Q\u00012aHA\u0006\u0013\r\ti\u0001\t\u0002\u0005)\u0016\u0014X\u000e\u0003\u0004\u0002\u0012y\u0003\r!Z\u0001\u0011[\u0006\u0004\b/\u001a3Qe>\u0004XM\u001d;jKNDq!!\u0006B\t\u0003\t9\"A\u0006m_\u0006$\u0017I]2iSZ,Gc\u0004\u001a\u0002\u001a\u0005m\u0011QDA\u0010\u0003G\t9#!\u000b\t\rm\u000b\u0019\u00021\u0001;\u0011\u0019a\u00151\u0003a\u0001u!1q/a\u0005A\u0002aDq!!\t\u0002\u0014\u0001\u0007Q.\u0001\u0005j[\u0006<W-\u0016:m\u0011\u001d\t)#a\u0005A\u0002=\u000b1b\u001d;sSB\u001c\u0006/Y2fg\"1a*a\u0005A\u0002=CaaUA\n\u0001\u0004y\u0005bBA\u0017\u0003\u0012\u0005\u0011qF\u0001\u000fY>\fG-T;mi&lW\rZ5b)!\t\t$a\u0010\u0002B\u0005\u0015\u0003#B=\u0002\u0004\u0005M\u0002\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005eB!A\u0003n_\u0012,G.\u0003\u0003\u0002>\u0005]\"AC'vYRLW.\u001a3jC\"1q.a\u000bA\u0002AD\u0001\"a\u0011\u0002,\u0001\u0007\u0011\u0011B\u0001\be><H+\u001f9f\u0011!\t9%a\u000bA\u0002\u0005%\u0013!C5nC\u001e,')Y:f!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\n1A\\3u\u0015\t\t\u0019&\u0001\u0003kCZ\f\u0017\u0002BA,\u0003\u001b\u00121!\u0016*M\u0011\u001d\tY&\u0011C\u0001\u0003;\n\u0001\u0003\\8dCR,W*\u001e7uS6,G-[1\u0015\r\u0005}\u0013\u0011MA6!\u0011\u0019b-!\u0013\t\u0011\u0005\r\u0014\u0011\fa\u0001\u0003K\n1A]8x!\r\t\u0018qM\u0005\u0004\u0003S\u0012(A\u0002*fG>\u0014H\r\u0003\u0005\u0002H\u0005e\u0003\u0019AA%\u0011%\ty'QI\u0001\n\u0003\t\t(\u0001\bm_\u0006$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005M$fA(\u0002v-\u0012\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0002R\t!\"\u00198o_R\fG/[8o\u0013\u0011\t))a\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\n\u0006\u000b\n\u0011\"\u0001\u0002r\u0005qAn\\1eI\u0011,g-Y;mi\u0012\u001a\u0004\"CAG\u0003F\u0005I\u0011AA9\u00039aw.\u00193%I\u00164\u0017-\u001e7uIQ\u0002")
public class DwCALoader
implements DataLoader {
    private final String user;
    private final Logger logger;
    private final String temporaryFileStore;
    private final PersistenceManager pm;
    private final String loadTime;
    private final Regex sftpPattern;

    public static void main(String[] stringArray) {
        DwCALoader$.MODULE$.main(stringArray);
    }

    public static GbifTerm MULTIMEDIA_TYPE() {
        return DwCALoader$.MODULE$.MULTIMEDIA_TYPE();
    }

    public static GbifTerm IMAGE_TYPE() {
        return DwCALoader$.MODULE$.IMAGE_TYPE();
    }

    @Override
    public String user() {
        return this.user;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public String temporaryFileStore() {
        return this.temporaryFileStore;
    }

    @Override
    public PersistenceManager pm() {
        return this.pm;
    }

    @Override
    public String loadTime() {
        return this.loadTime;
    }

    @Override
    public Regex sftpPattern() {
        return this.sftpPattern;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$user_$eq(String x$1) {
        this.user = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$temporaryFileStore_$eq(String x$1) {
        this.temporaryFileStore = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$pm_$eq(PersistenceManager x$1) {
        this.pm = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$loadTime_$eq(String x$1) {
        this.loadTime = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$sftpPattern_$eq(Regex x$1) {
        this.sftpPattern = x$1;
    }

    @Override
    public boolean emptyTempFileStore(String resourceUid) {
        return DataLoader$class.emptyTempFileStore(this, resourceUid);
    }

    @Override
    public FileWriter getDeletedFileWriter(String resourceUid) {
        return DataLoader$class.getDeletedFileWriter(this, resourceUid);
    }

    @Override
    public void deleteOldRowKeys(String resourceUid) {
        DataLoader$class.deleteOldRowKeys(this, resourceUid);
    }

    @Override
    public Option<Writer> getRowKeyWriter(String resourceUid, boolean writeRowKeys) {
        return DataLoader$class.getRowKeyWriter(this, resourceUid, writeRowKeys);
    }

    @Override
    public void setNotLoadedForOtherPhases(String resourceUid) {
        DataLoader$class.setNotLoadedForOtherPhases(this, resourceUid);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getDataResourceDetailsAsMap(String uid) {
        return DataLoader$class.getDataResourceDetailsAsMap(this, uid);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getDataProviderDetailsAsMap(String uid) {
        return DataLoader$class.getDataProviderDetailsAsMap(this, uid);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getInstitutionDetailsAsMap(String uid) {
        return DataLoader$class.getInstitutionDetailsAsMap(this, uid);
    }

    @Override
    public Option<DataResourceConfig> retrieveConnectionParameters(String resourceUid) {
        return DataLoader$class.retrieveConnectionParameters(this, resourceUid);
    }

    @Override
    public Seq<org.gbif.dwc.terms.Term> mapConceptTerms(Seq<String> terms) {
        return DataLoader$class.mapConceptTerms(this, terms);
    }

    @Override
    public boolean exists(String dataResourceUid, List<String> identifyingTerms) {
        return DataLoader$class.exists(this, dataResourceUid, identifyingTerms);
    }

    @Override
    public String createUniqueID(String dataResourceUid, Seq<String> identifyingTerms, boolean stripSpaces) {
        return DataLoader$class.createUniqueID(this, dataResourceUid, identifyingTerms, stripSpaces);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, Seq<Multimedia> multimedia) {
        return DataLoader$class.load((DataLoader)this, dataResourceUid, fr, identifyingTerms, multimedia);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms) {
        return DataLoader$class.load(this, dataResourceUid, fr, identifyingTerms);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, boolean updateLastModified) {
        return DataLoader$class.load((DataLoader)this, dataResourceUid, fr, identifyingTerms, updateLastModified);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, boolean updateLastModified, boolean downloadMedia2) {
        return DataLoader$class.load(this, dataResourceUid, fr, identifyingTerms, updateLastModified, downloadMedia2);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, boolean updateLastModified, boolean downloadMedia2, boolean stripSpaces, Option<Writer> rowKeyWriter, Seq<Multimedia> multimedia) {
        return DataLoader$class.load(this, dataResourceUid, fr, identifyingTerms, updateLastModified, downloadMedia2, stripSpaces, rowKeyWriter, multimedia);
    }

    @Override
    public FullRecord processMedia(String dataResourceUid, FullRecord fr, Seq<Multimedia> multimedia) {
        return DataLoader$class.processMedia(this, dataResourceUid, fr, multimedia);
    }

    @Override
    public Tuple2<String, Date> downloadArchive(String url, String resourceUid, Option<Date> lastChecked) {
        return DataLoader$class.downloadArchive(this, url, resourceUid, lastChecked);
    }

    @Override
    public Tuple4<File, Date, Object, Object> downloadSFTPArchive(String url, String resourceUid, Option<Date> lastChecked) {
        return DataLoader$class.downloadSFTPArchive(this, url, resourceUid, lastChecked);
    }

    @Override
    public Option<Tuple2<String, Date>> sftpLatestArchive(String url, String resourceUid, Option<Date> afterDate) {
        return DataLoader$class.sftpLatestArchive(this, url, resourceUid, afterDate);
    }

    @Override
    public Tuple4<File, Date, Object, Object> downloadStandardArchive(String url, String resourceUid, Option<Date> afterDate) {
        return DataLoader$class.downloadStandardArchive(this, url, resourceUid, afterDate);
    }

    @Override
    public boolean updateLastChecked(String resourceUid, Option<Date> dataCurrency) {
        return DataLoader$class.updateLastChecked(this, resourceUid, dataCurrency);
    }

    @Override
    public Option<Date> updateLastChecked$default$2() {
        return DataLoader$class.updateLastChecked$default$2(this);
    }

    @Override
    public boolean createUniqueID$default$3() {
        return DataLoader$class.createUniqueID$default$3(this);
    }

    @Override
    public Seq<Multimedia> processMedia$default$3() {
        return DataLoader$class.processMedia$default$3(this);
    }

    public void load(String resourceUid, boolean logRowKeys, boolean testFile, boolean forceLoad) {
        this.emptyTempFileStore(resourceUid);
        this.deleteOldRowKeys(resourceUid);
        Option<DataResourceConfig> option = this.retrieveConnectionParameters(resourceUid);
        None$ none$ = None$.MODULE$;
        Option<DataResourceConfig> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new Exception(new StringBuilder().append((Object)"Unable to retrieve connection params for ").append((Object)resourceUid).toString());
        }
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            DataResourceConfig dataResourceConfig = (DataResourceConfig)some.x();
            Seq<org.gbif.dwc.terms.Term> conceptTerms = this.mapConceptTerms(dataResourceConfig.uniqueTerms());
            Option imageUrl = dataResourceConfig.connectionParams().get((Object)"imageUrl");
            boolean incremental = BoxesRunTime.unboxToBoolean((Object)dataResourceConfig.connectionParams().getOrElse((Object)"incremental", (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            boolean strip = BoxesRunTime.unboxToBoolean((Object)dataResourceConfig.connectionParams().getOrElse((Object)"strip", (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            BooleanRef loaded = new BooleanRef(false);
            ObjectRef maxLastModifiedDate = new ObjectRef(null);
            dataResourceConfig.urls().foreach((Function1)new Serializable(this, resourceUid, logRowKeys, testFile, forceLoad, dataResourceConfig, conceptTerms, imageUrl, incremental, strip, loaded, maxLastModifiedDate){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DwCALoader $outer;
                private final String resourceUid$2;
                private final boolean logRowKeys$2;
                private final boolean testFile$2;
                private final boolean forceLoad$1;
                private final DataResourceConfig dataResourceConfig$1;
                private final Seq conceptTerms$1;
                private final Option imageUrl$1;
                private final boolean incremental$1;
                private final boolean strip$1;
                private final BooleanRef loaded$1;
                private final ObjectRef maxLastModifiedDate$1;

                public final void apply(String url) {
                    Tuple2<String, Date> tuple2 = this.$outer.downloadArchive(url, this.resourceUid$2, this.forceLoad$1 ? None$.MODULE$ : this.dataResourceConfig$1.dateLastChecked());
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        String fileName = (String)tuple2._1();
                        Date date = (Date)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)fileName, (Object)date);
                        String fileName2 = (String)tuple23._1();
                        Date date2 = (Date)tuple23._2();
                        if ((Date)this.maxLastModifiedDate$1.elem == null || date2.after((Date)this.maxLastModifiedDate$1.elem)) {
                            this.maxLastModifiedDate$1.elem = date2;
                        }
                        this.$outer.logger().info(new StringBuilder().append((Object)"File last modified date: ").append((Object)((Date)this.maxLastModifiedDate$1.elem)).toString());
                        if (fileName2 != null) {
                            this.$outer.loadArchive(fileName2, this.resourceUid$2, (Seq<org.gbif.dwc.terms.Term>)this.conceptTerms$1, (Option<String>)this.imageUrl$1, this.strip$1, this.logRowKeys$2 || this.incremental$1, this.testFile$2);
                            this.loaded$1.elem = true;
                        }
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.resourceUid$2 = resourceUid$2;
                    this.logRowKeys$2 = logRowKeys$2;
                    this.testFile$2 = testFile$2;
                    this.forceLoad$1 = forceLoad$1;
                    this.dataResourceConfig$1 = dataResourceConfig$1;
                    this.conceptTerms$1 = conceptTerms$1;
                    this.imageUrl$1 = imageUrl$1;
                    this.incremental$1 = incremental$1;
                    this.strip$1 = strip$1;
                    this.loaded$1 = loaded$1;
                    this.maxLastModifiedDate$1 = maxLastModifiedDate$1;
                }
            });
            if (testFile) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.updateLastChecked(resourceUid, (Option<Date>)(loaded.elem ? new Some((Object)((Date)maxLastModifiedDate.elem)) : None$.MODULE$));
                if (loaded.elem) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.setNotLoadedForOtherPhases(resourceUid);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new MatchError(option);
    }

    public boolean load$default$2() {
        return false;
    }

    public boolean load$default$3() {
        return false;
    }

    public boolean load$default$4() {
        return false;
    }

    public void loadLocal(String resourceUid, String fileName, boolean logRowKeys, boolean testFile) {
        Option<DataResourceConfig> option = this.retrieveConnectionParameters(resourceUid);
        None$ none$ = None$.MODULE$;
        Option<DataResourceConfig> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new Exception(new StringBuilder().append((Object)"Unable to load resourceUid: ").append((Object)resourceUid).toString());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            DataResourceConfig dataResourceConfig = (DataResourceConfig)some.x();
            Seq<org.gbif.dwc.terms.Term> conceptTerms = this.mapConceptTerms(dataResourceConfig.uniqueTerms());
            boolean strip = BoxesRunTime.unboxToBoolean((Object)dataResourceConfig.connectionParams().getOrElse((Object)"strip", (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            this.loadArchive(fileName, resourceUid, conceptTerms, (Option<String>)dataResourceConfig.connectionParams().get((Object)"imageUrl"), strip, logRowKeys, testFile);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError(option);
    }

    public Tuple2<Tuple2<String, Object>, Option<scala.collection.immutable.Map<String, String>>> getUuid(Option<String> uniqueID, StarRecord star, Seq<org.gbif.dwc.terms.Term> uniqueTerms, Option<scala.collection.immutable.Map<String, String>> mappedProperties) {
        Option<String> option;
        block4: {
            Tuple2 tuple2;
            block3: {
                block2: {
                    option = uniqueID;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String value = (String)some.x();
                    tuple2 = new Tuple2(Config$.MODULE$.occurrenceDAO().createOrRetrieveUuid(value), mappedProperties);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                tuple2 = new Tuple2((Object)new Tuple2((Object)Config$.MODULE$.occurrenceDAO().createUuid(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), mappedProperties);
            }
            return tuple2;
        }
        throw new MatchError(option);
    }

    public void loadArchive(String fileName, String resourceUid, Seq<org.gbif.dwc.terms.Term> uniqueTerms, Option<String> imageUrl, boolean stripSpaces, boolean logRowKeys, boolean testFile) {
        this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading archive: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for resource: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceUid}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with unique terms: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uniqueTerms}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stripping spaces:  ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)stripSpaces)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"incremental: ", ",  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)logRowKeys)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testing: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)testFile)}))).toString());
        File archiveDir = new File(fileName);
        URL imageBase = new URL((String)imageUrl.getOrElse((Function0)new Serializable(this, archiveDir){
            public static final long serialVersionUID = 0L;
            private final File archiveDir$1;

            public final String apply() {
                return this.archiveDir$1.toURI().toURL().toString();
            }
            {
                this.archiveDir$1 = archiveDir$1;
            }
        }));
        Option<Writer> rowKeyWriter = this.getRowKeyWriter(resourceUid, logRowKeys);
        Archive archive = ArchiveFactory.openArchive((File)archiveDir);
        ClosableIterator iter = archive.iterator();
        int count = 0;
        int newCount = 0;
        Map fieldMap = archive.getCore().getFields();
        List fieldShortNames = JavaConversions$.MODULE$.asScalaSet(fieldMap.keySet()).toList();
        Seq<String> biocacheModelValues = DwC$.MODULE$.retrieveCanonicals((Seq<String>)((Seq)fieldShortNames.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(org.gbif.dwc.terms.Term x$2) {
                return x$2.simpleName();
            }
        }, List$.MODULE$.canBuildFrom())));
        scala.collection.immutable.Map fieldToModelMap = ((TraversableOnce)fieldShortNames.zip(biocacheModelValues, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        HashMap fieldShortNameToIdxMap = new HashMap();
        JavaConversions$.MODULE$.mapAsScalaMap(fieldMap).foreach((Function1)new Serializable(this, fieldShortNameToIdxMap){
            public static final long serialVersionUID = 0L;
            private final HashMap fieldShortNameToIdxMap$1;

            public final Object apply(Tuple2<org.gbif.dwc.terms.Term, ArchiveField> x0$1) {
                Tuple2<org.gbif.dwc.terms.Term, ArchiveField> tuple2;
                block2: {
                    Option<Term> option;
                    block7: {
                        BoxedUnit boxedUnit;
                        block4: {
                            BoxedUnit boxedUnit2;
                            block6: {
                                block5: {
                                    Integer fieldIdx;
                                    org.gbif.dwc.terms.Term term;
                                    block3: {
                                        tuple2 = x0$1;
                                        if (tuple2 == null) break block2;
                                        term = (org.gbif.dwc.terms.Term)tuple2._1();
                                        ArchiveField field = (ArchiveField)tuple2._2();
                                        fieldIdx = field.getIndex();
                                        if (fieldIdx != null) break block3;
                                        boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    option = DwC$.MODULE$.matchTerm(term.simpleName());
                                    if (!(option instanceof Some)) break block5;
                                    Some some = (Some)option;
                                    Term matchedTerm = (Term)some.x();
                                    boxedUnit2 = this.fieldShortNameToIdxMap$1.put((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(fieldIdx)), (Object)matchedTerm.canonical());
                                    break block6;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<Term> option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit2;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                        return boxedUnit3;
                    }
                    throw new MatchError(option);
                }
                throw new MatchError(tuple2);
            }
            {
                this.fieldShortNameToIdxMap$1 = fieldShortNameToIdxMap$1;
            }
        });
        if (this.logger().isDebugEnabled()) {
            fieldToModelMap.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DwCALoader $outer;

                public final void apply(Tuple2<org.gbif.dwc.terms.Term, String> x0$2) {
                    Tuple2<org.gbif.dwc.terms.Term, String> tuple2 = x0$2;
                    if (tuple2 != null) {
                        org.gbif.dwc.terms.Term dwcShortName = (org.gbif.dwc.terms.Term)tuple2._1();
                        String biocacheField = (String)tuple2._2();
                        this.$outer.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dwcShortName: ", " , biocacheField: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dwcShortName, biocacheField})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        long startTime = System.currentTimeMillis();
        long finishTime = System.currentTimeMillis();
        ArrayBuffer currentBatch = new ArrayBuffer();
        scala.collection.immutable.Set institutionCodes = ((TraversableOnce)Config$.MODULE$.indexDAO().getDistinctValues(new StringBuilder().append((Object)"data_resource_uid:").append((Object)resourceUid).toString(), "institution_code", 100).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Nothing$> apply() {
                return Nil$.MODULE$;
            }
        })).toSet();
        scala.collection.immutable.Set collectionCodes = ((TraversableOnce)Config$.MODULE$.indexDAO().getDistinctValues(new StringBuilder().append((Object)"data_resource_uid:").append((Object)resourceUid).toString(), "collection_code", 100).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Nothing$> apply() {
                return Nil$.MODULE$;
            }
        })).toSet();
        this.logger().info(new StringBuilder().append((Object)"The current institution codes for the data resource: ").append((Object)institutionCodes).toString());
        this.logger().info(new StringBuilder().append((Object)"The current collection codes for the data resource: ").append((Object)collectionCodes).toString());
        HashSet newCollCodes = new HashSet();
        HashSet newInstCodes = new HashSet();
        while (iter.hasNext()) {
            Tuple2<Tuple2<String, Object>, Option<scala.collection.immutable.Map<String, String>>> tuple2;
            Object object;
            None$ uniqueID;
            None$ none$;
            ++count;
            StarRecord star = (StarRecord)iter.next();
            if (uniqueTerms.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                Seq uniqueTermValues = (Seq)uniqueTerms.map((Function1)new Serializable(this, star){
                    public static final long serialVersionUID = 0L;
                    private final StarRecord star$1;

                    public final String apply(org.gbif.dwc.terms.Term t) {
                        return this.star$1.core().value(t);
                    }
                    {
                        this.star$1 = star$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resourceUid}));
                String id = uniqueTermValues.toList().$colon$colon$colon(list).mkString("|").trim();
                none$ = uniqueID = new Some((Object)(stripSpaces ? id.replaceAll("\\s", "") : id));
            }
            if (testFile) {
                String icode = star.core().value((org.gbif.dwc.terms.Term)DwcTerm.institutionCode);
                newInstCodes.add((Object)(icode == null ? "<NULL>" : icode));
                String ccode = star.core().value((org.gbif.dwc.terms.Term)DwcTerm.collectionCode);
                object = BoxesRunTime.boxToBoolean((boolean)newCollCodes.add((Object)(ccode == null ? "<NULL>" : ccode)));
            } else {
                object = BoxedUnit.UNIT;
            }
            ListBuffer fieldTuples = new ListBuffer();
            fieldShortNameToIdxMap.foreach((Function1)new Serializable(this, star, fieldTuples){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DwCALoader $outer;
                private final StarRecord star$1;
                private final ListBuffer fieldTuples$1;

                public final Object apply(Tuple2<Object, String> x0$3) {
                    Tuple2<Object, String> tuple2 = x0$3;
                    if (tuple2 != null) {
                        int fieldIdx = tuple2._1$mcI$sp();
                        String modelProperty = (String)tuple2._2();
                        String property = this.star$1.core().column(fieldIdx);
                        if (this.$outer.logger().isDebugEnabled() && StringUtils.isNotBlank((CharSequence)property)) {
                            this.$outer.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mapped field: ", ", fieldIdx: ", ", value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelProperty, BoxesRunTime.boxToInteger((int)fieldIdx), property})));
                        }
                        BoxedUnit boxedUnit = StringUtils.isNotBlank((CharSequence)property) ? this.fieldTuples$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)modelProperty), (Object)property)) : BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.star$1 = star$1;
                    this.fieldTuples$1 = fieldTuples$1;
                }
            });
            if (this.logger().isDebugEnabled()) {
                fieldTuples.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DwCALoader $outer;

                    public final void apply(Tuple2<String, String> x0$4) {
                        Tuple2<String, String> tuple2 = x0$4;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            this.$outer.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not blank fields: ", " , value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            if ((tuple2 = this.getUuid((Option<String>)uniqueID, star, uniqueTerms, (Option<scala.collection.immutable.Map<String, String>>)None$.MODULE$)) != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Option mappedProps = (Option)tuple2._2();
                if (tuple22 != null) {
                    BoxedUnit boxedUnit;
                    String rowKey;
                    String string;
                    Tuple3 tuple3;
                    String recordUuid = (String)tuple22._1();
                    boolean isNew = tuple22._2$mcZ$sp();
                    Tuple3 tuple32 = tuple3 = new Tuple3((Object)recordUuid, (Object)BoxesRunTime.boxToBoolean((boolean)isNew), (Object)mappedProps);
                    String recordUuid2 = (String)tuple32._1();
                    boolean isNew2 = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
                    Option mappedProps2 = (Option)tuple32._3();
                    Object object2 = mappedProps2.isDefined() && uniqueID.isDefined() ? Config$.MODULE$.persistenceManager().put((String)uniqueID.get(), "occ", (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)mappedProps2.get())) : BoxedUnit.UNIT;
                    fieldTuples.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"uuid"), (Object)recordUuid2));
                    fieldTuples.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataResourceUid"), (Object)resourceUid));
                    fieldTuples.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lastModifiedTime"), (Object)this.loadTime()));
                    if (isNew2) {
                        fieldTuples.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"firstLoaded"), (Object)this.loadTime()));
                        ++newCount;
                    }
                    Seq multimedia = (Seq)this.loadMultimedia(star, (org.gbif.dwc.terms.Term)DwCALoader$.MODULE$.IMAGE_TYPE(), imageBase).$plus$plus(this.loadMultimedia(star, (org.gbif.dwc.terms.Term)DwCALoader$.MODULE$.MULTIMEDIA_TYPE(), imageBase), Seq$.MODULE$.canBuildFrom());
                    if (uniqueID.isEmpty()) {
                        this.logger().warn("Unable to construct a unique key for this data resource. No unique terms defined.");
                        string = new StringBuilder().append((Object)resourceUid).append((Object)"|").append((Object)recordUuid2).toString();
                    } else {
                        string = rowKey = (String)uniqueID.get();
                    }
                    if (rowKeyWriter.isDefined()) {
                        ((Writer)rowKeyWriter.get()).write(new StringBuilder().append((Object)rowKey).append((Object)"\n").toString());
                    }
                    if (testFile) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        FullRecord fullRecord = FullRecordMapper$.MODULE$.createFullRecord(rowKey, (Tuple2[])fieldTuples.toArray(ClassTag$.MODULE$.apply(Tuple2.class)), (Version)Raw$.MODULE$);
                        this.processMedia(resourceUid, fullRecord, (Seq<Multimedia>)multimedia);
                        boxedUnit = currentBatch.$plus$eq((Object)fullRecord);
                    }
                    if (count % 1000 != 0 || count <= 0) continue;
                    if (!testFile) {
                        Config$.MODULE$.occurrenceDAO().addRawOccurrenceBatch((FullRecord[])currentBatch.toArray(ClassTag$.MODULE$.apply(FullRecord.class)));
                    }
                    finishTime = System.currentTimeMillis();
                    float timeInSecs = (float)1000 / ((float)(finishTime - startTime) / 1000.0f);
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", >> last key : ", ", UUID: ", ", records per sec: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count), uniqueID, recordUuid2, BoxesRunTime.boxToFloat((float)timeInSecs)})));
                    startTime = System.currentTimeMillis();
                    currentBatch.clear();
                    continue;
                }
            }
            throw new MatchError(tuple2);
        }
        if (rowKeyWriter.isDefined()) {
            ((Writer)rowKeyWriter.get()).flush();
            ((Writer)rowKeyWriter.get()).close();
        }
        if (testFile) {
            HashSet unknownInstitutions = (HashSet)newInstCodes.$amp$tilde((GenSet)institutionCodes);
            HashSet unknownCollections = (HashSet)newCollCodes.$amp$tilde((GenSet)collectionCodes);
            if (!unknownInstitutions.isEmpty()) {
                this.logger().warn(new StringBuilder().append((Object)"Warning there are new institution codes in the set: ").append((Object)unknownInstitutions.mkString(",")).toString());
            }
            if (!unknownCollections.isEmpty()) {
                this.logger().warn(new StringBuilder().append((Object)"Warning there are new collection codes in the set: ").append((Object)unknownCollections.mkString(",")).toString());
            }
            this.logger().info(new StringBuilder().append((Object)"There are ").append((Object)BoxesRunTime.boxToInteger((int)count)).append((Object)" records in the file. The number of NEW records: ").append((Object)BoxesRunTime.boxToInteger((int)newCount)).toString());
        }
        Config$.MODULE$.occurrenceDAO().addRawOccurrenceBatch((FullRecord[])currentBatch.toArray(ClassTag$.MODULE$.apply(FullRecord.class)));
        this.logger().info(new StringBuilder().append((Object)"Finished DwCA loader. Records processed: ").append((Object)BoxesRunTime.boxToInteger((int)count)).toString());
    }

    public Seq<Multimedia> loadMultimedia(StarRecord star, org.gbif.dwc.terms.Term rowType, URL imageBase) {
        if (star.hasExtension(rowType)) {
            Buffer records = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(star.extension(rowType)).asScala();
            ListBuffer multimedia = new ListBuffer();
            records.foreach((Function1)new Serializable(this, imageBase, multimedia){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DwCALoader $outer;
                private final URL imageBase$1;
                private final ListBuffer multimedia$1;

                public final Object apply(Record row) {
                    Option<URL> option;
                    block4: {
                        Object object;
                        block3: {
                            block2: {
                                Set terms = (Set)JavaConversions$.MODULE$.asScalaSet(row.terms()).filter((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final Record row$1;

                                    public final boolean apply(org.gbif.dwc.terms.Term term) {
                                        return Option$.MODULE$.apply((Object)this.row$1.value(term)).isDefined();
                                    }
                                    {
                                        this.row$1 = row$1;
                                    }
                                });
                                scala.collection.immutable.Map metadata = ((TraversableOnce)terms.map((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final Record row$1;

                                    public final Tuple2<org.gbif.dwc.terms.Term, String> apply(org.gbif.dwc.terms.Term term) {
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)term), (Object)this.row$1.value(term));
                                    }
                                    {
                                        this.row$1 = row$1;
                                    }
                                }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                                option = this.$outer.locateMultimedia(row, this.imageBase$1);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                URL location = (URL)some.x();
                                object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.multimedia$1).add(Multimedia$.MODULE$.create(location, (scala.collection.immutable.Map<org.gbif.dwc.terms.Term, String>)metadata)));
                                break block3;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<URL> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                            this.$outer.logger().debug("No location found for row");
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    throw new MatchError(option);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.imageBase$1 = imageBase$1;
                    this.multimedia$1 = multimedia$1;
                }
            });
            return multimedia;
        }
        return List$.MODULE$.empty();
    }

    public Option<URL> locateMultimedia(Record row, URL imageBase) {
        String identifier = row.value((org.gbif.dwc.terms.Term)DcTerm.identifier);
        return identifier == null ? None$.MODULE$ : new Some((Object)new URL(imageBase, identifier));
    }

    public DwCALoader() {
        DataLoader$class.$init$(this);
    }
}

