/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.AbstractResultSetHandler;
import com.mockrunner.jdbc.ParameterSets;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.jdbc.SQLStatementMatcher;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractParameterResultSetHandler
extends AbstractResultSetHandler {
    private boolean exactMatchParameter = false;
    private Map resultSetsForStatement = new HashMap();
    private Map updateCountForStatement = new HashMap();
    private Map throwsSQLException = new HashMap();
    private Map executedStatementParameters = new HashMap();

    public void addParameterMapForExecutedStatement(String string, Map map) {
        if (null != map) {
            if (null == this.executedStatementParameters.get(string)) {
                this.executedStatementParameters.put(string, new ParameterSets(string));
            }
            ParameterSets parameterSets = (ParameterSets)this.executedStatementParameters.get(string);
            parameterSets.addParameterSet(map);
        }
    }

    public ParameterSets getParametersForExecutedStatement(String string) {
        return (ParameterSets)this.executedStatementParameters.get(string);
    }

    public Map getExecutedStatementParameter() {
        return Collections.unmodifiableMap(this.executedStatementParameters);
    }

    public void setExactMatchParameter(boolean bl) {
        this.exactMatchParameter = bl;
    }

    public Integer getUpdateCount(String string, Map map) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.updateCountForStatement, string, true, true);
        for (int i = 0; i < list.size(); ++i) {
            MockUpdateCountWrapper mockUpdateCountWrapper = (MockUpdateCountWrapper)list.get(i);
            if (!this.doParameterMatch(mockUpdateCountWrapper.getParamters(), map)) continue;
            return mockUpdateCountWrapper.getUpdateCount();
        }
        return null;
    }

    public MockResultSet getResultSet(String string, Map map) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.resultSetsForStatement, string, true, true);
        for (int i = 0; i < list.size(); ++i) {
            MockResultSetWrapper mockResultSetWrapper = (MockResultSetWrapper)list.get(i);
            if (!this.doParameterMatch(mockResultSetWrapper.getParamters(), map)) continue;
            return mockResultSetWrapper.getResultSet();
        }
        return null;
    }

    public boolean getThrowsSQLException(String string, Map map) {
        return this.getSQLException(string, map) != null;
    }

    public SQLException getSQLException(String string, Map map) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.throwsSQLException, string, true, true);
        for (int i = 0; i < list.size(); ++i) {
            MockSQLExceptionWrapper mockSQLExceptionWrapper = (MockSQLExceptionWrapper)list.get(i);
            if (!this.doParameterMatch(mockSQLExceptionWrapper.getParamters(), map)) continue;
            return mockSQLExceptionWrapper.getException();
        }
        return null;
    }

    protected boolean doParameterMatch(Map map, Map map2) {
        if (this.exactMatchParameter) {
            if (map2.size() != map.size()) {
                return false;
            }
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!map2.containsKey(k)) {
                    return false;
                }
                Object v = map.get(k);
                if (ParameterUtil.compareParameter(map2.get(k), v)) continue;
                return false;
            }
            return true;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!map2.containsKey(k)) {
                return false;
            }
            Object v = map2.get(k);
            if (ParameterUtil.compareParameter(v, map.get(k))) continue;
            return false;
        }
        return true;
    }

    public void clearResultSets() {
        super.clearResultSets();
        this.resultSetsForStatement.clear();
    }

    public void clearUpdateCounts() {
        super.clearUpdateCounts();
        this.updateCountForStatement.clear();
    }

    public void clearThrowsSQLException() {
        super.clearThrowsSQLException();
        this.throwsSQLException.clear();
    }

    public void prepareResultSet(String string, MockResultSet mockResultSet, Object[] objectArray) {
        this.prepareResultSet(string, mockResultSet, ArrayUtil.getListFromObjectArray(objectArray));
    }

    public void prepareResultSet(String string, MockResultSet mockResultSet, List list) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(new Integer(i + 1), list.get(i));
        }
        this.prepareResultSet(string, mockResultSet, hashMap);
    }

    public void prepareResultSet(String string, MockResultSet mockResultSet, Map map) {
        ArrayList<MockResultSetWrapper> arrayList = (ArrayList<MockResultSetWrapper>)this.resultSetsForStatement.get(string);
        if (null == arrayList) {
            arrayList = new ArrayList<MockResultSetWrapper>();
            this.resultSetsForStatement.put(string, arrayList);
        }
        arrayList.add(new MockResultSetWrapper(mockResultSet, new HashMap(map)));
    }

    public void prepareThrowsSQLException(String string, Object[] objectArray) {
        SQLException sQLException = new SQLException("Statement " + string + " was specified to throw an exception");
        this.prepareThrowsSQLException(string, sQLException, objectArray);
    }

    public void prepareThrowsSQLException(String string, List list) {
        SQLException sQLException = new SQLException("Statement " + string + " was specified to throw an exception");
        this.prepareThrowsSQLException(string, sQLException, list);
    }

    public void prepareThrowsSQLException(String string, Map map) {
        SQLException sQLException = new SQLException("Statement " + string + " was specified to throw an exception");
        this.prepareThrowsSQLException(string, sQLException, map);
    }

    public void prepareThrowsSQLException(String string, SQLException sQLException, Object[] objectArray) {
        this.prepareThrowsSQLException(string, sQLException, ArrayUtil.getListFromObjectArray(objectArray));
    }

    public void prepareThrowsSQLException(String string, SQLException sQLException, List list) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(new Integer(i + 1), list.get(i));
        }
        this.prepareThrowsSQLException(string, sQLException, hashMap);
    }

    public void prepareThrowsSQLException(String string, SQLException sQLException, Map map) {
        ArrayList<MockSQLExceptionWrapper> arrayList = (ArrayList<MockSQLExceptionWrapper>)this.throwsSQLException.get(string);
        if (null == arrayList) {
            arrayList = new ArrayList<MockSQLExceptionWrapper>();
            this.throwsSQLException.put(string, arrayList);
        }
        arrayList.add(new MockSQLExceptionWrapper(sQLException, new HashMap(map)));
    }

    public void prepareUpdateCount(String string, int n, Object[] objectArray) {
        this.prepareUpdateCount(string, n, ArrayUtil.getListFromObjectArray(objectArray));
    }

    public void prepareUpdateCount(String string, int n, List list) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(new Integer(i + 1), list.get(i));
        }
        this.prepareUpdateCount(string, n, hashMap);
    }

    public void prepareUpdateCount(String string, int n, Map map) {
        ArrayList<MockUpdateCountWrapper> arrayList = (ArrayList<MockUpdateCountWrapper>)this.updateCountForStatement.get(string);
        if (null == arrayList) {
            arrayList = new ArrayList<MockUpdateCountWrapper>();
            this.updateCountForStatement.put(string, arrayList);
        }
        arrayList.add(new MockUpdateCountWrapper(n, new HashMap(map)));
    }

    private class MockUpdateCountWrapper {
        private Integer updateCount;
        private Map parameters;

        public MockUpdateCountWrapper(int n, Map map) {
            this.updateCount = new Integer(n);
            this.parameters = map;
        }

        public Map getParamters() {
            return this.parameters;
        }

        public Integer getUpdateCount() {
            return this.updateCount;
        }
    }

    private class MockResultSetWrapper {
        private MockResultSet resultSet;
        private Map parameters;

        public MockResultSetWrapper(MockResultSet mockResultSet, Map map) {
            this.resultSet = mockResultSet;
            this.parameters = map;
        }

        public Map getParamters() {
            return this.parameters;
        }

        public MockResultSet getResultSet() {
            return this.resultSet;
        }
    }

    private class MockSQLExceptionWrapper {
        private SQLException exception;
        private Map parameters;

        public MockSQLExceptionWrapper(SQLException sQLException, Map map) {
            this.exception = sQLException;
            this.parameters = map;
        }

        public Map getParamters() {
            return this.parameters;
        }

        public SQLException getException() {
            return this.exception;
        }
    }
}

