/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import au.org.ala.names.parser.PhraseNameParser;
import au.org.ala.sds.dao.SensitiveSpeciesMySqlDao;
import au.org.ala.sds.model.ConservationInstance;
import au.org.ala.sds.model.PlantPestInstance;
import au.org.ala.sds.model.SDSSpeciesListDTO;
import au.org.ala.sds.model.SDSSpeciesListItemDTO;
import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.model.SensitivityInstance;
import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.model.SensitivityZoneFactory;
import au.org.ala.sds.util.SpeciesListUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.gbif.ecat.model.ParsedName;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class SensitiveSpeciesXmlBuilder {
    static final Logger logger = Logger.getLogger(SensitiveSpeciesXmlBuilder.class);

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            if (args[0].equals("-db")) {
                SensitiveSpeciesXmlBuilder.generateFromDatabase();
            } else if (args[0].equals("-ws")) {
                OutputStream outputStream = args.length > 1 ? new FileOutputStream(new File(args[1])) : System.out;
                SensitiveSpeciesXmlBuilder.generateFromWebservices(outputStream, null);
            }
        } else {
            System.out.println("Usage: \n-db : build from database\n-ws : build from ws and write to standard out\n-ws <filename> build from ws and write to supplied file");
        }
    }

    private static boolean hasListsChanged(Collection<SDSSpeciesListDTO> lists, Date date) {
        for (SDSSpeciesListDTO list : lists) {
            if (!list.getDateUpdated().after(date)) continue;
            return true;
        }
        return false;
    }

    public static boolean generateFromWebservices(OutputStream out, Date lastGenerateDate) {
        Document doc = new Document();
        Element root = new Element("sensitiveSpeciesList");
        doc.setRootElement(root);
        PhraseNameParser parser = new PhraseNameParser();
        Map<String, SDSSpeciesListDTO> sdsLists = SpeciesListUtil.getSDSLists();
        if (lastGenerateDate != null && !SensitiveSpeciesXmlBuilder.hasListsChanged(sdsLists.values(), lastGenerateDate)) {
            return false;
        }
        List<SDSSpeciesListItemDTO> guidItems = SpeciesListUtil.getSDSListItems(true);
        if (sdsLists.isEmpty() || guidItems == null || guidItems.isEmpty()) {
            return false;
        }
        String currentGuid = "";
        ArrayList<String> resources = new ArrayList<String>();
        Element sensitiveSpecies = null;
        Element instances = null;
        for (SDSSpeciesListItemDTO item : guidItems) {
            if (!currentGuid.equals(item.getGuid())) {
                if (instances != null) {
                    sensitiveSpecies.addContent(instances);
                }
                instances = new Element("instances");
                sensitiveSpecies = new Element("sensitiveSpecies");
                sensitiveSpecies.setAttribute("name", item.getName());
                sensitiveSpecies.setAttribute("family", item.getFamily() != null ? item.getFamily() : "");
                String rank = "UNKNOWN";
                try {
                    ParsedName pn = parser.parse(item.getName());
                    if (pn != null && pn.getRank() != null) {
                        rank = pn.getRank().toString().toUpperCase();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to get rank for " + item.getName()), (Throwable)e);
                }
                sensitiveSpecies.setAttribute("guid", item.getGuid());
                sensitiveSpecies.setAttribute("rank", rank);
                String commonName = item.getKVPValue(SDSSpeciesListItemDTO.commonNameLabels);
                sensitiveSpecies.setAttribute("commonName", commonName != null ? commonName : "");
                root.addContent((Content)sensitiveSpecies);
                currentGuid = item.getGuid();
                resources.clear();
            }
            if (resources.contains(item.getDataResourceUid())) continue;
            resources.add(item.getDataResourceUid());
            SensitiveSpeciesXmlBuilder.addInstanceInformation(sdsLists, item, instances);
        }
        sensitiveSpecies.addContent(instances);
        List<SDSSpeciesListItemDTO> unmatchedItems = SpeciesListUtil.getSDSListItems(false);
        String currentName = "";
        sensitiveSpecies = null;
        instances = null;
        resources.clear();
        for (SDSSpeciesListItemDTO item : unmatchedItems) {
            if (!currentName.equals(item.getName())) {
                if (instances != null && sensitiveSpecies != null) {
                    sensitiveSpecies.addContent((Content)instances);
                }
                instances = new Element("instances");
                sensitiveSpecies = new Element("sensitiveSpecies");
                sensitiveSpecies.setAttribute("name", item.getName());
                sensitiveSpecies.setAttribute("family", item.getFamily() != null ? item.getFamily() : "");
                String rank = "UNKNOWN";
                try {
                    rank = parser.parse(item.getName()).getRank().toString().toUpperCase();
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to get rank for " + item.getName()), (Throwable)e);
                }
                sensitiveSpecies.setAttribute("rank", rank);
                String commonName = item.getKVPValue(SDSSpeciesListItemDTO.commonNameLabels);
                sensitiveSpecies.setAttribute("commonName", commonName != null ? commonName : "");
                root.addContent((Content)sensitiveSpecies);
                currentName = item.getName();
                resources.clear();
            }
            if (resources.contains(item.getDataResourceUid())) continue;
            resources.add(item.getDataResourceUid());
            SensitiveSpeciesXmlBuilder.addInstanceInformation(sdsLists, item, instances);
        }
        sensitiveSpecies.addContent((Content)instances);
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            xmlOutputter.output(doc, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void addInstanceInformation(Map<String, SDSSpeciesListDTO> sdsLists, SDSSpeciesListItemDTO item, Element instances) {
        String remarks;
        SDSSpeciesListDTO list = sdsLists.get(item.getDataResourceUid());
        boolean isConservation = "CONSERVATION".equals(list.getSdsType());
        boolean isStateBased = "PBC6".equals(list.getCategory());
        Element instance = isConservation ? new Element("conservationInstance") : new Element("plantPestInstance");
        String category = item.getKVPValue("category");
        if (category == null) {
            category = list.getCategory();
        }
        instance.setAttribute("category", category != null ? category : "");
        instance.setAttribute("authority", list.getAuthority() != null ? list.getAuthority() : "");
        instance.setAttribute("dataResourceId", list.getDataResourceUid());
        String reason = item.getKVPValue("reason");
        if (reason != null) {
            instance.setAttribute("reason", reason);
        }
        if ((remarks = item.getKVPValue("remarks")) != null) {
            instance.setAttribute("remarks", remarks);
        }
        if (isConservation) {
            String generalisation = item.getKVPValue("generalisation");
            if (generalisation == null) {
                generalisation = list.getGeneralisation();
            }
            instance.setAttribute("generalisation", generalisation);
        } else {
            String fromDate = item.getKVPValue("fromDate");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            fromDate = fromDate != null ? dateFormat.format(fromDate) : "";
            instance.setAttribute("fromDate", fromDate);
            String toDate = item.getKVPValue("toDate");
            toDate = toDate != null ? dateFormat.format(toDate) : "";
            instance.setAttribute("toDate", toDate);
        }
        if (isStateBased && StringUtils.isBlank((CharSequence)list.getRegion())) {
            for (Map<String, String> kvp : item.getKvpValues()) {
                SensitivityZone zone = SensitivityZoneFactory.getZone(kvp.get("key").toUpperCase());
                if (zone == null) continue;
                Element newInstance = (Element)instance.clone();
                newInstance.setAttribute("zone", zone.getId());
                instances.addContent((Content)newInstance);
            }
        } else {
            instance.setAttribute("zone", list.getRegion() != null ? list.getRegion() : "AUS");
            instances.addContent((Content)instance);
        }
    }

    public static void generateFromDatabase() throws Exception {
        Document doc = new Document();
        Element root = new Element("sensitiveSpeciesList");
        doc.setRootElement(root);
        SensitiveSpeciesMySqlDao dao = null;
        try {
            dao = new SensitiveSpeciesMySqlDao(SensitiveSpeciesXmlBuilder.getDataSource());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<SensitiveTaxon> species = dao.getAll();
        Collections.sort(species);
        String currentName = "";
        Element sensitiveSpecies = null;
        for (SensitiveTaxon st : species) {
            if (!st.getTaxonName().equalsIgnoreCase(currentName)) {
                sensitiveSpecies = new Element("sensitiveSpecies");
                sensitiveSpecies.setAttribute("name", st.getTaxonName());
                sensitiveSpecies.setAttribute("family", st.getFamily());
                sensitiveSpecies.setAttribute("rank", st.getRank().name());
                sensitiveSpecies.setAttribute("commonName", st.getCommonName() != null ? st.getCommonName() : "");
                root.addContent((Content)sensitiveSpecies);
                currentName = st.getTaxonName();
            }
            Element instances = new Element("instances");
            List<SensitivityInstance> sis = st.getInstances();
            for (SensitivityInstance si : sis) {
                Element instance = null;
                if (si instanceof ConservationInstance) {
                    instance = new Element("conservationInstance");
                } else if (si instanceof PlantPestInstance) {
                    instance = new Element("plantPestInstance");
                }
                instance.setAttribute("category", si.getCategory().getId());
                instance.setAttribute("authority", si.getAuthority());
                instance.setAttribute("dataResourceId", si.getDataResourceId());
                instance.setAttribute("zone", si.getZone().getId());
                if (si.getReason() != null) {
                    instance.setAttribute("reason", si.getReason());
                }
                if (si.getRemarks() != null) {
                    instance.setAttribute("remarks", si.getRemarks());
                }
                if (si instanceof ConservationInstance) {
                    instance.setAttribute("generalisation", ((ConservationInstance)si).getLocationGeneralisation());
                } else if (si instanceof PlantPestInstance) {
                    String fromDate = "";
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    if (((PlantPestInstance)si).getFromDate() != null) {
                        fromDate = dateFormat.format(((PlantPestInstance)si).getFromDate());
                    }
                    instance.setAttribute("fromDate", fromDate);
                    String toDate = "";
                    if (((PlantPestInstance)si).getToDate() != null) {
                        toDate = dateFormat.format(((PlantPestInstance)si).getToDate());
                    }
                    instance.setAttribute("toDate", toDate);
                }
                instances.addContent((Content)instance);
            }
            sensitiveSpecies.addContent((Content)instances);
        }
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            xmlOutputter.output(doc, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static DataSource getDataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("com.mysql.jdbc.Driver");
        dataSource.setUrl("jdbc:mysql://localhost/portal");
        dataSource.setUsername("root");
        dataSource.setPassword("password");
        return dataSource;
    }
}

