/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.model;

import au.org.ala.sds.model.PlantPestInstance;
import au.org.ala.sds.model.SensitivityCategory;
import au.org.ala.sds.model.SensitivityInstance;
import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.model.SensitivityZoneFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

public class SensitiveTaxon
implements Serializable,
Comparable<SensitiveTaxon> {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = Logger.getLogger(SensitiveTaxon.class);
    private final String name;
    private String family;
    private String commonName;
    private final Rank rank;
    private String acceptedName;
    private SensitiveTaxon acceptedTaxon;
    private String lsid;
    private final List<SensitivityInstance> instances;

    public SensitiveTaxon(String taxon, Rank rank) {
        this.name = taxon;
        this.rank = rank;
        this.instances = new ArrayList<SensitivityInstance>();
    }

    public String getName() {
        return this.name;
    }

    public String getFamily() {
        return this.family == null ? "" : this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public Rank getRank() {
        return this.rank;
    }

    public String getTaxonName() {
        if (StringUtils.isNotBlank((String)this.acceptedName)) {
            return this.acceptedName;
        }
        return this.name;
    }

    public String getAcceptedName() {
        return this.acceptedName;
    }

    public void setAcceptedName(String acceptedName) {
        this.acceptedName = acceptedName;
    }

    public SensitiveTaxon getAcceptedTaxon() {
        return this.acceptedTaxon;
    }

    public void setAcceptedTaxon(SensitiveTaxon acceptedTaxon) {
        this.acceptedTaxon = acceptedTaxon;
    }

    public List<SensitivityInstance> getInstances() {
        if (this.acceptedTaxon == null) {
            return this.instances;
        }
        return this.acceptedTaxon.getInstances();
    }

    public String getLsid() {
        return this.lsid;
    }

    public void setLsid(String lsid) {
        this.lsid = lsid;
    }

    public boolean isConservation() {
        return this.getSensitivityCategoryType() == SensitivityCategory.CategoryType.CONSERVATION;
    }

    public boolean isPlantPest() {
        return this.getSensitivityCategoryType() == SensitivityCategory.CategoryType.PLANT_PEST;
    }

    public SensitivityCategory.CategoryType getSensitivityCategoryType() {
        return this.instances.get(0).getCategory().getType();
    }

    public boolean isSensitiveForZone(SensitivityZone zone) {
        for (SensitivityInstance si : this.getInstances()) {
            if (!zone.equals(si.getZone())) continue;
            return true;
        }
        return false;
    }

    public boolean isDateRequired() {
        for (SensitivityInstance si : this.getInstances()) {
            if (!(si instanceof PlantPestInstance) || ((PlantPestInstance)si).getFromDate() == null && ((PlantPestInstance)si).getToDate() == null) continue;
            return true;
        }
        return false;
    }

    public List<SensitivityInstance> getInstancesForZones(List<SensitivityZone> zones) {
        ArrayList<SensitivityInstance> instanceList = new ArrayList<SensitivityInstance>();
        for (SensitivityInstance si : this.getInstances()) {
            if (zones.contains(si.getZone())) {
                instanceList.add(si);
                continue;
            }
            if (!si.getZone().equals(SensitivityZoneFactory.getZone("AUS")) || !SensitivityZone.isInAustralia(zones)) continue;
            instanceList.add(si);
        }
        return instanceList;
    }

    public SensitivityInstance getSensitivityInstance(String state) {
        return this.getInstanceForState(SensitivityZoneFactory.getZone(state));
    }

    public SensitivityInstance getInstanceForState(SensitivityZone state) {
        SensitivityInstance instance = null;
        SensitivityInstance ausInstance = null;
        for (SensitivityInstance si : this.getInstances()) {
            if (state == si.getZone()) {
                instance = si;
                continue;
            }
            if (si.getZone() != SensitivityZoneFactory.getZone("AUS")) continue;
            ausInstance = si;
        }
        if (instance == null) {
            instance = ausInstance;
        }
        return instance;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.family).append((Object)this.rank).append((Object)this.commonName).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SensitiveTaxon other = (SensitiveTaxon)obj;
        return this.name.equals(other.name);
    }

    @Override
    public int compareTo(SensitiveTaxon st) {
        return this.name.compareTo(st.name);
    }

    public String toString() {
        return this.getTaxonName() + " (" + (Object)((Object)this.rank) + ")";
    }

    public static enum Rank {
        SUBSPECIES,
        SPECIES,
        GENUS,
        FAMILY,
        UNKNOWN,
        INFRASPECIFICNAME,
        CULTIVAR,
        FORM,
        VARIETY,
        SUBVARIETY,
        SUPERFAMILY,
        SUBFAMILY;

    }
}

