/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.MismatchedSizeException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.AffineTransformBuilder;
import org.geotools.referencing.operation.builder.MapTriangulationFactory;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.MathTransformBuilder;
import org.geotools.referencing.operation.builder.Quadrilateral;
import org.geotools.referencing.operation.builder.RubberSheetTransform;
import org.geotools.referencing.operation.builder.TINTriangle;
import org.geotools.referencing.operation.builder.TriangulationException;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubberSheetBuilder
extends MathTransformBuilder {
    private HashMap trianglesMap;
    private HashMap trianglesToKeysMap;

    public RubberSheetBuilder(List<MappedPosition> vectors, List<DirectPosition> vertices) throws MismatchedSizeException, MismatchedDimensionException, MismatchedReferenceSystemException, TriangulationException {
        CoordinateReferenceSystem crs;
        super.setMappedPositions(vectors);
        if (vertices.size() != 4) {
            throw new IllegalArgumentException("The region of interest must have four vertices.");
        }
        DirectPosition[] ddpp = new DirectPosition[4];
        for (int i = 0; i < vertices.size(); ++i) {
            ddpp[i] = vertices.get(i);
        }
        try {
            crs = this.getSourceCRS();
        }
        catch (FactoryException e) {
            crs = ddpp[0].getCoordinateReferenceSystem();
        }
        if (!(CRS.equalsIgnoreMetadata(crs, ddpp[0].getCoordinateReferenceSystem()) || CRS.equalsIgnoreMetadata(crs, ddpp[1].getCoordinateReferenceSystem()) || CRS.equalsIgnoreMetadata(crs, ddpp[2].getCoordinateReferenceSystem()) || CRS.equalsIgnoreMetadata(crs, ddpp[3].getCoordinateReferenceSystem()))) {
            throw new MismatchedReferenceSystemException("Region of interest defined by mismatched DirectPositions.");
        }
        DirectPosition[] dpa = this.getSourcePoints();
        GeneralEnvelope srcextnt = new GeneralEnvelope(2);
        for (int i = 0; i < dpa.length; ++i) {
            srcextnt.add(dpa[i]);
        }
        GeneralEnvelope vtxextnt = new GeneralEnvelope(2);
        vtxextnt.add(ddpp[0]);
        vtxextnt.add(ddpp[1]);
        vtxextnt.add(ddpp[2]);
        vtxextnt.add(ddpp[3]);
        if (!vtxextnt.contains(srcextnt, true)) {
            throw new IllegalArgumentException("The region of interest must contain the control points");
        }
        Quadrilateral quad = new Quadrilateral(ddpp[0], ddpp[1], ddpp[2], ddpp[3]);
        MapTriangulationFactory trianglemap = new MapTriangulationFactory(quad, vectors);
        this.trianglesMap = (HashMap)trianglemap.getTriangleMap();
        this.trianglesToKeysMap = this.mapTrianglesToKey();
    }

    @Override
    public int getMinimumPointCount() {
        return 1;
    }

    public HashMap getMapTriangulation() {
        return this.trianglesMap;
    }

    @Override
    protected MathTransform computeMathTransform() throws FactoryException {
        return new RubberSheetTransform(this.trianglesToKeysMap);
    }

    private HashMap mapTrianglesToKey() {
        HashMap trianglesToKeysMap = (HashMap)this.trianglesMap.clone();
        for (Map.Entry entry : trianglesToKeysMap.entrySet()) {
            ArrayList<MappedPosition> pts = new ArrayList<MappedPosition>();
            for (int i = 1; i <= 3; ++i) {
                pts.add(new MappedPosition(((TINTriangle)entry.getKey()).getPoints()[i], ((TINTriangle)entry.getValue()).getPoints()[i]));
            }
            try {
                AffineTransformBuilder calculator = new AffineTransformBuilder(pts);
                entry.setValue(calculator.getMathTransform());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return trianglesToKeysMap;
    }
}

