/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieProject
implements KieProject {
    private static final Logger log = LoggerFactory.getLogger(KieProject.class);
    protected final Map<String, KieBaseModel> kBaseModels = new HashMap<String, KieBaseModel>();
    private KieBaseModel defaultKieBase = null;
    private KieSessionModel defaultKieSession = null;
    private KieSessionModel defaultStatelessKieSession = null;
    protected final Map<String, KieSessionModel> kSessionModels = new HashMap<String, KieSessionModel>();

    @Override
    public ResultsImpl verify() {
        ResultsImpl messages = new ResultsImpl();
        this.verify(messages);
        return messages;
    }

    public void verify(ResultsImpl messages) {
        for (KieBaseModel model : this.kBaseModels.values()) {
            AbstractKieModule.buildKnowledgePackages((KieBaseModelImpl)model, this, messages);
        }
    }

    @Override
    public KieBaseModel getDefaultKieBaseModel() {
        return this.defaultKieBase;
    }

    @Override
    public KieSessionModel getDefaultKieSession() {
        return this.defaultKieSession;
    }

    @Override
    public KieSessionModel getDefaultStatelessKieSession() {
        return this.defaultStatelessKieSession;
    }

    @Override
    public KieBaseModel getKieBaseModel(String kBaseName) {
        return this.kBaseModels.get(kBaseName);
    }

    @Override
    public KieSessionModel getKieSessionModel(String kSessionName) {
        return this.kSessionModels.get(kSessionName);
    }

    protected void indexParts(Collection<InternalKieModule> kieModules, Map<String, InternalKieModule> kJarFromKBaseName) {
        for (InternalKieModule kJar : kieModules) {
            KieModuleModel kieProject = kJar.getKieModuleModel();
            for (KieBaseModel kieBaseModel : kieProject.getKieBaseModels().values()) {
                if (kieBaseModel.isDefault()) {
                    if (this.defaultKieBase == null) {
                        this.defaultKieBase = kieBaseModel;
                    } else {
                        this.defaultKieBase = null;
                        log.warn("Found more than one defualt KieBase: disabling all. KieBases will be accessible only by name");
                    }
                }
                this.kBaseModels.put(kieBaseModel.getName(), kieBaseModel);
                ((KieBaseModelImpl)kieBaseModel).setKModule(kieProject);
                kJarFromKBaseName.put(kieBaseModel.getName(), kJar);
                for (KieSessionModel kieSessionModel : kieBaseModel.getKieSessionModels().values()) {
                    if (kieSessionModel.isDefault()) {
                        if (kieSessionModel.getType() == KieSessionModel.KieSessionType.STATEFUL) {
                            if (this.defaultKieSession == null) {
                                this.defaultKieSession = kieSessionModel;
                            } else {
                                this.defaultKieSession = null;
                                log.warn("Found more than one defualt KieSession: disabling all. KieSessions will be accessible only by name");
                            }
                        } else if (this.defaultStatelessKieSession == null) {
                            this.defaultStatelessKieSession = kieSessionModel;
                        } else {
                            this.defaultStatelessKieSession = null;
                            log.warn("Found more than one defualt StatelessKieSession: disabling all. StatelessKieSessions will be accessible only by name");
                        }
                    }
                    ((KieSessionModelImpl)kieSessionModel).setKBase(kieBaseModel);
                    this.kSessionModels.put(kieSessionModel.getName(), kieSessionModel);
                }
            }
        }
    }

    protected void cleanIndex() {
        this.kBaseModels.clear();
        this.kSessionModels.clear();
        this.defaultKieBase = null;
        this.defaultKieSession = null;
        this.defaultStatelessKieSession = null;
    }
}

