/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.filter.LiteralExpression;
import org.geotools.styling.Displacement;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.opengis.filter.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UomRescaleStyleVisitor
extends DuplicatingStyleVisitor {
    private double mapScale = 1.0;

    public UomRescaleStyleVisitor(double mapScale) {
        if (mapScale <= 0.0) {
            throw new IllegalArgumentException("The mapScale is out of range. Value is " + Double.toString(mapScale) + ". It must be positive.");
        }
        this.mapScale = mapScale;
    }

    protected double computeRescaleMultiplier(double mapScale, Unit<Length> uom) {
        if (uom == null || uom.equals((Object)NonSI.PIXEL)) {
            return 1.0;
        }
        UnitConverter converter = uom.getConverterTo(SI.METER);
        return converter.convert(mapScale);
    }

    protected Expression rescale(Expression unscaled, double mapScale, Unit<Length> uom) {
        if (unscaled == null || unscaled.equals(Expression.NIL)) {
            return unscaled;
        }
        if (unscaled instanceof LiteralExpression && unscaled.evaluate(null, Double.class) != null) {
            double rescaled = this.rescale((Double)unscaled.evaluate(null, Double.class), mapScale, uom);
            return this.ff.literal(rescaled);
        }
        double rescaleMultiplier = this.computeRescaleMultiplier(mapScale, uom);
        return this.ff.multiply(unscaled, (Expression)this.ff.literal(rescaleMultiplier));
    }

    protected double rescale(double unscaled, double mapScale, Unit<Length> uom) {
        return unscaled * this.computeRescaleMultiplier(mapScale, uom);
    }

    protected float[] rescale(float[] dashArray, double mapScale, Unit<Length> unitOfMeasure) {
        if (dashArray == null) {
            return null;
        }
        if (unitOfMeasure == null || unitOfMeasure.equals((Object)NonSI.PIXEL)) {
            return dashArray;
        }
        float[] rescaledDashArray = new float[dashArray.length];
        for (int i = 0; i < rescaledDashArray.length; ++i) {
            rescaledDashArray[i] = (float)this.rescale(dashArray[i], mapScale, unitOfMeasure);
        }
        return rescaledDashArray;
    }

    protected void rescaleStroke(Stroke stroke, double mapScale, Unit<Length> uom) {
        if (stroke != null) {
            stroke.setWidth(this.rescale(stroke.getWidth(), mapScale, uom));
            stroke.setDashArray(this.rescale(stroke.getDashArray(), mapScale, uom));
            stroke.setDashOffset(this.rescale(stroke.getDashOffset(), mapScale, uom));
        }
    }

    @Override
    public void visit(PointSymbolizer ps) {
        super.visit(ps);
        PointSymbolizer copy = (PointSymbolizer)this.pages.peek();
        Graphic copyGraphic = copy.getGraphic();
        copyGraphic.setSize(this.rescale(copyGraphic.getSize(), this.mapScale, (Unit<Length>)copy.getUnitOfMeasure()));
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    @Override
    public void visit(LineSymbolizer line) {
        super.visit(line);
        LineSymbolizer copy = (LineSymbolizer)this.pages.peek();
        Stroke copyStroke = copy.getStroke();
        this.rescaleStroke(copyStroke, this.mapScale, (Unit<Length>)copy.getUnitOfMeasure());
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    @Override
    public void visit(PolygonSymbolizer poly) {
        super.visit(poly);
        PolygonSymbolizer copy = (PolygonSymbolizer)this.pages.peek();
        Stroke copyStroke = copy.getStroke();
        this.rescaleStroke(copyStroke, this.mapScale, (Unit<Length>)copy.getUnitOfMeasure());
        Fill copyFill = copy.getFill();
        if (copyFill != null) {
            Graphic copyGraphic = copyFill.getGraphicFill();
            if (copyGraphic != null) {
                copyGraphic.setSize(this.rescale(copyGraphic.getSize(), this.mapScale, (Unit<Length>)copy.getUnitOfMeasure()));
                copyFill.setGraphicFill(copyGraphic);
            }
            copy.setFill(copyFill);
        }
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }

    @Override
    public void visit(TextSymbolizer text) {
        Font[] fonts;
        super.visit(text);
        TextSymbolizer copy = (TextSymbolizer)this.pages.peek();
        Unit uom = copy.getUnitOfMeasure();
        for (Font font : fonts = copy.getFonts()) {
            font.setSize(this.rescale(font.getSize(), this.mapScale, (Unit<Length>)uom));
        }
        copy.setFonts(fonts);
        LabelPlacement placement = copy.getLabelPlacement();
        if (placement instanceof PointPlacement) {
            PointPlacement pointPlacement = (PointPlacement)placement;
            Displacement disp = pointPlacement.getDisplacement();
            if (disp != null) {
                disp.setDisplacementX(this.rescale(disp.getDisplacementX(), this.mapScale, (Unit<Length>)uom));
                disp.setDisplacementY(this.rescale(disp.getDisplacementY(), this.mapScale, (Unit<Length>)uom));
                pointPlacement.setDisplacement(disp);
            }
        } else if (placement instanceof LinePlacement) {
            LinePlacement linePlacement = (LinePlacement)placement;
            linePlacement.setGap(this.rescale(linePlacement.getGap(), this.mapScale, (Unit<Length>)uom));
            linePlacement.setInitialGap(this.rescale(linePlacement.getInitialGap(), this.mapScale, (Unit<Length>)uom));
            linePlacement.setPerpendicularOffset(this.rescale(linePlacement.getPerpendicularOffset(), this.mapScale, (Unit<Length>)uom));
        }
        copy.setLabelPlacement(placement);
        if (copy.getHalo() != null) {
            copy.getHalo().setRadius(this.rescale(copy.getHalo().getRadius(), this.mapScale, (Unit<Length>)uom));
        }
        copy.setUnitOfMeasure(NonSI.PIXEL);
    }
}

