/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.TimeZone;
import java.util.logging.Level;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShapefileFeatureWriter;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StorageFile;
import org.geotools.data.shapefile.indexed.FidIndexer;
import org.geotools.data.shapefile.indexed.IndexType;
import org.geotools.data.shapefile.indexed.IndexedFidWriter;
import org.geotools.data.shapefile.indexed.IndexedShapefileAttributeReader;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexedShapefileFeatureWriter
extends ShapefileFeatureWriter
implements FileWriter {
    private IndexedShapefileDataStore indexedShapefileDataStore;
    private IndexedFidWriter fidWriter;
    private String currentFid;

    public IndexedShapefileFeatureWriter(String typeName, ShpFiles shpFiles, IndexedShapefileAttributeReader attsReader, FeatureReader<SimpleFeatureType, SimpleFeature> featureReader, IndexedShapefileDataStore datastore, Charset charset, TimeZone timeZone) throws IOException {
        super(typeName, shpFiles, attsReader, featureReader, charset, timeZone);
        this.indexedShapefileDataStore = datastore;
        if (!datastore.isLocal()) {
            this.fidWriter = IndexedFidWriter.EMPTY_WRITER;
        } else {
            StorageFile storageFile = shpFiles.getStorageFile(ShpFileType.FIX);
            this.storageFiles.put(ShpFileType.FIX, storageFile);
            this.fidWriter = new IndexedFidWriter(shpFiles, storageFile);
        }
    }

    @Override
    public SimpleFeature next() throws IOException {
        if (this.featureReader == null) {
            throw new IOException("Writer closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        long next = this.fidWriter.next();
        this.currentFid = this.getFeatureType().getTypeName() + "." + next;
        SimpleFeature feature = super.next();
        return feature;
    }

    @Override
    protected String nextFeatureId() {
        return this.currentFid;
    }

    @Override
    public void remove() throws IOException {
        this.fidWriter.remove();
        super.remove();
    }

    @Override
    public void write() throws IOException {
        this.fidWriter.write();
        super.write();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fidWriter.close();
        try {
            if (this.shpFiles.isLocal()) {
                if (this.indexedShapefileDataStore.needsGeneration(ShpFileType.FIX)) {
                    FidIndexer.generate(this.shpFiles);
                }
                this.deleteFile(ShpFileType.QIX);
                if (this.indexedShapefileDataStore.treeType == IndexType.QIX) {
                    this.indexedShapefileDataStore.buildQuadTree();
                }
            }
        }
        catch (Throwable e) {
            this.indexedShapefileDataStore.treeType = IndexType.NONE;
            ShapefileDataStoreFactory.LOGGER.log(Level.WARNING, "Error creating Spatial index", e);
        }
    }

    @Override
    protected void doClose() throws IOException {
        super.doClose();
        try {
            this.fidWriter.close();
        }
        catch (Throwable e) {
            this.indexedShapefileDataStore.treeType = IndexType.NONE;
            ShapefileDataStoreFactory.LOGGER.log(Level.WARNING, "Error creating Feature ID index", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(ShpFileType shpFileType) {
        URL url = this.shpFiles.acquireWrite(shpFileType, this);
        try {
            File toDelete = DataUtilities.urlToFile(url);
            if (toDelete.exists()) {
                toDelete.delete();
            }
        }
        finally {
            this.shpFiles.unlockWrite(url, (FileWriter)this);
        }
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }
}

