/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.gbif.api.util.VocabularyUtils;

public enum ContactType {
    TECHNICAL_POINT_OF_CONTACT,
    ADMINISTRATIVE_POINT_OF_CONTACT,
    POINT_OF_CONTACT,
    ORIGINATOR,
    METADATA_AUTHOR,
    PRINCIPAL_INVESTIGATOR,
    AUTHOR,
    CONTENT_PROVIDER,
    CUSTODIAN_STEWARD,
    DISTRIBUTOR,
    EDITOR,
    OWNER,
    PROCESSOR,
    PUBLISHER,
    USER,
    PROGRAMMER,
    DATA_ADMINISTRATOR,
    SYSTEM_ADMINISTRATOR,
    HEAD_OF_DELEGATION,
    TEMPORARY_HEAD_OF_DELEGATION,
    ADDITIONAL_DELEGATE,
    TEMPORARY_DELEGATE,
    REGIONAL_NODE_REPRESENTATIVE,
    NODE_MANAGER,
    NODE_STAFF;

    private static final ImmutableMap<String, ContactType> TYPE_LOOKUP;

    public static ContactType fromString(String contactType) {
        return VocabularyUtils.lookupEnum(contactType, ContactType.class);
    }

    public static ContactType inferType(@Nullable String type) {
        if (type != null) {
            ContactType contactType = (ContactType)((Object)TYPE_LOOKUP.get((Object)type.toLowerCase()));
            if (contactType != null) {
                return contactType;
            }
            return ContactType.fromString(type);
        }
        return null;
    }

    static {
        HashMap<String, ContactType> lookup = new HashMap<String, ContactType>();
        lookup.put("administrative", ADMINISTRATIVE_POINT_OF_CONTACT);
        lookup.put("technical", TECHNICAL_POINT_OF_CONTACT);
        lookup.put("pointofcontact", POINT_OF_CONTACT);
        lookup.put("originator", ORIGINATOR);
        lookup.put("metadataprovider", METADATA_AUTHOR);
        lookup.put("principleinvestigator", PRINCIPAL_INVESTIGATOR);
        lookup.put("author", AUTHOR);
        lookup.put("contentprovider", CONTENT_PROVIDER);
        lookup.put("custodiansteward", CUSTODIAN_STEWARD);
        lookup.put("distributor", DISTRIBUTOR);
        lookup.put("editor", EDITOR);
        lookup.put("owner", OWNER);
        lookup.put("processor", PROCESSOR);
        lookup.put("publisher", PUBLISHER);
        lookup.put("user", USER);
        lookup.put("programmer", PROGRAMMER);
        lookup.put("data administrator", DATA_ADMINISTRATOR);
        lookup.put("system adminsitrator", SYSTEM_ADMINISTRATOR);
        TYPE_LOOKUP = ImmutableMap.copyOf(lookup);
    }
}

