/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry.search;

import java.util.UUID;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.search.FacetedSearchRequest;
import org.gbif.api.model.registry.Tag;
import org.gbif.api.model.registry.search.DatasetSearchParameter;
import org.gbif.api.vocabulary.Continent;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.DatasetSubtype;
import org.gbif.api.vocabulary.DatasetType;

public class DatasetSearchRequest
extends FacetedSearchRequest<DatasetSearchParameter> {
    public DatasetSearchRequest() {
    }

    public DatasetSearchRequest(Pageable page) {
        super(page);
    }

    public DatasetSearchRequest(long offset, int limit) {
        super(offset, limit);
    }

    public void addPublishingCountryFilter(Country country) {
        this.addParameter(DatasetSearchParameter.PUBLISHING_COUNTRY, country.getIso2LetterCode());
    }

    public void addCountryFilter(Country country) {
        this.addParameter(DatasetSearchParameter.COUNTRY, country.getIso2LetterCode());
    }

    public void addContinentFilter(Continent continent) {
        this.addParameter(DatasetSearchParameter.CONTINENT, continent);
    }

    public void addDecadeFilter(int decade) {
        this.addParameter(DatasetSearchParameter.DECADE, decade);
    }

    public void addHostingOrgFilter(UUID orgKey) {
        this.addParameter(DatasetSearchParameter.HOSTING_ORG, orgKey.toString());
    }

    public void addKeywordFilter(String keyword) {
        this.addParameter(DatasetSearchParameter.KEYWORD, keyword);
    }

    public void addKeywordFilter(Tag keyword) {
        this.addParameter(DatasetSearchParameter.KEYWORD, keyword.toString());
    }

    public void addPublishingOrgFilter(UUID orgKey) {
        this.addParameter(DatasetSearchParameter.PUBLISHING_ORG, orgKey.toString());
    }

    public void addSubTypeFilter(DatasetSubtype subtype) {
        this.addParameter(DatasetSearchParameter.SUBTYPE, subtype);
    }

    public void addTypeFilter(DatasetType type) {
        this.addParameter(DatasetSearchParameter.TYPE, type);
    }
}

