/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry.eml.geospatial;

import com.google.common.base.Objects;
import org.gbif.api.model.registry.eml.geospatial.BoundingBox;
import org.gbif.api.model.registry.eml.geospatial.Geometry;

public class GeospatialCoverage
implements Geometry {
    private String description;
    private BoundingBox boundingBox;

    public GeospatialCoverage() {
    }

    public GeospatialCoverage(String description, BoundingBox boundingBox) {
        this.description = description;
        this.boundingBox = boundingBox;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        boundingBox.setGlobalCoverage(boundingBox.getMinLatitude(), boundingBox.getMaxLatitude(), boundingBox.getMinLongitude(), boundingBox.getMaxLongitude());
        this.boundingBox = boundingBox;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toWellKnownText() {
        return this.boundingBox == null ? null : this.boundingBox.toWellKnownText();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeospatialCoverage)) {
            return false;
        }
        GeospatialCoverage that = (GeospatialCoverage)obj;
        return Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.boundingBox, (Object)that.boundingBox);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.description, this.boundingBox});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("description", (Object)this.description).add("boundingBox", (Object)this.boundingBox).toString();
    }
}

