/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence.search;

import java.util.Date;
import java.util.UUID;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.search.SearchRequest;
import org.gbif.api.model.occurrence.search.OccurrenceSearchParameter;
import org.gbif.api.vocabulary.BasisOfRecord;
import org.gbif.api.vocabulary.Continent;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.MediaType;
import org.gbif.api.vocabulary.OccurrenceIssue;
import org.gbif.api.vocabulary.TypeStatus;

public class OccurrenceSearchRequest
extends SearchRequest<OccurrenceSearchParameter> {
    public OccurrenceSearchRequest() {
    }

    public OccurrenceSearchRequest(long offset, int limit) {
        super(offset, limit);
    }

    public OccurrenceSearchRequest(Pageable page) {
        super(page);
    }

    public void addBasisOfRecordFilter(BasisOfRecord basisOfRecord) {
        this.addParameter(OccurrenceSearchParameter.BASIS_OF_RECORD, basisOfRecord);
    }

    public void addTypeStatusFilter(TypeStatus typeStatus) {
        this.addParameter(OccurrenceSearchParameter.TYPE_STATUS, typeStatus);
    }

    public void addCatalogNumberFilter(String catalogNumber) {
        this.addParameter(OccurrenceSearchParameter.CATALOG_NUMBER, catalogNumber);
    }

    public void addRecordedByFilter(String collectorName) {
        this.addParameter(OccurrenceSearchParameter.RECORDED_BY, collectorName);
    }

    public void addRecordNumberFilter(String recordNumber) {
        this.addParameter(OccurrenceSearchParameter.RECORD_NUMBER, recordNumber);
    }

    public void addCountryFilter(Country country) {
        this.addParameter(OccurrenceSearchParameter.COUNTRY, country);
    }

    public void addContinentFilter(Continent continent) {
        this.addParameter(OccurrenceSearchParameter.CONTINENT, continent);
    }

    public void addDatasetKeyFilter(UUID datasetKey) {
        this.addParameter(OccurrenceSearchParameter.DATASET_KEY, datasetKey.toString());
    }

    public void addGeometryFilter(String geometryAsWkt) {
        this.addParameter(OccurrenceSearchParameter.GEOMETRY, geometryAsWkt);
    }

    public void addDecimalLatitudeFilter(double latitude) {
        this.addParameter(OccurrenceSearchParameter.DECIMAL_LATITUDE, latitude);
    }

    public void addDecimalLongitudeFilter(double longitude) {
        this.addParameter(OccurrenceSearchParameter.DECIMAL_LONGITUDE, longitude);
    }

    public void addMonthFilter(int month) {
        this.addParameter(OccurrenceSearchParameter.MONTH, month);
    }

    public void addTaxonKeyFilter(int taxonKey) {
        this.addParameter(OccurrenceSearchParameter.TAXON_KEY, taxonKey);
    }

    public void addYearFilter(int year) {
        this.addParameter(OccurrenceSearchParameter.YEAR, year);
    }

    public void addEventDateFilter(Date date) {
        this.addParameter(OccurrenceSearchParameter.EVENT_DATE, date);
    }

    public void addLastInterpretedFilter(Date modified) {
        this.addParameter(OccurrenceSearchParameter.LAST_INTERPRETED, modified);
    }

    public void addPublishingCountryFilter(Country country) {
        this.addParameter(OccurrenceSearchParameter.PUBLISHING_COUNTRY, country);
    }

    public void addInstitutionCodeFilter(String code) {
        this.addParameter(OccurrenceSearchParameter.INSTITUTION_CODE, code);
    }

    public void addHasCoordinateFilter(boolean hasCoordinate) {
        this.addParameter(OccurrenceSearchParameter.HAS_COORDINATE, hasCoordinate);
    }

    public void addSpatialIssueFilter(boolean hasSpatialIssue) {
        this.addParameter(OccurrenceSearchParameter.HAS_GEOSPATIAL_ISSUE, hasSpatialIssue);
    }

    public void addIssueFilter(OccurrenceIssue issue) {
        this.addParameter(OccurrenceSearchParameter.ISSUE, issue);
    }

    public void addElevationFilter(int elevation) {
        this.addParameter(OccurrenceSearchParameter.ELEVATION, elevation);
    }

    public void addMediaTypeFilter(MediaType mediaType) {
        this.addParameter(OccurrenceSearchParameter.MEDIA_TYPE, mediaType);
    }
}

