/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.crawler;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class ChecklistValidationReport {
    private final int checkedRecords;
    private final boolean allRecordsChecked;
    private final List<String> duplicateIds;
    private final List<Integer> missingIds;
    private String invalidationReason;
    private final boolean valid;

    @JsonCreator
    public ChecklistValidationReport(@JsonProperty(value="checkedRecords") int checkedRecords, @JsonProperty(value="allRecordsChecked") boolean allRecordsChecked, @JsonProperty(value="duplicateIds") List<String> duplicateIds, @JsonProperty(value="missingIds") List<Integer> missingIds) {
        this.checkedRecords = checkedRecords;
        this.allRecordsChecked = allRecordsChecked;
        this.duplicateIds = (List)Preconditions.checkNotNull(duplicateIds, (Object)"duplicateIds cannot be null");
        this.missingIds = (List)Preconditions.checkNotNull(missingIds, (Object)"missingIds cannot be null");
        this.valid = this.validate();
    }

    private boolean validate() {
        if (!this.duplicateIds.isEmpty()) {
            this.invalidationReason = "Non unique taxon ids";
            return false;
        }
        if (!this.missingIds.isEmpty()) {
            this.invalidationReason = "Missing taxon ids";
            return false;
        }
        return true;
    }

    public int getCheckedRecords() {
        return this.checkedRecords;
    }

    public boolean isAllRecordsChecked() {
        return this.allRecordsChecked;
    }

    public List<String> getDuplicateIds() {
        return this.duplicateIds;
    }

    public List<Integer> getMissingIds() {
        return this.missingIds;
    }

    public String getInvalidationReason() {
        return this.invalidationReason;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.checkedRecords, this.allRecordsChecked, this.duplicateIds, this.missingIds, this.invalidationReason, this.valid});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChecklistValidationReport other = (ChecklistValidationReport)obj;
        return Objects.equal((Object)this.checkedRecords, (Object)other.checkedRecords) && Objects.equal((Object)this.allRecordsChecked, (Object)other.allRecordsChecked) && Objects.equal(this.duplicateIds, other.duplicateIds) && Objects.equal(this.missingIds, other.missingIds) && Objects.equal((Object)this.invalidationReason, (Object)other.invalidationReason) && Objects.equal((Object)this.valid, (Object)other.valid);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("checkedRecords", this.checkedRecords).add("duplicateIds", this.duplicateIds).add("missingIds", this.missingIds).add("allRecordsChecked", this.allRecordsChecked).add("invalidationReason", (Object)this.invalidationReason).add("valid", this.valid).toString();
    }
}

