/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.common.LinneanClassification;
import org.gbif.api.model.common.LinneanClassificationKeys;
import org.gbif.api.util.ClassificationUtils;
import org.gbif.api.vocabulary.Rank;

public class NameUsageMatch
implements LinneanClassification,
LinneanClassificationKeys,
Serializable {
    private static final long serialVersionUID = -8927655067465421358L;
    private Integer usageKey;
    private String scientificName;
    private String canonicalName;
    private Rank rank;
    private boolean synonym;
    private Integer confidence;
    private String note;
    private MatchType matchType = MatchType.NONE;
    private List<NameUsageMatch> alternatives;
    private String kingdom;
    private String phylum;
    @JsonProperty(value="class")
    private String clazz;
    private String order;
    private String family;
    private String genus;
    private String subgenus;
    private String species;
    private Integer kingdomKey;
    private Integer phylumKey;
    private Integer classKey;
    private Integer orderKey;
    private Integer familyKey;
    private Integer genusKey;
    private Integer subgenusKey;
    private Integer speciesKey;

    @Min(value=0L)
    @Max(value=100L)
    public Integer getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Integer confidence) {
        this.confidence = confidence;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
    }

    @Nullable
    public Rank getRank() {
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    @Nullable
    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    @Nullable
    public Integer getUsageKey() {
        return this.usageKey;
    }

    public void setUsageKey(Integer usageKey) {
        this.usageKey = usageKey;
    }

    public boolean isSynonym() {
        return this.synonym;
    }

    public void setSynonym(boolean synonym) {
        this.synonym = synonym;
    }

    @Override
    @Nullable
    public String getKingdom() {
        return this.kingdom;
    }

    @Override
    public void setKingdom(String kingdom) {
        this.kingdom = kingdom;
    }

    @Override
    @Nullable
    public String getPhylum() {
        return this.phylum;
    }

    @Override
    public void setPhylum(String phylum) {
        this.phylum = phylum;
    }

    @Override
    @Nullable
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    @Override
    @Nullable
    public String getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    @Nullable
    public String getFamily() {
        return this.family;
    }

    @Override
    public void setFamily(String family) {
        this.family = family;
    }

    @Override
    @Nullable
    public String getGenus() {
        return this.genus;
    }

    @Override
    public void setGenus(String genus) {
        this.genus = genus;
    }

    @Override
    @Nullable
    public String getSubgenus() {
        return this.subgenus;
    }

    @Override
    public void setSubgenus(String subgenus) {
        this.subgenus = subgenus;
    }

    @Override
    @Nullable
    public String getSpecies() {
        return this.species;
    }

    @Override
    public void setSpecies(String species) {
        this.species = species;
    }

    @Override
    @Nullable
    public Integer getKingdomKey() {
        return this.kingdomKey;
    }

    @Override
    public void setKingdomKey(Integer kingdomKey) {
        this.kingdomKey = kingdomKey;
    }

    @Override
    @Nullable
    public Integer getPhylumKey() {
        return this.phylumKey;
    }

    @Override
    public void setPhylumKey(Integer phylumKey) {
        this.phylumKey = phylumKey;
    }

    @Override
    @Nullable
    public Integer getClassKey() {
        return this.classKey;
    }

    @Override
    public void setClassKey(Integer classKey) {
        this.classKey = classKey;
    }

    @Override
    @Nullable
    public Integer getOrderKey() {
        return this.orderKey;
    }

    @Override
    public void setOrderKey(Integer orderKey) {
        this.orderKey = orderKey;
    }

    @Override
    @Nullable
    public Integer getFamilyKey() {
        return this.familyKey;
    }

    @Override
    public void setFamilyKey(Integer familyKey) {
        this.familyKey = familyKey;
    }

    @Override
    @Nullable
    public Integer getGenusKey() {
        return this.genusKey;
    }

    @Override
    public void setGenusKey(Integer genusKey) {
        this.genusKey = genusKey;
    }

    @Override
    @Nullable
    public Integer getSubgenusKey() {
        return this.subgenusKey;
    }

    @Override
    public void setSubgenusKey(Integer subgenusKey) {
        this.subgenusKey = subgenusKey;
    }

    @Override
    @Nullable
    public Integer getSpeciesKey() {
        return this.speciesKey;
    }

    @Override
    public void setSpeciesKey(Integer speciesKey) {
        this.speciesKey = speciesKey;
    }

    @Override
    @Nullable
    public String getHigherRank(Rank rank) {
        return ClassificationUtils.getHigherRank(this, rank);
    }

    @Override
    public Integer getHigherRankKey(Rank rank) {
        return ClassificationUtils.getHigherRankKey(this, rank);
    }

    @Nullable
    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    @Nullable
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Nullable
    public List<NameUsageMatch> getAlternatives() {
        return this.alternatives;
    }

    public void setAlternatives(List<NameUsageMatch> alternatives) {
        this.alternatives = alternatives;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.usageKey, this.scientificName, this.canonicalName, this.rank, this.synonym, this.confidence, this.note, this.matchType, this.alternatives, this.kingdom, this.phylum, this.clazz, this.order, this.family, this.genus, this.subgenus, this.species, this.kingdomKey, this.phylumKey, this.classKey, this.orderKey, this.familyKey, this.genusKey, this.subgenusKey, this.speciesKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameUsageMatch other = (NameUsageMatch)obj;
        return Objects.equal((Object)this.usageKey, (Object)other.usageKey) && Objects.equal((Object)this.scientificName, (Object)other.scientificName) && Objects.equal((Object)this.canonicalName, (Object)other.canonicalName) && Objects.equal((Object)((Object)this.rank), (Object)((Object)other.rank)) && Objects.equal((Object)this.synonym, (Object)other.synonym) && Objects.equal((Object)this.confidence, (Object)other.confidence) && Objects.equal((Object)this.note, (Object)other.note) && Objects.equal((Object)((Object)this.matchType), (Object)((Object)other.matchType)) && Objects.equal(this.alternatives, other.alternatives) && Objects.equal((Object)this.kingdom, (Object)other.kingdom) && Objects.equal((Object)this.phylum, (Object)other.phylum) && Objects.equal((Object)this.clazz, (Object)other.clazz) && Objects.equal((Object)this.order, (Object)other.order) && Objects.equal((Object)this.family, (Object)other.family) && Objects.equal((Object)this.genus, (Object)other.genus) && Objects.equal((Object)this.subgenus, (Object)other.subgenus) && Objects.equal((Object)this.species, (Object)other.species) && Objects.equal((Object)this.kingdomKey, (Object)other.kingdomKey) && Objects.equal((Object)this.phylumKey, (Object)other.phylumKey) && Objects.equal((Object)this.classKey, (Object)other.classKey) && Objects.equal((Object)this.orderKey, (Object)other.orderKey) && Objects.equal((Object)this.familyKey, (Object)other.familyKey) && Objects.equal((Object)this.genusKey, (Object)other.genusKey) && Objects.equal((Object)this.subgenusKey, (Object)other.subgenusKey) && Objects.equal((Object)this.speciesKey, (Object)other.speciesKey);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("usageKey", (Object)this.usageKey).add("scientificName", (Object)this.scientificName).add("canonicalName", (Object)this.canonicalName).add("rank", (Object)this.rank).add("synonym", this.synonym).add("confidence", (Object)this.confidence).add("note", (Object)this.note).add("matchType", (Object)this.matchType).add("alternatives", this.alternatives).add("kingdom", (Object)this.kingdom).add("phylum", (Object)this.phylum).add("clazz", (Object)this.clazz).add("order", (Object)this.order).add("family", (Object)this.family).add("genus", (Object)this.genus).add("subgenus", (Object)this.subgenus).add("species", (Object)this.species).add("kingdomKey", (Object)this.kingdomKey).add("phylumKey", (Object)this.phylumKey).add("classKey", (Object)this.classKey).add("orderKey", (Object)this.orderKey).add("familyKey", (Object)this.familyKey).add("genusKey", (Object)this.genusKey).add("subgenusKey", (Object)this.subgenusKey).add("speciesKey", (Object)this.speciesKey).toString();
    }

    public static enum MatchType {
        EXACT,
        FUZZY,
        HIGHERRANK,
        NONE;

    }
}

