/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.SuperColumn;
import org.scale7.cassandra.pelops.Bytes;

public class ColumnOrSuperColumnHelper {
    public static FieldAdapter<Column> COLUMN = new FieldAdapter<Column>(ColumnOrSuperColumn._Fields.COLUMN){

        @Override
        public Column getValue(ColumnOrSuperColumn cosc) {
            return cosc.column;
        }
    };
    public static FieldAdapter<SuperColumn> SUPER_COLUMN = new FieldAdapter<SuperColumn>(ColumnOrSuperColumn._Fields.SUPER_COLUMN){

        @Override
        public SuperColumn getValue(ColumnOrSuperColumn cosc) {
            return cosc.super_column;
        }
    };
    public static FieldAdapter<CounterColumn> COUNTER_COLUMN = new FieldAdapter<CounterColumn>(ColumnOrSuperColumn._Fields.COUNTER_COLUMN){

        @Override
        public CounterColumn getValue(ColumnOrSuperColumn cosc) {
            return cosc.counter_column;
        }
    };
    public static FieldAdapter<CounterSuperColumn> COUNTER_SUPER_COLUMN = new FieldAdapter<CounterSuperColumn>(ColumnOrSuperColumn._Fields.COUNTER_SUPER_COLUMN){

        @Override
        public CounterSuperColumn getValue(ColumnOrSuperColumn cosc) {
            return cosc.counter_super_column;
        }
    };

    public static <T> List<T> transform(List<ColumnOrSuperColumn> coscList, FieldAdapter<T> fieldAdapter) {
        ArrayList<T> result = new ArrayList<T>(coscList.size());
        for (ColumnOrSuperColumn cosc : coscList) {
            T element = fieldAdapter.getValue(cosc);
            assert (element != null) : "The " + FieldAdapter.access$000(fieldAdapter) + " value should not be null";
            result.add(element);
        }
        return result;
    }

    public static <T> LinkedHashMap<Bytes, List<T>> transform(Map<ByteBuffer, List<ColumnOrSuperColumn>> map, List<Bytes> keyOrder, FieldAdapter<T> fieldAdapter) {
        LinkedHashMap<Bytes, List<T>> result = new LinkedHashMap<Bytes, List<T>>();
        for (Bytes rowKey : keyOrder) {
            result.put(rowKey, ColumnOrSuperColumnHelper.transform(map.get(rowKey.getBytes()), fieldAdapter));
        }
        return result;
    }

    public static <T> LinkedHashMap<String, List<T>> transformUtf8(Map<ByteBuffer, List<ColumnOrSuperColumn>> map, List<String> keyOrder, List<ByteBuffer> keyOrderRaw, FieldAdapter<T> fieldAdapter) {
        LinkedHashMap<String, List<T>> result = new LinkedHashMap<String, List<T>>();
        int rowKeysSize = keyOrder.size();
        for (int i = 0; i < rowKeysSize; ++i) {
            result.put(keyOrder.get(i), ColumnOrSuperColumnHelper.transform(map.get(keyOrderRaw.get(i)), fieldAdapter));
        }
        return result;
    }

    public static <T> LinkedHashMap<Bytes, List<T>> transformKeySlices(List<KeySlice> keySlices, FieldAdapter<T> fieldAdapter) {
        LinkedHashMap<Bytes, List<T>> result = new LinkedHashMap<Bytes, List<T>>();
        for (KeySlice ks : keySlices) {
            result.put(Bytes.fromByteBuffer(ks.key), ColumnOrSuperColumnHelper.transform(ks.columns, fieldAdapter));
        }
        return result;
    }

    public static <T> LinkedHashMap<String, List<T>> transformKeySlicesUtf8(List<KeySlice> keySlices, FieldAdapter<T> fieldAdapter) {
        LinkedHashMap<String, List<T>> result = new LinkedHashMap<String, List<T>>();
        for (KeySlice ks : keySlices) {
            result.put(Bytes.toUTF8(ks.key), ColumnOrSuperColumnHelper.transform(ks.columns, fieldAdapter));
        }
        return result;
    }

    private static abstract class FieldAdapter<T> {
        private final String description;

        public FieldAdapter(ColumnOrSuperColumn._Fields field) {
            this.description = field.getFieldName().replace('_', ' ');
        }

        public abstract T getValue(ColumnOrSuperColumn var1);

        static /* synthetic */ String access$000(FieldAdapter x0) {
            return x0.description;
        }
    }
}

