/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.intersect;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.ala.layers.intersect.Shape;

class PolygonZ
extends Shape {
    int shapetype;
    double[] boundingbox;
    int numparts;
    int numpoints;
    int[] parts;
    double[] points;

    public PolygonZ(ByteBuffer bb, int contentlength) {
        int i;
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.shapetype = bb.getInt();
        this.boundingbox = new double[4];
        for (i = 0; i < 4; ++i) {
            this.boundingbox[i] = bb.getDouble();
        }
        this.numparts = bb.getInt();
        this.numpoints = bb.getInt();
        this.parts = new int[this.numparts];
        for (i = 0; i < this.numparts; ++i) {
            this.parts[i] = bb.getInt();
        }
        this.points = new double[this.numpoints * 2];
        for (i = 0; i < this.numpoints * 2; ++i) {
            this.points[i] = bb.getDouble();
        }
        int len = 2 + this.numpoints;
        for (i = 0; i < len; ++i) {
            bb.getDouble();
        }
        for (i = 0; i < len; ++i) {
            bb.getDouble();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(String.valueOf(this.boundingbox[0]));
        sb.append(", ");
        sb.append(String.valueOf(this.boundingbox[1]));
        sb.append(") (");
        sb.append(String.valueOf(this.boundingbox[2]));
        sb.append(", ");
        sb.append(String.valueOf(this.boundingbox[3]));
        sb.append(") parts=");
        sb.append(String.valueOf(this.numparts));
        sb.append(" points=");
        sb.append(String.valueOf(this.numpoints));
        return sb.toString();
    }

    @Override
    public int getNumberOfParts() {
        return this.numparts;
    }

    @Override
    public double[] getPoints(int part) {
        int start2;
        int start = this.parts[part];
        int end = this.numpoints;
        if (part < this.numparts - 1) {
            end = this.parts[part + 1];
        }
        double[] output = new double[(end - start) * 2];
        int end2 = end * 2;
        for (int i = start2 = start * 2; i < end2; ++i) {
            output[i - start2] = this.points[i];
        }
        return output;
    }
}

