/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.intersect;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.ala.layers.intersect.IniReader;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class Grid {
    protected Logger logger = Logger.getLogger(this.getClass());
    static final int maxGridsLoaded = 1;
    static ArrayList<Grid> all_grids = new ArrayList();
    final double noDataValueDefault = -3.4E38;
    public Boolean byteorderLSB = true;
    public int ncols;
    public int nrows;
    public double nodatavalue;
    public Boolean valid;
    public double[] values;
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public double xres;
    public double yres;
    public String datatype;
    public double minval;
    public double maxval;
    byte nbytes;
    public String filename;
    float[] grid_data = null;
    public String units;

    public Grid(String fname) {
        File grdfile;
        this.filename = fname;
        File grifile = new File(this.filename + ".gri");
        if (!grifile.exists()) {
            grifile = new File(this.filename + ".GRI");
        }
        if (!(grdfile = new File(this.filename + ".grd")).exists()) {
            grdfile = new File(this.filename + ".GRD");
        }
        if (grdfile.exists() && grifile.exists()) {
            this.readgrd(this.filename);
            if (this.xres == 1.0) {
                this.xres = (this.xmax - this.xmin) / (double)this.nrows;
                this.yres = (this.ymax - this.ymin) / (double)this.ncols;
            }
        } else {
            this.logger.error((Object)("cannot find GRID: " + fname));
        }
    }

    Grid(String fname, boolean keepAvailable) {
        File grdfile;
        this.filename = fname;
        File grifile = new File(this.filename + ".gri");
        if (!grifile.exists()) {
            grifile = new File(this.filename + ".GRI");
        }
        if (!(grdfile = new File(this.filename + ".grd")).exists()) {
            grdfile = new File(this.filename + ".GRD");
        }
        if (grdfile.exists() && grifile.exists()) {
            this.readgrd(this.filename);
            if (this.xres == 1.0) {
                this.xres = (this.xmax - this.xmin) / (double)this.nrows;
                this.yres = (this.ymax - this.ymin) / (double)this.ncols;
            }
        } else {
            this.logger.error((Object)("Error constructing grid from file: " + fname));
        }
        if (keepAvailable) {
            Grid.addGrid(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeAvailable() {
        ArrayList<Grid> arrayList = all_grids;
        synchronized (arrayList) {
            while (all_grids.size() > 0) {
                all_grids.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addGrid(Grid g) {
        ArrayList<Grid> arrayList = all_grids;
        synchronized (arrayList) {
            if (all_grids.size() == 1) {
                all_grids.remove(0);
            }
            all_grids.add(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Grid getGrid(String filename) {
        ArrayList<Grid> arrayList = all_grids;
        synchronized (arrayList) {
            for (int i = 0; i < all_grids.size(); ++i) {
                if (!filename.equalsIgnoreCase(Grid.all_grids.get((int)i).filename)) continue;
                Grid g = all_grids.get(i);
                all_grids.remove(i);
                all_grids.add(g);
                return g;
            }
            return new Grid(filename, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Grid getLoadedGrid(String filename) {
        ArrayList<Grid> arrayList = all_grids;
        synchronized (arrayList) {
            for (int i = 0; i < all_grids.size(); ++i) {
                if (!filename.equalsIgnoreCase(Grid.all_grids.get((int)i).filename)) continue;
                Grid g = all_grids.get(i);
                all_grids.remove(i);
                all_grids.add(g);
                return g;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Grid getGridStandardized(String filename) {
        ArrayList<Grid> arrayList = all_grids;
        synchronized (arrayList) {
            for (int i = 0; i < all_grids.size(); ++i) {
                if (!filename.equalsIgnoreCase(Grid.all_grids.get((int)i).filename)) continue;
                Grid g = all_grids.get(i);
                all_grids.remove(i);
                all_grids.add(g);
                return g;
            }
            Grid g = new Grid(filename, true);
            float[] d = g.getGrid();
            double range = g.maxval - g.minval;
            for (int i = 0; i < d.length; ++i) {
                d[i] = (float)(((double)d[i] - g.minval) / range);
            }
            return g;
        }
    }

    public int getcellnumber(double x, double y) {
        if (x < this.xmin || x > this.xmax || y < this.ymin || y > this.ymax) {
            return -1;
        }
        int col = (int)((x - this.xmin) / this.xres);
        int row = this.nrows - 1 - (int)((y - this.ymin) / this.yres);
        if (col < 0) {
            col = 0;
        }
        if (row < 0) {
            row = 0;
        }
        if (col >= this.ncols) {
            col = this.ncols - 1;
        }
        if (row >= this.nrows) {
            row = this.nrows - 1;
        }
        return row * this.ncols + col;
    }

    private void setdatatype(String s) {
        if ((s = s.toUpperCase()).equals("INT1BYTE")) {
            this.datatype = "BYTE";
        } else if (s.equals("INT2BYTES")) {
            this.datatype = "SHORT";
        } else if (s.equals("INT4BYTES")) {
            this.datatype = "INT";
        } else if (s.equals("INT8BYTES")) {
            this.datatype = "LONG";
        } else if (s.equals("FLT4BYTES")) {
            this.datatype = "FLOAT";
        } else if (s.equals("FLT8BYTES")) {
            this.datatype = "DOUBLE";
        } else if (s.equals("INT1B") || s.equals("BYTE")) {
            this.datatype = "BYTE";
        } else if (s.equals("INT1U") || s.equals("UBYTE")) {
            this.datatype = "UBYTE";
        } else if (s.equals("INT2B") || s.equals("INT16") || s.equals("INT2S")) {
            this.datatype = "SHORT";
        } else if (s.equals("INT4B")) {
            this.datatype = "INT";
        } else if (s.equals("INT8B") || s.equals("INT32")) {
            this.datatype = "LONG";
        } else if (s.equals("FLT4B") || s.equals("FLOAT32") || s.equals("FLT4S")) {
            this.datatype = "FLOAT";
        } else if (s.equals("FLT8B")) {
            this.datatype = "DOUBLE";
        } else if (s.equals("BYTE")) {
            this.datatype = "BYTE";
        } else if (s.equals("SHORT")) {
            this.datatype = "SHORT";
        } else if (s.equals("INT")) {
            this.datatype = "INT";
        } else if (s.equals("LONG")) {
            this.datatype = "LONG";
        } else if (s.equals("FLOAT")) {
            this.datatype = "FLOAT";
        } else if (s.equals("DOUBLE")) {
            this.datatype = "DOUBLE";
        } else if (s.equals("INTEGER")) {
            this.datatype = "INT";
        } else if (s.equals("SMALLINT")) {
            this.datatype = "INT";
        } else if (s.equals("SINGLE")) {
            this.datatype = "FLOAT";
        } else if (s.equals("REAL")) {
            this.datatype = "FLOAT";
        } else {
            this.logger.error((Object)("GRID unknown type: " + s));
            this.datatype = "UNKNOWN";
        }
        this.nbytes = this.datatype.equals("BYTE") || this.datatype.equals("UBYTE") ? (byte)1 : (this.datatype.equals("SHORT") ? (byte)2 : (this.datatype.equals("INT") ? (byte)4 : (this.datatype.equals("LONG") ? (byte)8 : (this.datatype.equals("SINGLE") ? (byte)4 : (this.datatype.equals("DOUBLE") ? (byte)8 : (byte)0)))));
    }

    private void readgrd(String filename) {
        IniReader ir = null;
        ir = new File(filename + ".grd").exists() ? new IniReader(filename + ".grd") : new IniReader(filename + ".GRD");
        this.setdatatype(ir.getStringValue("Data", "DataType"));
        this.maxval = (float)ir.getDoubleValue("Data", "MaxValue");
        this.minval = (float)ir.getDoubleValue("Data", "MinValue");
        this.ncols = ir.getIntegerValue("GeoReference", "Columns");
        this.nrows = ir.getIntegerValue("GeoReference", "Rows");
        this.xmin = ir.getDoubleValue("GeoReference", "MinX");
        this.ymin = ir.getDoubleValue("GeoReference", "MinY");
        this.xmax = ir.getDoubleValue("GeoReference", "MaxX");
        this.ymax = ir.getDoubleValue("GeoReference", "MaxY");
        this.xres = ir.getDoubleValue("GeoReference", "ResolutionX");
        this.yres = ir.getDoubleValue("GeoReference", "ResolutionY");
        this.nodatavalue = ir.valueExists("Data", "NoDataValue") ? ir.getDoubleValue("Data", "NoDataValue") : Double.NaN;
        String s = ir.getStringValue("Data", "ByteOrder");
        this.byteorderLSB = true;
        if (s != null && s.length() > 0 && s.equals("MSB")) {
            this.byteorderLSB = false;
        }
        this.units = ir.getStringValue("Data", "Units");
    }

    public float[] getGrid() {
        int maxArrayLength = 0x7FFFFFF5;
        if (this.grid_data != null) {
            return this.grid_data;
        }
        int length = this.nrows * this.ncols;
        float[] ret = new float[length];
        File f2 = new File(this.filename + ".GRI");
        try {
            int len;
            RandomAccessFile afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            byte[] b = new byte[(int)Math.min(afile.length(), (long)maxArrayLength)];
            int i = 0;
            int max = 0;
            while ((len = afile.read(b)) > 0) {
                ByteBuffer bb = ByteBuffer.wrap(b);
                if (this.byteorderLSB.booleanValue()) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                }
                if (this.datatype.equalsIgnoreCase("UBYTE")) {
                    max += len;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.get();
                        if (ret[i] < 0.0f) {
                            int n = i;
                            ret[n] = ret[n] + 256.0f;
                        }
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("BYTE")) {
                    max += len;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.get();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("SHORT")) {
                    max += len / 2;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.getShort();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("INT")) {
                    max += len / 4;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.getInt();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("LONG")) {
                    max += len / 8;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.getLong();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("FLOAT")) {
                    max += len / 4;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.getFloat();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                    max += len / 8;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = (float)bb.getDouble();
                        ++i;
                    }
                    continue;
                }
                max += len / 4;
                while (i < max) {
                    ret[i] = Float.NaN;
                    ++i;
                }
            }
            for (i = 0; i < length; ++i) {
                if (ret[i] != (float)this.nodatavalue) continue;
                ret[i] = Float.NaN;
            }
            afile.close();
        }
        catch (Exception e) {
            this.logger.error((Object)"An error has occurred - probably a file error");
            this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        this.grid_data = ret;
        return ret;
    }

    public void writeGrid(String newfilename, int[] dfiltered, double xmin, double ymin, double xmax, double ymax, double xres, double yres, int nrows, int ncols) {
        int length = dfiltered.length;
        double maxvalue = -2.147483647E9;
        double minvalue = 2.147483647E9;
        try {
            RandomAccessFile afile = new RandomAccessFile(newfilename + ".gri", "rw");
            int size = 4;
            byte[] b = new byte[size * length];
            ByteBuffer bb = ByteBuffer.wrap(b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                bb.order(ByteOrder.BIG_ENDIAN);
            }
            for (int i = 0; i < length; ++i) {
                bb.putInt(dfiltered[i]);
            }
            afile.write(b);
            afile.close();
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        this.writeHeader(newfilename, xmin, ymin, xmin + xres * (double)ncols, ymin + yres * (double)nrows, xres, yres, nrows, ncols, minvalue, maxvalue, "INT4BYTES", "-9999");
    }

    public void writeGrid(String newfilename, double[] dfiltered, double xmin, double ymin, double xmax, double ymax, double xres, double yres, int nrows, int ncols) {
        int length = dfiltered.length;
        double maxvalue = -1.7976931348623157E308;
        double minvalue = Double.MAX_VALUE;
        try {
            RandomAccessFile afile = new RandomAccessFile(newfilename + ".gri", "rw");
            int size = 4;
            byte[] b = new byte[size * length];
            ByteBuffer bb = ByteBuffer.wrap(b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                bb.order(ByteOrder.BIG_ENDIAN);
            }
            for (int i = 0; i < length; ++i) {
                if (Double.isNaN(dfiltered[i])) {
                    bb.putFloat(-3.4E38f);
                    continue;
                }
                if (minvalue > dfiltered[i]) {
                    minvalue = dfiltered[i];
                }
                if (maxvalue < dfiltered[i]) {
                    maxvalue = dfiltered[i];
                }
                bb.putFloat((float)dfiltered[i]);
            }
            afile.write(b);
            afile.close();
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        this.writeHeader(newfilename, xmin, ymin, xmin + xres * (double)ncols, ymin + yres * (double)nrows, xres, yres, nrows, ncols, minvalue, maxvalue, "FLT4BYTES", String.valueOf(-3.4E38));
    }

    public void writeGrid(String newfilename, float[] dfiltered, double xmin, double ymin, double xmax, double ymax, double xres, double yres, int nrows, int ncols) {
        int length = dfiltered.length;
        double maxvalue = -1.7976931348623157E308;
        double minvalue = Double.MAX_VALUE;
        try {
            RandomAccessFile afile = new RandomAccessFile(newfilename + ".gri", "rw");
            int size = 4;
            byte[] b = new byte[size * length];
            ByteBuffer bb = ByteBuffer.wrap(b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                bb.order(ByteOrder.BIG_ENDIAN);
            }
            for (int i = 0; i < length; ++i) {
                if (Double.isNaN(dfiltered[i])) {
                    bb.putFloat(-3.4E38f);
                    continue;
                }
                if (minvalue > (double)dfiltered[i]) {
                    minvalue = dfiltered[i];
                }
                if (maxvalue < (double)dfiltered[i]) {
                    maxvalue = dfiltered[i];
                }
                bb.putFloat(dfiltered[i]);
            }
            afile.write(b);
            afile.close();
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        this.writeHeader(newfilename, xmin, ymin, xmin + xres * (double)ncols, ymin + yres * (double)nrows, xres, yres, nrows, ncols, minvalue, maxvalue, "FLT4BYTES", String.valueOf(-3.4E38));
    }

    public void writeHeader(String newfilename, double xmin, double ymin, double xmax, double ymax, double xres, double yres, int nrows, int ncols, double minvalue, double maxvalue) {
        this.writeHeader(newfilename, xmin, ymin, xmax, ymax, xres, yres, nrows, ncols, minvalue, maxvalue, "FLT4BYTES", String.valueOf(-3.4E38));
    }

    public void writeHeader(String newfilename, double xmin, double ymin, double xmax, double ymax, double xres, double yres, int nrows, int ncols, double minvalue, double maxvalue, String datatype, String nodata) {
        try {
            FileWriter fw = new FileWriter(newfilename + ".grd");
            fw.append("[General]");
            fw.append("\r\n").append("Title=").append(newfilename);
            fw.append("\r\n").append("[GeoReference]");
            fw.append("\r\n").append("Projection=GEOGRAPHIC");
            fw.append("\r\n").append("Datum=WGS84");
            fw.append("\r\n").append("Mapunits=DEGREES");
            fw.append("\r\n").append("Columns=").append(String.valueOf(ncols));
            fw.append("\r\n").append("Rows=").append(String.valueOf(nrows));
            fw.append("\r\n").append("MinX=").append(String.format("%.2f", xmin));
            fw.append("\r\n").append("MaxX=").append(String.format("%.2f", xmax));
            fw.append("\r\n").append("MinY=").append(String.format("%.2f", ymin));
            fw.append("\r\n").append("MaxY=").append(String.format("%.2f", ymax));
            fw.append("\r\n").append("ResolutionX=").append(String.valueOf(xres));
            fw.append("\r\n").append("ResolutionY=").append(String.valueOf(yres));
            fw.append("\r\n").append("[Data]");
            fw.append("\r\n").append("DataType=" + datatype);
            fw.append("\r\n").append("MinValue=").append(String.valueOf(minvalue));
            fw.append("\r\n").append("MaxValue=").append(String.valueOf(maxvalue));
            fw.append("\r\n").append("NoDataValue=").append(nodata);
            fw.append("\r\n").append("Transparent=0");
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    public float[] getValues2(double[][] points) {
        if (points == null || points.length == 0) {
            return null;
        }
        float[] ret = new float[points.length];
        float[] grid = this.getGrid();
        int glen = grid.length;
        int length = points.length;
        for (int i = 0; i < length; ++i) {
            int pos = this.getcellnumber(points[i][0], points[i][1]);
            ret[i] = pos >= 0 && pos < glen ? grid[pos] : Float.NaN;
        }
        return ret;
    }

    float[] getGrid(double xmin, double ymin, double xmax, double ymax) {
        int width = (int)((xmax - xmin) / this.xres);
        int height = (int)((ymax - ymin) / this.yres);
        int startx = (int)((xmin - this.xmin) / this.xres);
        int endx = startx + width;
        int starty = (int)((ymin - this.ymin) / this.yres);
        int length = width * height;
        float[] ret = new float[length];
        int pos = 0;
        File f2 = new File(this.filename + ".GRI");
        int size = 4;
        if (this.datatype.equals("BYTE") || this.datatype.equals("UBYTE")) {
            size = 1;
        } else if (this.datatype.equals("SHORT")) {
            size = 2;
        } else if (this.datatype.equals("INT")) {
            size = 4;
        } else if (this.datatype.equals("LONG")) {
            size = 8;
        } else if (this.datatype.equals("FLOAT")) {
            size = 4;
        } else if (this.datatype.equals("DOUBLE")) {
            size = 8;
        }
        try {
            int x;
            int i;
            RandomAccessFile afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            afile.seek(this.ncols * starty * size);
            int readSize = this.ncols * height * size;
            int readLen = this.ncols * height;
            byte[] b = new byte[readSize];
            afile.read(b);
            ByteBuffer bb = ByteBuffer.wrap(b);
            afile.close();
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            }
            if (this.datatype.equalsIgnoreCase("BYTE")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.get();
                        continue;
                    }
                    ret[pos++] = bb.get();
                }
            } else if (this.datatype.equalsIgnoreCase("UBYTE")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.get();
                        continue;
                    }
                    ret[pos] = bb.get();
                    if (ret[pos] < 0.0f) {
                        int n = pos;
                        ret[n] = ret[n] + 256.0f;
                    }
                    ++pos;
                }
            } else if (this.datatype.equalsIgnoreCase("SHORT")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.getShort();
                        continue;
                    }
                    ret[pos++] = bb.getShort();
                }
            } else if (this.datatype.equalsIgnoreCase("INT")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.getInt();
                        continue;
                    }
                    ret[pos++] = bb.getInt();
                }
            } else if (this.datatype.equalsIgnoreCase("LONG")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.getLong();
                        continue;
                    }
                    ret[pos++] = bb.getLong();
                }
            } else if (this.datatype.equalsIgnoreCase("FLOAT")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.getFloat();
                        continue;
                    }
                    ret[pos++] = bb.getFloat();
                }
            } else if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.getDouble();
                        continue;
                    }
                    ret[pos++] = (float)bb.getDouble();
                }
            } else {
                for (i = 0; i < length; ++i) {
                    ret[i] = Float.NaN;
                }
            }
            for (i = 0; i < length; ++i) {
                if (ret[i] != (float)this.nodatavalue) continue;
                ret[i] = Float.NaN;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("GRID: " + e.toString()));
            this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        this.grid_data = ret;
        return ret;
    }

    public void printMinMax() {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        float[] data = this.getGrid();
        int numMissing = 0;
        for (float d : data) {
            if (Float.isNaN(d)) {
                ++numMissing;
            }
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        if ((double)min != this.minval || (double)max != this.maxval) {
            this.logger.error((Object)(this.filename + " ERR header(" + this.minval + " " + this.maxval + ") actual(" + min + " " + max + ") number missing(" + numMissing + " of " + data.length + ")"));
        } else {
            this.logger.error((Object)(this.filename + " OK header(" + this.minval + " " + this.maxval + ") number missing(" + numMissing + " of " + data.length + ")"));
        }
    }

    public float[] getValues(double[][] points) {
        if (points == null || points.length == 0) {
            return null;
        }
        Grid g = Grid.getLoadedGrid(this.filename);
        if (g != null) {
            return g.getValues2(points);
        }
        float[] ret = new float[points.length];
        int length = points.length;
        File f2 = new File(this.filename + ".GRI");
        try {
            ByteBuffer bb;
            int pos;
            int i;
            byte[] b;
            int size;
            RandomAccessFile afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            if (this.datatype.equalsIgnoreCase("BYTE")) {
                size = 1;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    pos = this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek(pos * size);
                        ret[i] = afile.readByte();
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("UBYTE")) {
                size = 1;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    pos = this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek(pos * size);
                        ret[i] = afile.readByte();
                        if (!(ret[i] < 0.0f)) continue;
                        int n = i;
                        ret[n] = ret[n] + 256.0f;
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("SHORT")) {
                size = 2;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    pos = this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek(pos * size);
                        afile.read(b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[i] = (short)((0xFF & b[1]) << 8 | b[0] & 0xFF);
                            continue;
                        }
                        ret[i] = (short)((0xFF & b[0]) << 8 | b[1] & 0xFF);
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("INT")) {
                size = 4;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    pos = this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek(pos * size);
                        afile.read(b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[i] = (0xFF & b[3]) << 24 | ((0xFF & b[2]) << 16) + ((0xFF & b[1]) << 8) + (b[0] & 0xFF);
                            continue;
                        }
                        ret[i] = (0xFF & b[0]) << 24 | ((0xFF & b[1]) << 16) + ((0xFF & b[2]) << 8) + (0xFF & b[3] & 0xFF);
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("LONG")) {
                size = 8;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    pos = this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek(pos * size);
                        afile.read(b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[i] = ((long)(0xFF & b[7]) << 56) + ((long)(0xFF & b[6]) << 48) + ((long)(0xFF & b[5]) << 40) + ((long)(0xFF & b[4]) << 32) + ((long)(0xFF & b[3]) << 24) + ((long)(0xFF & b[2]) << 16) + ((long)(0xFF & b[1]) << 8) + (long)(0xFF & b[0]);
                            continue;
                        }
                        ret[i] = ((long)(0xFF & b[0]) << 56) + ((long)(0xFF & b[1]) << 48) + ((long)(0xFF & b[2]) << 40) + ((long)(0xFF & b[3]) << 32) + ((long)(0xFF & b[4]) << 24) + ((long)(0xFF & b[5]) << 16) + ((long)(0xFF & b[6]) << 8) + (long)(0xFF & b[7]);
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("FLOAT")) {
                size = 4;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    pos = this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek(pos * size);
                        afile.read(b);
                        bb = ByteBuffer.wrap(b);
                        if (this.byteorderLSB.booleanValue()) {
                            bb.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        ret[i] = bb.getFloat();
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                size = 8;
                b = new byte[8];
                for (i = 0; i < length; ++i) {
                    pos = this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek(pos * size);
                        afile.read(b);
                        bb = ByteBuffer.wrap(b);
                        if (this.byteorderLSB.booleanValue()) {
                            bb.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        ret[i] = (float)bb.getDouble();
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else {
                this.logger.error((Object)("datatype not supported in Grid.getValues: " + this.datatype));
                for (i = 0; i < length; ++i) {
                    ret[i] = Float.NaN;
                }
            }
            for (i = 0; i < length; ++i) {
                if (ret[i] != (float)this.nodatavalue) continue;
                ret[i] = Float.NaN;
            }
            afile.close();
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        return ret;
    }

    public float[] getValues3(double[][] points, int bufferSize) {
        if (points == null || points.length == 0) {
            return null;
        }
        Grid g = Grid.getLoadedGrid(this.filename);
        if (g != null && g.grid_data != null) {
            return g.getValues2(points);
        }
        int length = points.length;
        File f2 = new File(this.filename + ".GRI");
        try {
            int i;
            byte[] b;
            int size;
            RandomAccessFile afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            if (afile.length() < 0x5000000L) {
                afile.close();
                return this.getValues2(points);
            }
            byte[] buffer = new byte[bufferSize];
            Long bufferOffset = afile.length();
            float[] ret = new float[points.length];
            int[][] cells = new int[points.length][2];
            for (int j = 0; j < points.length; ++j) {
                if (Double.isNaN(points[j][0]) || Double.isNaN(points[j][1])) {
                    cells[j][0] = -1;
                    cells[j][1] = j;
                    continue;
                }
                cells[j][0] = this.getcellnumber(points[j][0], points[j][1]);
                cells[j][1] = j;
            }
            Arrays.sort(cells, new Comparator<int[]>(){

                @Override
                public int compare(int[] o1, int[] o2) {
                    if (o1[0] == o2[0]) {
                        return o1[1] - o2[1];
                    }
                    return o1[0] - o2[0];
                }
            });
            if (this.datatype.equalsIgnoreCase("BYTE")) {
                size = 1;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    ret[cells[i][1]] = i > 0 && cells[i - 1][0] == cells[i][0] ? ret[cells[i - 1][1]] : (cells[i][0] >= 0 ? (float)this.getByte(afile, buffer, bufferOffset, cells[i][0] * size) : Float.NaN);
                }
            } else if (this.datatype.equalsIgnoreCase("UBYTE")) {
                size = 1;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[cells[i][1]] = ret[cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0) {
                        ret[cells[i][1]] = this.getByte(afile, buffer, bufferOffset, cells[i][0] * size);
                        if (!(ret[cells[i][1]] < 0.0f)) continue;
                        int n = cells[i][1];
                        ret[n] = ret[n] + 256.0f;
                        continue;
                    }
                    ret[cells[i][1]] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("SHORT")) {
                size = 2;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[cells[i][1]] = ret[cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0) {
                        bufferOffset = this.getBytes(afile, buffer, bufferOffset, (long)cells[i][0] * (long)size, b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[cells[i][1]] = (short)((0xFF & b[1]) << 8 | b[0] & 0xFF);
                            continue;
                        }
                        ret[cells[i][1]] = (short)((0xFF & b[0]) << 8 | b[1] & 0xFF);
                        continue;
                    }
                    ret[cells[i][1]] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("INT")) {
                size = 4;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[cells[i][1]] = ret[cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0) {
                        bufferOffset = this.getBytes(afile, buffer, bufferOffset, (long)cells[i][0] * (long)size, b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[cells[i][1]] = (0xFF & b[3]) << 24 | ((0xFF & b[2]) << 16) + ((0xFF & b[1]) << 8) + (b[0] & 0xFF);
                            continue;
                        }
                        ret[cells[i][1]] = (0xFF & b[0]) << 24 | ((0xFF & b[1]) << 16) + ((0xFF & b[2]) << 8) + (0xFF & b[3] & 0xFF);
                        continue;
                    }
                    ret[cells[i][1]] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("LONG")) {
                size = 8;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[cells[i][1]] = ret[cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0) {
                        bufferOffset = this.getBytes(afile, buffer, bufferOffset, (long)cells[i][0] * (long)size, b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[cells[i][1]] = ((long)(0xFF & b[7]) << 56) + ((long)(0xFF & b[6]) << 48) + ((long)(0xFF & b[5]) << 40) + ((long)(0xFF & b[4]) << 32) + ((long)(0xFF & b[3]) << 24) + ((long)(0xFF & b[2]) << 16) + ((long)(0xFF & b[1]) << 8) + (long)(0xFF & b[0]);
                            continue;
                        }
                        ret[cells[i][1]] = ((long)(0xFF & b[0]) << 56) + ((long)(0xFF & b[1]) << 48) + ((long)(0xFF & b[2]) << 40) + ((long)(0xFF & b[3]) << 32) + ((long)(0xFF & b[4]) << 24) + ((long)(0xFF & b[5]) << 16) + ((long)(0xFF & b[6]) << 8) + (long)(0xFF & b[7]);
                        continue;
                    }
                    ret[cells[i][1]] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("FLOAT")) {
                size = 4;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[cells[i][1]] = ret[cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0) {
                        bufferOffset = this.getBytes(afile, buffer, bufferOffset, (long)cells[i][0] * (long)size, b);
                        ByteBuffer bb = ByteBuffer.wrap(b);
                        if (this.byteorderLSB.booleanValue()) {
                            bb.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        ret[cells[i][1]] = bb.getFloat();
                        continue;
                    }
                    ret[cells[i][1]] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                size = 8;
                b = new byte[8];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[cells[i][1]] = ret[cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0) {
                        this.getBytes(afile, buffer, bufferOffset, (long)cells[i][0] * (long)size, b);
                        ByteBuffer bb = ByteBuffer.wrap(b);
                        if (this.byteorderLSB.booleanValue()) {
                            bb.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        ret[cells[i][1]] = (float)bb.getDouble();
                        continue;
                    }
                    ret[cells[i][1]] = Float.NaN;
                }
            } else {
                this.logger.error((Object)("datatype not supported in Grid.getValues: " + this.datatype));
                for (i = 0; i < length; ++i) {
                    ret[i] = Float.NaN;
                }
            }
            for (i = 0; i < length; ++i) {
                if (ret[i] != (float)this.nodatavalue) continue;
                ret[i] = Float.NaN;
            }
            afile.close();
            return ret;
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            return null;
        }
    }

    public void mergeMissingValues(Grid sourceOfMissingValues, boolean hideMissing) {
        float[] cells = sourceOfMissingValues.getGrid();
        float[] actual = this.getGrid();
        int length = actual.length;
        File f2 = new File(this.filename + ".GRI");
        try {
            RandomAccessFile afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "rw") : new RandomAccessFile(this.filename + ".GRI", "rw");
            byte[] b = new byte[(int)afile.length()];
            ByteBuffer bb = ByteBuffer.wrap(b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            }
            afile.seek(0L);
            if (this.datatype.equalsIgnoreCase("UBYTE")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        if (this.nodatavalue >= 128.0) {
                            bb.put((byte)(this.nodatavalue - 256.0));
                            continue;
                        }
                        bb.put((byte)this.nodatavalue);
                        continue;
                    }
                    if (actual[i] >= 128.0f) {
                        bb.put((byte)(actual[i] - 256.0f));
                        continue;
                    }
                    bb.put((byte)actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("BYTE")) {
                for (int i = 0; i < length; ++i) {
                    bb.put((byte)actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("SHORT")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        bb.putShort((short)this.nodatavalue);
                        continue;
                    }
                    bb.putShort((short)actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("INT")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        bb.putInt((int)this.nodatavalue);
                        continue;
                    }
                    bb.putInt((int)actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("LONG")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        bb.putLong((long)this.nodatavalue);
                        continue;
                    }
                    bb.putLong((long)actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("FLOAT")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        bb.putFloat((float)this.nodatavalue);
                        continue;
                    }
                    bb.putFloat(actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        bb.putDouble(this.nodatavalue);
                        continue;
                    }
                    bb.putDouble(actual[i]);
                }
            } else {
                this.logger.error((Object)("unsupported grid data type: " + this.datatype));
            }
            afile.write(bb.array());
            afile.close();
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    private byte getByte(RandomAccessFile raf, byte[] buffer, Long bufferOffset, long seekTo) throws IOException {
        long relativePos = seekTo - bufferOffset;
        if (relativePos < 0L) {
            raf.seek(seekTo);
            bufferOffset = seekTo;
            raf.read(buffer);
            return buffer[0];
        }
        if (relativePos >= 0L && relativePos < (long)buffer.length) {
            return buffer[(int)relativePos];
        }
        if (relativePos - (long)buffer.length < (long)buffer.length) {
            bufferOffset = bufferOffset + (long)buffer.length;
            raf.read(buffer);
            return buffer[(int)(relativePos - (long)buffer.length)];
        }
        raf.seek(seekTo);
        bufferOffset = seekTo;
        raf.read(buffer);
        return buffer[0];
    }

    private Long getBytes(RandomAccessFile raf, byte[] buffer, Long bufferOffset, long seekTo, byte[] dest) throws IOException {
        long relativePos = seekTo - bufferOffset;
        if (relativePos < 0L) {
            if (seekTo < 0L) {
                seekTo = 0L;
            }
            raf.seek(seekTo);
            bufferOffset = seekTo;
            raf.read(buffer);
            System.arraycopy(buffer, 0, dest, 0, dest.length);
        } else if (relativePos >= 0L && relativePos < (long)buffer.length) {
            System.arraycopy(buffer, (int)relativePos, dest, 0, dest.length);
        } else if (relativePos - (long)buffer.length < (long)buffer.length) {
            bufferOffset = bufferOffset + (long)buffer.length;
            raf.read(buffer);
            int offset = (int)(relativePos - (long)buffer.length);
            System.arraycopy(buffer, offset, dest, 0, dest.length);
        } else {
            raf.seek(seekTo);
            bufferOffset = seekTo;
            raf.read(buffer);
            System.arraycopy(buffer, 0, dest, 0, dest.length);
        }
        return bufferOffset;
    }

    public float[] calculatetMinMax() {
        float[] ret = new float[]{Float.MAX_VALUE, -3.4028235E38f};
        try {
            File f2 = new File(this.filename + ".GRI");
            RandomAccessFile afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            long length = (long)this.nrows * (long)this.ncols;
            if (this.datatype.equalsIgnoreCase("BYTE")) {
                int size = 1;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    float f = afile.readByte();
                    if (f == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f, ret[0]);
                    ret[1] = Math.max(f, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("UBYTE")) {
                int size = 1;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    float f = afile.readByte();
                    if (f < 0.0f) {
                        f += 256.0f;
                    }
                    if (f == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f, ret[0]);
                    ret[1] = Math.max(f, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("SHORT")) {
                int size = 2;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    afile.read(b);
                    float f = this.byteorderLSB != false ? (float)((short)((0xFF & b[1]) << 8 | b[0] & 0xFF)) : (float)((short)((0xFF & b[0]) << 8 | b[1] & 0xFF));
                    if (f == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f, ret[0]);
                    ret[1] = Math.max(f, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("INT")) {
                int size = 4;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    afile.read(b);
                    float f = this.byteorderLSB != false ? (float)((0xFF & b[3]) << 24 | ((0xFF & b[2]) << 16) + ((0xFF & b[1]) << 8) + (b[0] & 0xFF)) : (float)((0xFF & b[0]) << 24 | ((0xFF & b[1]) << 16) + ((0xFF & b[2]) << 8) + (0xFF & b[3] & 0xFF));
                    if (f == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f, ret[0]);
                    ret[1] = Math.max(f, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("LONG")) {
                int size = 8;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    afile.read(b);
                    float f = this.byteorderLSB != false ? (float)(((long)(0xFF & b[7]) << 56) + ((long)(0xFF & b[6]) << 48) + ((long)(0xFF & b[5]) << 40) + ((long)(0xFF & b[4]) << 32) + ((long)(0xFF & b[3]) << 24) + ((long)(0xFF & b[2]) << 16) + ((long)(0xFF & b[1]) << 8) + (long)(0xFF & b[0])) : (float)(((long)(0xFF & b[0]) << 56) + ((long)(0xFF & b[1]) << 48) + ((long)(0xFF & b[2]) << 40) + ((long)(0xFF & b[3]) << 32) + ((long)(0xFF & b[4]) << 24) + ((long)(0xFF & b[5]) << 16) + ((long)(0xFF & b[6]) << 8) + (long)(0xFF & b[7]));
                    if (f == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f, ret[0]);
                    ret[1] = Math.max(f, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("FLOAT")) {
                int size = 4;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    float f;
                    afile.read(b);
                    ByteBuffer bb = ByteBuffer.wrap(b);
                    if (this.byteorderLSB.booleanValue()) {
                        bb.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    if ((f = bb.getFloat()) == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f, ret[0]);
                    ret[1] = Math.max(f, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                int size = 8;
                byte[] b = new byte[8];
                for (long i = 0L; i < length; ++i) {
                    float f;
                    afile.read(b);
                    ByteBuffer bb = ByteBuffer.wrap(b);
                    if (this.byteorderLSB.booleanValue()) {
                        bb.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    if ((f = (float)bb.getDouble()) == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f, ret[0]);
                    ret[1] = Math.max(f, ret[1]);
                }
            } else {
                this.logger.error((Object)("datatype not supported in Grid.getValues: " + this.datatype));
            }
            afile.close();
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        return ret;
    }
}

