/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.iptc.IptcDirectory;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;

public class IptcReader
implements MetadataReader {
    @Override
    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata) {
        int n;
        IptcDirectory iptcDirectory = metadata.getOrCreateDirectory(IptcDirectory.class);
        BufferReader bufferReader = new BufferReader(byArray);
        for (int i = 0; i < byArray.length; i += n) {
            byte by;
            byte by2;
            if (byArray[i] != 28) {
                iptcDirectory.addError("Invalid start to IPTC tag");
                break;
            }
            if (i + 5 >= byArray.length) {
                iptcDirectory.addError("Too few bytes remain for a valid IPTC tag");
                break;
            }
            ++i;
            try {
                by2 = byArray[i++];
                by = byArray[i++];
                n = bufferReader.getUInt16(i);
            }
            catch (BufferBoundsException bufferBoundsException) {
                iptcDirectory.addError("IPTC data segment ended mid-way through tag descriptor");
                return;
            }
            if ((i += 2) + n > byArray.length) {
                iptcDirectory.addError("Data for tag extends beyond end of IPTC segment");
                break;
            }
            this.processTag(byArray, iptcDirectory, by2, by, i, n);
        }
    }

    private void processTag(@NotNull byte[] byArray, @NotNull Directory directory, int n, int n2, int n3, int n4) {
        String string;
        String[] stringArray;
        int n5 = n2 | n << 8;
        switch (n5) {
            case 512: {
                short s = (short)(byArray[n3] << 8 & 0xFF | byArray[n3 + 1] & 0xFF);
                directory.setInt(n5, s);
                return;
            }
            case 522: {
                directory.setInt(n5, byArray[n3]);
                return;
            }
            case 542: 
            case 567: {
                if (n4 < 8) break;
                stringArray = new String(byArray, n3, n4);
                try {
                    int n6 = Integer.parseInt(stringArray.substring(0, 4));
                    int n7 = Integer.parseInt(stringArray.substring(4, 6)) - 1;
                    int n8 = Integer.parseInt(stringArray.substring(6, 8));
                    Date date = new GregorianCalendar(n6, n7, n8).getTime();
                    directory.setDate(n5, date);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (n4 < 1) {
            string = "";
        } else {
            try {
                string = new String(byArray, n3, n4, System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                directory.addError("Unable to decode a string for the IPTC tag " + Integer.toHexString(n2));
                string = "";
            }
        }
        if (directory.containsTag(n5)) {
            String[] stringArray2;
            stringArray = directory.getStringArray(n5);
            if (stringArray == null) {
                stringArray2 = new String[1];
            } else {
                stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            }
            stringArray2[stringArray2.length - 1] = string;
            directory.setStringArray(n5, stringArray2);
        } else {
            directory.setString(n5, string);
        }
    }
}

