/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import javax.measure.unit.Unit;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.factory.Hints;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.referencing.operation.MathTransform1D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RenderedSampleDimension
extends GridSampleDimension {
    private static final long serialVersionUID = 946331925096804779L;
    private final int band;
    private final int numBands;
    private final SampleDimensionType type;

    private RenderedSampleDimension(GridSampleDimension band, RenderedImage image, int bandNumber) {
        super(band);
        SampleModel model = image.getSampleModel();
        this.band = bandNumber;
        this.numBands = model.getNumBands();
        this.type = TypeMap.getSampleDimensionType(model, bandNumber);
    }

    static boolean create(CharSequence name, RenderedImage image, GridSampleDimension[] src, GridSampleDimension[] dst) {
        int numBands = image.getSampleModel().getNumBands();
        if (src != null && src.length != numBands) {
            throw new IllegalArgumentException(Errors.format((int)148, (Object)numBands, (Object)src.length, (Object)"SampleDimension"));
        }
        if (dst.length != numBands) {
            throw new IllegalArgumentException(Errors.format((int)148, (Object)numBands, (Object)dst.length, (Object)"SampleDimension"));
        }
        int countGeophysics = 0;
        int countIndexed = 0;
        GridSampleDimension[] defaultSD = null;
        for (int i = 0; i < numBands; ++i) {
            GridSampleDimension sd;
            GridSampleDimension gridSampleDimension = sd = src != null ? src[i] : null;
            if (sd == null) {
                if (defaultSD == null) {
                    defaultSD = new GridSampleDimension[numBands];
                    RenderedSampleDimension.create(name, RectIterFactory.create((RenderedImage)image, null), image.getSampleModel(), null, null, null, null, defaultSD, null);
                }
                sd = defaultSD[i];
            }
            dst[i] = sd = new RenderedSampleDimension(sd, image, i);
            if (sd.geophysics(true) == sd) {
                ++countGeophysics;
            }
            if (sd.geophysics(false) != sd) continue;
            ++countIndexed;
        }
        if (countGeophysics == numBands) {
            return true;
        }
        if (countIndexed == numBands) {
            return false;
        }
        throw new IllegalArgumentException(Errors.format((int)102));
    }

    static GridSampleDimension[] create(CharSequence name, Raster raster, double[] min, double[] max, Unit<?> units, Color[][] colors, RenderingHints hints) {
        GridSampleDimension[] dst = new GridSampleDimension[raster.getNumBands()];
        RenderedSampleDimension.create(name, min == null || max == null ? RectIterFactory.create((Raster)raster, null) : null, raster.getSampleModel(), min, max, units, colors, dst, hints);
        return dst;
    }

    private static void create(CharSequence name, RectIter iterator, SampleModel model, double[] min, double[] max, Unit<?> units, Color[][] colors, GridSampleDimension[] dst, RenderingHints hints) {
        int b;
        boolean needScaling;
        int numBands = dst.length;
        if (min != null && min.length != numBands) {
            throw new IllegalArgumentException(Errors.format((int)148, (Object)numBands, (Object)min.length, (Object)"min[i]"));
        }
        if (max != null && max.length != numBands) {
            throw new IllegalArgumentException(Errors.format((int)148, (Object)numBands, (Object)max.length, (Object)"max[i]"));
        }
        if (colors != null && colors.length != numBands) {
            throw new IllegalArgumentException(Errors.format((int)148, (Object)numBands, (Object)colors.length, (Object)"colors[i]"));
        }
        SampleDimensionType sourceType = TypeMap.getSampleDimensionType(model, 0);
        boolean sourceIsFloat = TypeMap.isFloatingPoint(sourceType);
        SampleDimensionType targetType = null;
        if (hints != null) {
            targetType = (SampleDimensionType)hints.get(Hints.SAMPLE_DIMENSION_TYPE);
        }
        if (targetType == null) {
            targetType = sourceIsFloat ? SampleDimensionType.UNSIGNED_8BITS : sourceType;
        }
        boolean targetIsFloat = TypeMap.isFloatingPoint(targetType);
        NumberRange<? extends Number> targetRange = TypeMap.getRange(targetType);
        Category[] categories = new Category[1];
        if (targetIsFloat) {
            needScaling = false;
        } else if (sourceIsFloat) {
            needScaling = true;
            if (!TypeMap.isSigned(targetType)) {
                categories = new Category[2];
                categories[1] = Category.NODATA;
                targetRange = TypeMap.getPositiveRange(targetType);
            }
        } else {
            boolean bl = needScaling = !targetRange.contains(TypeMap.getRange(sourceType));
        }
        if (needScaling && (min == null || max == null)) {
            boolean computeMax;
            boolean computeMin = min == null;
            if (computeMin) {
                min = new double[numBands];
                Arrays.fill(min, Double.POSITIVE_INFINITY);
            }
            if (computeMax = max == null) {
                max = new double[numBands];
                Arrays.fill(max, Double.NEGATIVE_INFINITY);
            }
            b = 0;
            iterator.startBands();
            if (!iterator.finishedBands()) {
                do {
                    iterator.startLines();
                    if (!iterator.finishedLines()) {
                        do {
                            iterator.startPixels();
                            if (iterator.finishedPixels()) continue;
                            do {
                                double z = iterator.getSampleDouble();
                                if (computeMin && z < min[b]) {
                                    min[b] = z;
                                }
                                if (!computeMax || !(z > max[b])) continue;
                                max[b] = z;
                            } while (!iterator.nextPixelDone());
                        } while (!iterator.nextLineDone());
                    }
                    if (computeMin && computeMax && !(min[b] < max[b])) {
                        min[b] = 0.0;
                        max[b] = 1.0;
                    }
                    ++b;
                } while (!iterator.nextBandDone());
            }
        }
        AbstractInternationalString n = SimpleInternationalString.wrap((CharSequence)name);
        NumberRange sourceRange = TypeMap.getRange(sourceType);
        for (b = 0; b < numBands; ++b) {
            Color[] c;
            Color[] colorArray = c = colors != null ? colors[b] : null;
            if (needScaling) {
                sourceRange = NumberRange.create((double)min[b], (double)max[b]).castTo(sourceRange.getElementClass());
                categories[0] = new Category((CharSequence)n, c, targetRange, sourceRange);
            } else {
                categories[0] = new Category((CharSequence)n, c, targetRange, (MathTransform1D)LinearTransform1D.IDENTITY);
            }
            dst[b] = new GridSampleDimension(name, categories, units).geophysics(true);
        }
    }

    @Override
    public SampleDimensionType getSampleDimensionType() {
        return this.type;
    }

    @Override
    public ColorInterpretation getColorInterpretation() {
        return TypeMap.getColorInterpretation(this.getColorModel(), this.band);
    }

    @Override
    public ColorModel getColorModel() {
        return this.getColorModel(this.band, this.numBands);
    }
}

