/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.AbstractStatsValues;
import org.apache.solr.schema.SchemaField;

class EnumStatsValues
extends AbstractStatsValues<EnumFieldValue> {
    public EnumStatsValues(SchemaField sf, boolean calcDistinct) {
        super(sf, calcDistinct);
    }

    @Override
    public void accumulate(int docID) {
        if (this.values.exists(docID)) {
            Integer intValue = (Integer)this.values.objectVal(docID);
            String stringValue = this.values.strVal(docID);
            EnumFieldValue enumFieldValue = new EnumFieldValue(intValue, stringValue);
            this.accumulate(enumFieldValue, 1);
        } else {
            this.missing();
        }
    }

    @Override
    protected void updateMinMax(EnumFieldValue min, EnumFieldValue max) {
        if (max != null && max.compareTo((EnumFieldValue)this.max) > 0) {
            this.max = max;
        }
        if (this.min == null) {
            this.min = min;
        } else if (((EnumFieldValue)this.min).compareTo(min) > 0) {
            this.min = min;
        }
    }

    @Override
    protected void updateTypeSpecificStats(NamedList stv) {
    }

    @Override
    protected void updateTypeSpecificStats(EnumFieldValue value, int count) {
    }

    @Override
    protected void addTypeSpecificStats(NamedList<Object> res) {
    }
}

