/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.OverseerAutoReplicaFailoverThread;
import org.apache.solr.cloud.OverseerCollectionProcessor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.IOUtils;
import org.apache.solr.util.stats.Clock;
import org.apache.solr.util.stats.Timer;
import org.apache.solr.util.stats.TimerContext;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overseer
implements Closeable {
    public static final String QUEUE_OPERATION = "operation";
    public static final String DELETECORE = "deletecore";
    public static final String REMOVECOLLECTION = "removecollection";
    public static final String REMOVESHARD = "removeshard";
    public static final String ADD_ROUTING_RULE = "addroutingrule";
    public static final String REMOVE_ROUTING_RULE = "removeroutingrule";
    public static final String STATE = "state";
    public static final String QUIT = "quit";
    public static final int STATE_UPDATE_DELAY = 1500;
    public static final String CREATESHARD = "createshard";
    public static final String UPDATESHARDSTATE = "updateshardstate";
    private static Logger log = LoggerFactory.getLogger(Overseer.class);
    private long lastUpdatedTime = 0L;
    private OverseerThread ccThread;
    private OverseerThread updaterThread;
    private OverseerThread arfoThread;
    private final ZkStateReader reader;
    private final ShardHandler shardHandler;
    private final UpdateShardHandler updateShardHandler;
    private final String adminPath;
    private OverseerCollectionProcessor overseerCollectionProcessor;
    private ZkController zkController;
    private Stats stats;
    private String id;
    private boolean closed;
    private ConfigSolr config;

    static void getShardNames(Integer numShards, List<String> shardNames) {
        if (numShards == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param");
        }
        for (int i = 0; i < numShards; ++i) {
            String sliceName = "shard" + (i + 1);
            shardNames.add(sliceName);
        }
    }

    static void getShardNames(List<String> shardNames, String shards) {
        if (shards == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards is a required param");
        }
        for (String s : shards.split(",")) {
            if (s == null || s.trim().isEmpty()) continue;
            shardNames.add(s.trim());
        }
        if (shardNames.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards is a required param");
        }
    }

    public Overseer(ShardHandler shardHandler, UpdateShardHandler updateShardHandler, String adminPath, ZkStateReader reader, ZkController zkController, ConfigSolr config) throws KeeperException, InterruptedException {
        this.reader = reader;
        this.shardHandler = shardHandler;
        this.updateShardHandler = updateShardHandler;
        this.adminPath = adminPath;
        this.zkController = zkController;
        this.stats = new Stats();
        this.config = config;
    }

    public synchronized void start(String id) {
        this.id = id;
        this.closed = false;
        this.doClose();
        log.info("Overseer (id=" + id + ") starting");
        Overseer.createOverseerNode(this.reader.getZkClient());
        ThreadGroup tg = new ThreadGroup("Overseer state updater.");
        this.updaterThread = new OverseerThread(tg, new ClusterStateUpdater(this.reader, id, this.stats), "OverseerStateUpdate-" + id);
        this.updaterThread.setDaemon(true);
        ThreadGroup ccTg = new ThreadGroup("Overseer collection creation process.");
        this.overseerCollectionProcessor = new OverseerCollectionProcessor(this.reader, id, this.shardHandler, this.adminPath, this.stats);
        this.ccThread = new OverseerThread(ccTg, this.overseerCollectionProcessor, "OverseerCollectionProcessor-" + id);
        this.ccThread.setDaemon(true);
        ThreadGroup ohcfTg = new ThreadGroup("Overseer Hdfs SolrCore Failover Thread.");
        OverseerAutoReplicaFailoverThread autoReplicaFailoverThread = new OverseerAutoReplicaFailoverThread(this.config, this.reader, this.updateShardHandler);
        this.arfoThread = new OverseerThread(ohcfTg, autoReplicaFailoverThread, "OverseerHdfsCoreFailoverThread-" + id);
        this.arfoThread.setDaemon(true);
        this.updaterThread.start();
        this.ccThread.start();
        this.arfoThread.start();
    }

    public synchronized OverseerThread getUpdaterThread() {
        return this.updaterThread;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        log.info("Overseer (id=" + this.id + ") closing");
        this.doClose();
        this.closed = true;
    }

    private void doClose() {
        if (this.updaterThread != null) {
            IOUtils.closeQuietly(this.updaterThread);
            this.updaterThread.interrupt();
        }
        if (this.ccThread != null) {
            IOUtils.closeQuietly(this.ccThread);
            this.ccThread.interrupt();
        }
        if (this.arfoThread != null) {
            IOUtils.closeQuietly(this.arfoThread);
            this.arfoThread.interrupt();
        }
        this.updaterThread = null;
        this.ccThread = null;
        this.arfoThread = null;
    }

    public static DistributedQueue getInQueue(SolrZkClient zkClient) {
        return Overseer.getInQueue(zkClient, new Stats());
    }

    static DistributedQueue getInQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue", null, zkStats);
    }

    static DistributedQueue getInternalQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/queue-work", null, zkStats);
    }

    static DistributedMap getRunningMap(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedMap(zkClient, "/overseer/collection-map-running", null);
    }

    static DistributedMap getCompletedMap(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedMap(zkClient, "/overseer/collection-map-completed", null);
    }

    static DistributedMap getFailureMap(SolrZkClient zkClient) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedMap(zkClient, "/overseer/collection-map-failure", null);
    }

    static DistributedQueue getCollectionQueue(SolrZkClient zkClient) {
        return Overseer.getCollectionQueue(zkClient, new Stats());
    }

    static DistributedQueue getCollectionQueue(SolrZkClient zkClient, Stats zkStats) {
        Overseer.createOverseerNode(zkClient);
        return new DistributedQueue(zkClient, "/overseer/collection-queue-work", null, zkStats);
    }

    private static void createOverseerNode(SolrZkClient zkClient) {
        try {
            zkClient.create("/overseer", new byte[0], CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
        }
        catch (InterruptedException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error("Could not create Overseer node", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isLegacy(Map clusterProps) {
        return !"false".equals(clusterProps.get("legacyCloud"));
    }

    public ZkStateReader getZkStateReader() {
        return this.reader;
    }

    static /* synthetic */ long access$200(Overseer x0) {
        return x0.lastUpdatedTime;
    }

    public static class FailedOp {
        public final ZkNodeProps req;
        public final SolrResponse resp;

        public FailedOp(ZkNodeProps req, SolrResponse resp) {
            this.req = req;
            this.resp = resp;
        }
    }

    public static class Stat {
        public final AtomicInteger success = new AtomicInteger();
        public final AtomicInteger errors = new AtomicInteger();
        public final Timer requestTime = new Timer(TimeUnit.MILLISECONDS, TimeUnit.MINUTES, Clock.defaultClock());
        public final LinkedList<FailedOp> failureDetails = new LinkedList();
    }

    public static class Stats {
        static final int MAX_STORED_FAILURES = 10;
        final Map<String, Stat> stats = new ConcurrentHashMap<String, Stat>();

        public Map<String, Stat> getStats() {
            return this.stats;
        }

        public int getSuccessCount(String operation) {
            Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
            return stat == null ? 0 : stat.success.get();
        }

        public int getErrorCount(String operation) {
            Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
            return stat == null ? 0 : stat.errors.get();
        }

        public void success(String operation) {
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            stat.success.incrementAndGet();
        }

        public void error(String operation) {
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            stat.errors.incrementAndGet();
        }

        public TimerContext time(String operation) {
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            return stat.requestTime.time();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void storeFailureDetails(String operation, ZkNodeProps request, SolrResponse resp) {
            LinkedList<FailedOp> failedOps;
            String op = operation.toLowerCase(Locale.ROOT);
            Stat stat = this.stats.get(op);
            if (stat == null) {
                stat = new Stat();
                this.stats.put(op, stat);
            }
            LinkedList<FailedOp> linkedList = failedOps = stat.failureDetails;
            synchronized (linkedList) {
                if (failedOps.size() >= 10) {
                    failedOps.removeFirst();
                }
                failedOps.addLast(new FailedOp(request, resp));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<FailedOp> getFailureDetails(String operation) {
            LinkedList<FailedOp> failedOps;
            Stat stat = this.stats.get(operation.toLowerCase(Locale.ROOT));
            if (stat == null || stat.failureDetails.isEmpty()) {
                return null;
            }
            LinkedList<FailedOp> linkedList = failedOps = stat.failureDetails;
            synchronized (linkedList) {
                ArrayList<FailedOp> ret = new ArrayList<FailedOp>(failedOps);
                return ret;
            }
        }
    }

    class OverseerThread
    extends Thread
    implements Closeable {
        protected volatile boolean isClosed;
        private Closeable thread;

        public OverseerThread(ThreadGroup tg, Closeable thread) {
            super(tg, (Runnable)((Object)thread));
            this.thread = thread;
        }

        public OverseerThread(ThreadGroup ccTg, Closeable thread, String name) {
            super(ccTg, (Runnable)((Object)thread), name);
            this.thread = thread;
        }

        @Override
        public void close() throws IOException {
            this.thread.close();
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }

    private class ClusterStateUpdater
    implements Runnable,
    Closeable {
        private final ZkStateReader reader;
        private final SolrZkClient zkClient;
        private final String myId;
        private final DistributedQueue stateUpdateQueue;
        private final DistributedQueue workQueue;
        private final DistributedMap runningMap;
        private final DistributedMap completedMap;
        private final DistributedMap failureMap;
        private final Stats zkStats;
        private Map clusterProps;
        private boolean isClosed = false;

        public ClusterStateUpdater(ZkStateReader reader, String myId, Stats zkStats) {
            this.zkClient = reader.getZkClient();
            this.zkStats = zkStats;
            this.stateUpdateQueue = Overseer.getInQueue(this.zkClient, zkStats);
            this.workQueue = Overseer.getInternalQueue(this.zkClient, zkStats);
            this.failureMap = Overseer.getFailureMap(this.zkClient);
            this.runningMap = Overseer.getRunningMap(this.zkClient);
            this.completedMap = Overseer.getCompletedMap(this.zkClient);
            this.myId = myId;
            this.reader = reader;
            this.clusterProps = reader.getClusterProps();
        }

        public Stats getStateUpdateQueueStats() {
            return this.stateUpdateQueue.getStats();
        }

        public Stats getWorkQueueStats() {
            return this.workQueue.getStats();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateZkStates(ClusterState clusterState) throws KeeperException, InterruptedException {
            TimerContext timerContext = Overseer.this.stats.time("update_state");
            boolean success = false;
            try {
                this.zkClient.setData("/clusterstate.json", ZkStateReader.toJSON((Object)clusterState), true);
                Overseer.this.lastUpdatedTime = System.nanoTime();
                success = true;
            }
            finally {
                timerContext.stop();
                if (success) {
                    Overseer.this.stats.success("update_state");
                } else {
                    Overseer.this.stats.error("update_state");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkIfIamStillLeader() {
            org.apache.zookeeper.data.Stat stat = new org.apache.zookeeper.data.Stat();
            String path = "/overseer_elect/leader";
            byte[] data = null;
            try {
                data = this.zkClient.getData(path, null, stat, true);
            }
            catch (Exception e) {
                log.error("could not read the data", (Throwable)e);
                return;
            }
            try {
                Map m = (Map)ZkStateReader.fromJSON((byte[])data);
                String id = (String)m.get("id");
                if (Overseer.this.overseerCollectionProcessor.getId().equals(id)) {
                    try {
                        log.info("I'm exiting , but I'm still the leader");
                        this.zkClient.delete(path, stat.getVersion(), true);
                    }
                    catch (KeeperException.BadVersionException e) {
                    }
                    catch (Exception e) {
                        log.error("Could not delete my leader node ", (Throwable)e);
                    }
                } else {
                    log.info("somebody else has already taken up the overseer position");
                }
            }
            finally {
                try {
                    if (Overseer.this.zkController != null && !Overseer.this.zkController.getCoreContainer().isShutDown()) {
                        Overseer.this.zkController.rejoinOverseerElection(null, false);
                    }
                }
                catch (Exception e) {
                    log.warn("Unable to rejoinElection ", (Throwable)e);
                }
            }
        }

        private ClusterState processMessage(ClusterState clusterState, ZkNodeProps message, String operation) {
            if (Overseer.STATE.equals(operation)) {
                clusterState = Overseer.isLegacy(this.clusterProps) ? this.updateState(clusterState, message) : this.updateStateNew(clusterState, message);
            } else if (Overseer.DELETECORE.equals(operation)) {
                clusterState = this.removeCore(clusterState, message);
            } else if (Overseer.REMOVECOLLECTION.equals(operation)) {
                clusterState = this.removeCollection(clusterState, message);
            } else if (Overseer.REMOVESHARD.equals(operation)) {
                clusterState = this.removeShard(clusterState, message);
            } else if ("leader".equals(operation)) {
                StringBuilder sb = new StringBuilder();
                String baseUrl = message.getStr("base_url");
                String coreName = message.getStr("core");
                sb.append(baseUrl);
                if (baseUrl != null && !baseUrl.endsWith("/")) {
                    sb.append("/");
                }
                sb.append(coreName == null ? "" : coreName);
                if (!sb.substring(sb.length() - 1).equals("/")) {
                    sb.append("/");
                }
                clusterState = this.setShardLeader(clusterState, message.getStr("collection"), message.getStr("shard"), sb.length() > 0 ? sb.toString() : null);
            } else if (Overseer.CREATESHARD.equals(operation)) {
                clusterState = this.createShard(clusterState, message);
            } else if (Overseer.UPDATESHARDSTATE.equals(operation)) {
                clusterState = this.updateShardState(clusterState, message);
            } else if ("createcollection".equals(operation)) {
                clusterState = this.buildCollection(clusterState, message);
            } else if (CollectionParams.CollectionAction.ADDREPLICA.isEqual(operation)) {
                clusterState = this.createReplica(clusterState, message);
            } else if (Overseer.ADD_ROUTING_RULE.equals(operation)) {
                clusterState = this.addRoutingRule(clusterState, message);
            } else if (Overseer.REMOVE_ROUTING_RULE.equals(operation)) {
                clusterState = this.removeRoutingRule(clusterState, message);
            } else if (CollectionParams.CollectionAction.CLUSTERPROP.isEqual(operation)) {
                this.handleProp(message);
            } else if (Overseer.QUIT.equals(operation)) {
                if (this.myId.equals(message.get("id"))) {
                    log.info("Quit command received {}", (Object)LeaderElector.getNodeName(this.myId));
                    Overseer.this.overseerCollectionProcessor.close();
                    this.close();
                } else {
                    log.warn("Overseer received wrong QUIT message {}", (Object)message);
                }
            } else {
                throw new RuntimeException("unknown operation:" + operation + " contents:" + message.getProperties());
            }
            return clusterState;
        }

        private void handleProp(ZkNodeProps message) {
            String name = message.getStr("name");
            String val = message.getStr("val");
            Map m = this.reader.getClusterProps();
            if (val == null) {
                m.remove(name);
            } else {
                m.put(name, val);
            }
            try {
                if (this.reader.getZkClient().exists("/clusterprops.json", true).booleanValue()) {
                    this.reader.getZkClient().setData("/clusterprops.json", ZkStateReader.toJSON((Object)m), true);
                } else {
                    this.reader.getZkClient().create("/clusterprops.json", ZkStateReader.toJSON((Object)m), CreateMode.PERSISTENT, true);
                }
                this.clusterProps = this.reader.getClusterProps();
            }
            catch (Exception e) {
                log.error("Unable to set cluster property", (Throwable)e);
            }
        }

        private ClusterState createReplica(ClusterState clusterState, ZkNodeProps message) {
            log.info("createReplica() {} ", (Object)message);
            String coll = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            String slice = message.getStr("shard");
            Slice sl = clusterState.getSlice(coll, slice);
            if (sl == null) {
                log.error("Invalid Collection/Slice {}/{} ", (Object)coll, (Object)slice);
                return clusterState;
            }
            String coreNodeName = Assign.assignNode(coll, clusterState);
            Replica replica = new Replica(coreNodeName, ZkNodeProps.makeMap((Object[])new Object[]{"core", message.getStr("core"), "base_url", message.getStr("base_url"), Overseer.STATE, message.getStr(Overseer.STATE)}));
            sl.getReplicasMap().put(coreNodeName, replica);
            return clusterState;
        }

        private ClusterState buildCollection(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("name");
            log.info("building a new collection: " + collection);
            if (clusterState.hasCollection(collection)) {
                log.warn("Collection {} already exists. exit", (Object)collection);
                return clusterState;
            }
            ArrayList<String> shardNames = new ArrayList<String>();
            if ("implicit".equals(message.getStr("router.name", "compositeId"))) {
                Overseer.getShardNames(shardNames, message.getStr("shards", "compositeId"));
            } else {
                int numShards = message.getInt("numShards", Integer.valueOf(-1));
                if (numShards < 1) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "numShards is a required parameter for 'compositeId' router");
                }
                Overseer.getShardNames(numShards, shardNames);
            }
            return this.createCollection(clusterState, collection, shardNames, message);
        }

        private ClusterState updateShardState(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            log.info("Update shard state invoked for collection: " + collection + " with message: " + message);
            for (String key : message.keySet()) {
                if ("collection".equals(key) || Overseer.QUEUE_OPERATION.equals(key)) continue;
                Slice slice = clusterState.getSlice(collection, key);
                if (slice == null) {
                    throw new RuntimeException("Overseer.updateShardState unknown collection: " + collection + " slice: " + key);
                }
                log.info("Update shard state " + key + " to " + message.getStr(key));
                Map props = slice.shallowCopy();
                if (Slice.RECOVERY.equals(props.get(Slice.STATE)) && Slice.ACTIVE.equals(message.getStr(key))) {
                    props.remove(Slice.PARENT);
                }
                props.put(Slice.STATE, message.getStr(key));
                Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props);
                clusterState = this.updateSlice(clusterState, collection, newSlice);
            }
            return clusterState;
        }

        private ClusterState addRoutingRule(ClusterState clusterState, ZkNodeProps message) {
            HashMap<String, String> map;
            RoutingRule r;
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            String shard = message.getStr("shard");
            String routeKey = message.getStr("routeKey");
            String range = message.getStr("range");
            String targetCollection = message.getStr("targetCollection");
            String targetShard = message.getStr("targetShard");
            String expireAt = message.getStr("expireAt");
            Slice slice = clusterState.getSlice(collection, shard);
            if (slice == null) {
                throw new RuntimeException("Overseer.addRoutingRule unknown collection: " + collection + " slice:" + shard);
            }
            HashMap<String, RoutingRule> routingRules = slice.getRoutingRules();
            if (routingRules == null) {
                routingRules = new HashMap<String, RoutingRule>();
            }
            if ((r = (RoutingRule)routingRules.get(routeKey)) == null) {
                map = new HashMap<String, String>();
                map.put("routeRanges", range);
                map.put("targetCollection", targetCollection);
                map.put("expireAt", expireAt);
                RoutingRule rule = new RoutingRule(routeKey, map);
                routingRules.put(routeKey, rule);
            } else {
                map = r.shallowCopy();
                map.put("routeRanges", map.get("routeRanges") + "," + range);
                map.put("expireAt", expireAt);
                routingRules.put(routeKey, new RoutingRule(routeKey, map));
            }
            Map props = slice.shallowCopy();
            props.put("routingRules", routingRules);
            Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props);
            clusterState = this.updateSlice(clusterState, collection, newSlice);
            return clusterState;
        }

        private boolean checkCollectionKeyExistence(ZkNodeProps message) {
            return this.checkKeyExistence(message, "collection");
        }

        private boolean checkKeyExistence(ZkNodeProps message, String key) {
            String value = message.getStr(key);
            if (value == null || value.trim().length() == 0) {
                log.error("Skipping invalid Overseer message because it has no " + key + " specified: " + message);
                return false;
            }
            return true;
        }

        private ClusterState removeRoutingRule(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            String shard = message.getStr("shard");
            String routeKeyStr = message.getStr("routeKey");
            log.info("Overseer.removeRoutingRule invoked for collection: " + collection + " shard: " + shard + " routeKey: " + routeKeyStr);
            Slice slice = clusterState.getSlice(collection, shard);
            if (slice == null) {
                log.warn("Unknown collection: " + collection + " shard: " + shard);
                return clusterState;
            }
            Map routingRules = slice.getRoutingRules();
            if (routingRules != null) {
                routingRules.remove(routeKeyStr);
                Map props = slice.shallowCopy();
                props.put("routingRules", routingRules);
                Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props);
                clusterState = this.updateSlice(clusterState, collection, newSlice);
            }
            return clusterState;
        }

        private ClusterState createShard(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            String shardId = message.getStr("shard");
            Slice slice = clusterState.getSlice(collection, shardId);
            if (slice == null) {
                Map replicas = Collections.EMPTY_MAP;
                HashMap<String, String> sliceProps = new HashMap<String, String>();
                String shardRange = message.getStr("shard_range");
                String shardState = message.getStr("shard_state");
                String shardParent = message.getStr("shard_parent");
                sliceProps.put(Slice.RANGE, shardRange);
                sliceProps.put(Slice.STATE, shardState);
                if (shardParent != null) {
                    sliceProps.put(Slice.PARENT, shardParent);
                }
                slice = new Slice(shardId, replicas, sliceProps);
                clusterState = this.updateSlice(clusterState, collection, slice);
            } else {
                log.error("Unable to create Shard: " + shardId + " because it already exists in collection: " + collection);
            }
            return clusterState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LeaderStatus amILeader() {
            TimerContext timerContext = Overseer.this.stats.time("am_i_leader");
            boolean success = true;
            try {
                ZkNodeProps props = ZkNodeProps.load((byte[])this.zkClient.getData("/overseer_elect/leader", null, null, true));
                if (this.myId.equals(props.getStr("id"))) {
                    LeaderStatus leaderStatus = LeaderStatus.YES;
                    return leaderStatus;
                }
            }
            catch (KeeperException e) {
                success = false;
                if (e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.error("", (Throwable)e);
                    LeaderStatus leaderStatus = LeaderStatus.DONT_KNOW;
                    return leaderStatus;
                }
                if (e.code() == KeeperException.Code.SESSIONEXPIRED) {
                    log.info("", (Throwable)e);
                } else {
                    log.warn("", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                success = false;
                Thread.currentThread().interrupt();
            }
            finally {
                timerContext.stop();
                if (success) {
                    Overseer.this.stats.success("am_i_leader");
                } else {
                    Overseer.this.stats.error("am_i_leader");
                }
            }
            log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
            return LeaderStatus.NO;
        }

        private ClusterState updateStateNew(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            String sliceName = message.getStr("shard");
            if (collection == null || sliceName == null) {
                log.error("Invalid collection and slice {}", (Object)message);
                return clusterState;
            }
            Slice slice = clusterState.getSlice(collection, sliceName);
            if (slice == null) {
                log.error("No such slice exists {}", (Object)message);
                return clusterState;
            }
            return this.updateState(clusterState, message);
        }

        private ClusterState updateState(ClusterState clusterState, ZkNodeProps message) {
            Map<String, Replica> replicas;
            Replica oldReplica;
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            Integer numShards = message.getInt("numShards", null);
            log.info("Update state numShards={} message={}", (Object)numShards, (Object)message);
            ArrayList<String> shardNames = new ArrayList<String>();
            boolean collectionExists = clusterState.hasCollection(collection);
            if (!collectionExists && numShards != null) {
                Overseer.getShardNames(numShards, shardNames);
                clusterState = this.createCollection(clusterState, collection, shardNames, message);
            }
            String sliceName = message.getStr("shard");
            String coreNodeName = message.getStr("core_node_name");
            if (coreNodeName == null) {
                coreNodeName = this.getAssignedCoreNodeName(clusterState, message);
                if (coreNodeName != null) {
                    log.info("node=" + coreNodeName + " is already registered");
                } else {
                    coreNodeName = Assign.assignNode(collection, clusterState);
                }
                message.getProperties().put("core_node_name", coreNodeName);
            }
            if (sliceName == null && (sliceName = this.getAssignedId(clusterState, coreNodeName, message)) != null) {
                log.info("shard=" + sliceName + " is already registered");
            }
            if (sliceName == null) {
                if (collectionExists) {
                    numShards = clusterState.getCollection(collection).getSlices().size();
                    log.info("Collection already exists with numShards=" + numShards);
                }
                sliceName = Assign.assignShard(collection, clusterState, numShards);
                log.info("Assigning new node to shard shard=" + sliceName);
            }
            Slice slice = clusterState.getSlice(collection, sliceName);
            LinkedHashMap<String, Object> replicaProps = new LinkedHashMap<String, Object>();
            replicaProps.putAll(message.getProperties());
            if (slice != null && (oldReplica = (Replica)slice.getReplicasMap().get(coreNodeName)) != null && oldReplica.containsKey("leader")) {
                replicaProps.put("leader", oldReplica.get("leader"));
            }
            replicaProps.remove("numShards");
            replicaProps.remove("core_node_name");
            replicaProps.remove("shard");
            replicaProps.remove("collection");
            replicaProps.remove(Overseer.QUEUE_OPERATION);
            Set entrySet = replicaProps.entrySet();
            ArrayList removeKeys = new ArrayList();
            for (Map.Entry entry : entrySet) {
                if (entry.getValue() != null) continue;
                removeKeys.add(entry.getKey());
            }
            for (String removeKey : removeKeys) {
                replicaProps.remove(removeKey);
            }
            replicaProps.remove("core_node_name");
            String shardRange = (String)replicaProps.remove("shard_range");
            String shardState = (String)replicaProps.remove("shard_state");
            String shardParent = (String)replicaProps.remove("shard_parent");
            Replica replica = new Replica(coreNodeName, replicaProps);
            Map<String, String> sliceProps = null;
            if (slice != null) {
                clusterState = this.checkAndCompleteShardSplit(clusterState, collection, coreNodeName, sliceName, replicaProps);
                slice = clusterState.getSlice(collection, sliceName);
                sliceProps = slice.getProperties();
                replicas = slice.getReplicasCopy();
            } else {
                replicas = new HashMap(1);
                sliceProps = new HashMap<String, String>();
                sliceProps.put(Slice.RANGE, shardRange);
                sliceProps.put(Slice.STATE, shardState);
                sliceProps.put(Slice.PARENT, shardParent);
            }
            replicas.put(replica.getName(), replica);
            slice = new Slice(sliceName, replicas, sliceProps);
            ClusterState newClusterState = this.updateSlice(clusterState, collection, slice);
            return newClusterState;
        }

        private ClusterState checkAndCompleteShardSplit(ClusterState state, String collection, String coreNodeName, String sliceName, Map<String, Object> replicaProps) {
            Slice slice = state.getSlice(collection, sliceName);
            Map sliceProps = slice.getProperties();
            String sliceState = slice.getState();
            if (Slice.RECOVERY.equals(sliceState)) {
                log.info("Shard: {} is in recovery state", (Object)sliceName);
                if ("active".equals(replicaProps.get(Overseer.STATE))) {
                    log.info("Shard: {} is in recovery state and coreNodeName: {} is active", (Object)sliceName, (Object)coreNodeName);
                    boolean allActive = true;
                    for (Map.Entry entry : slice.getReplicasMap().entrySet()) {
                        if (coreNodeName.equals(entry.getKey()) || Slice.ACTIVE.equals(((Replica)entry.getValue()).getStr(Slice.STATE))) continue;
                        allActive = false;
                        break;
                    }
                    if (allActive) {
                        log.info("Shard: {} - all replicas are active. Finding status of fellow sub-shards", (Object)sliceName);
                        HashMap allSlicesCopy = new HashMap(state.getSlicesMap(collection));
                        ArrayList<Slice> subShardSlices = new ArrayList<Slice>();
                        block1: for (Map.Entry entry : allSlicesCopy.entrySet()) {
                            Slice otherSlice;
                            if (sliceName.equals(entry.getKey()) || !Slice.RECOVERY.equals((otherSlice = (Slice)entry.getValue()).getState()) || slice.getParent() == null || !slice.getParent().equals(otherSlice.getParent())) continue;
                            log.info("Shard: {} - Fellow sub-shard: {} found", (Object)sliceName, (Object)otherSlice.getName());
                            for (Map.Entry sliceEntry : otherSlice.getReplicasMap().entrySet()) {
                                if ("active".equals(((Replica)sliceEntry.getValue()).getStr(Overseer.STATE))) continue;
                                allActive = false;
                                break block1;
                            }
                            log.info("Shard: {} - Fellow sub-shard: {} has all replicas active", (Object)sliceName, (Object)otherSlice.getName());
                            subShardSlices.add(otherSlice);
                        }
                        if (allActive) {
                            log.info("Shard: {} - All replicas across all fellow sub-shards are now ACTIVE. Preparing to switch shard states.", (Object)sliceName);
                            String parentSliceName = (String)sliceProps.remove(Slice.PARENT);
                            HashMap<String, String> propMap = new HashMap<String, String>();
                            propMap.put(Overseer.QUEUE_OPERATION, Overseer.UPDATESHARDSTATE);
                            propMap.put(parentSliceName, Slice.INACTIVE);
                            propMap.put(sliceName, Slice.ACTIVE);
                            for (Slice subShardSlice : subShardSlices) {
                                propMap.put(subShardSlice.getName(), Slice.ACTIVE);
                            }
                            propMap.put("collection", collection);
                            ZkNodeProps m = new ZkNodeProps(propMap);
                            state = this.updateShardState(state, m);
                        }
                    }
                }
            }
            return state;
        }

        private ClusterState createCollection(ClusterState state, String collectionName, List<String> shards, ZkNodeProps message) {
            log.info("Create collection {} with shards {}", (Object)collectionName, shards);
            Map routerSpec = DocRouter.getRouterSpec((ZkNodeProps)message);
            String routerName = routerSpec.get("name") == null ? "compositeId" : (String)routerSpec.get("name");
            DocRouter router = DocRouter.getDocRouter((String)routerName);
            List ranges = router.partitionRange(shards.size(), router.fullRange());
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
            for (int i = 0; i < shards.size(); ++i) {
                String sliceName = shards.get(i);
                LinkedHashMap<String, DocRouter.Range> sliceProps = new LinkedHashMap<String, DocRouter.Range>(1);
                sliceProps.put(Slice.RANGE, ranges == null ? null : (DocRouter.Range)ranges.get(i));
                newSlices.put(sliceName, new Slice(sliceName, null, sliceProps));
            }
            HashMap<String, Object> collectionProps = new HashMap<String, Object>();
            for (Map.Entry<String, Object> e : OverseerCollectionProcessor.COLL_PROPS.entrySet()) {
                Object val = message.get(e.getKey());
                if (val == null) {
                    val = OverseerCollectionProcessor.COLL_PROPS.get(e.getKey());
                }
                if (val == null) continue;
                collectionProps.put(e.getKey(), val);
            }
            collectionProps.put("router", routerSpec);
            if (message.getStr("fromApi") == null) {
                collectionProps.put("autoCreated", "true");
            }
            DocCollection newCollection = new DocCollection(collectionName, newSlices, collectionProps, router);
            return state.copyWith(Collections.singletonMap(newCollection.getName(), newCollection));
        }

        private String getAssignedId(ClusterState state, String nodeName, ZkNodeProps coreState) {
            Collection slices = state.getSlices(coreState.getStr("collection"));
            if (slices != null) {
                for (Slice slice : slices) {
                    if (slice.getReplicasMap().get(nodeName) == null) continue;
                    return slice.getName();
                }
            }
            return null;
        }

        private String getAssignedCoreNodeName(ClusterState state, ZkNodeProps message) {
            Collection slices = state.getSlices(message.getStr("collection"));
            if (slices != null) {
                for (Slice slice : slices) {
                    for (Replica replica : slice.getReplicas()) {
                        String nodeName = replica.getStr("node_name");
                        String core = replica.getStr("core");
                        String msgNodeName = message.getStr("node_name");
                        String msgCore = message.getStr("core");
                        if (!nodeName.equals(msgNodeName) || !core.equals(msgCore)) continue;
                        return replica.getName();
                    }
                }
            }
            return null;
        }

        private ClusterState updateSlice(ClusterState state, String collectionName, Slice slice) {
            DocRouter router;
            HashMap<String, Map> props;
            HashMap<String, Slice> slices;
            LinkedHashMap<String, DocCollection> newCollections = new LinkedHashMap<String, DocCollection>(state.getCollectionStates());
            DocCollection coll = (DocCollection)newCollections.get(collectionName);
            if (coll == null) {
                slices = new HashMap<String, Slice>(1);
                props = new HashMap<String, Map>(1);
                props.put("router", ZkNodeProps.makeMap((Object[])new Object[]{"name", "implicit"}));
                router = new ImplicitDocRouter();
            } else {
                props = coll.getProperties();
                router = coll.getRouter();
                slices = new LinkedHashMap(coll.getSlicesMap());
            }
            slices.put(slice.getName(), slice);
            DocCollection newCollection = new DocCollection(collectionName, slices, props, router);
            newCollections.put(collectionName, newCollection);
            return new ClusterState(state.getLiveNodes(), newCollections);
        }

        private ClusterState setShardLeader(ClusterState state, String collectionName, String sliceName, String leaderUrl) {
            LinkedHashMap<String, DocCollection> newCollections = new LinkedHashMap<String, DocCollection>(state.getCollectionStates());
            DocCollection coll = (DocCollection)newCollections.get(collectionName);
            if (coll == null) {
                log.error("Could not mark shard leader for non existing collection:" + collectionName);
                return state;
            }
            LinkedHashMap<String, Slice> slices = coll.getSlicesMap();
            Slice slice = (Slice)(slices = new LinkedHashMap<String, Slice>(slices)).get(sliceName);
            if (slice == null) {
                slice = coll.getSlice(sliceName);
            }
            if (slice == null) {
                log.error("Could not mark leader for non existing/active slice:" + sliceName);
                return state;
            }
            Replica oldLeader = slice.getLeader();
            LinkedHashMap<String, Replica> newReplicas = new LinkedHashMap<String, Replica>();
            for (Replica replica : slice.getReplicas()) {
                LinkedHashMap<String, String> replicaProps;
                String coreURL = ZkCoreNodeProps.getCoreUrl((String)replica.getStr("base_url"), (String)replica.getStr("core"));
                if (replica == oldLeader && !coreURL.equals(leaderUrl)) {
                    replicaProps = new LinkedHashMap<String, String>(replica.getProperties());
                    replicaProps.remove(Slice.LEADER);
                    replica = new Replica(replica.getName(), replicaProps);
                } else if (coreURL.equals(leaderUrl)) {
                    replicaProps = new LinkedHashMap(replica.getProperties());
                    replicaProps.put(Slice.LEADER, "true");
                    replica = new Replica(replica.getName(), replicaProps);
                }
                newReplicas.put(replica.getName(), replica);
            }
            Map newSliceProps = slice.shallowCopy();
            newSliceProps.put(Slice.REPLICAS, newReplicas);
            Slice newSlice = new Slice(slice.getName(), newReplicas, slice.getProperties());
            slices.put(newSlice.getName(), newSlice);
            DocCollection newCollection = new DocCollection(coll.getName(), slices, coll.getProperties(), coll.getRouter());
            newCollections.put(collectionName, newCollection);
            return new ClusterState(state.getLiveNodes(), newCollections);
        }

        private ClusterState newState(ClusterState state, Map<String, DocCollection> colls) {
            return state.copyWith(colls);
        }

        private ClusterState removeCollection(ClusterState clusterState, ZkNodeProps message) {
            String collection = message.getStr("name");
            if (!this.checkKeyExistence(message, "name")) {
                return clusterState;
            }
            return clusterState.copyWith(Collections.singletonMap(collection, null));
        }

        private ClusterState removeShard(ClusterState clusterState, ZkNodeProps message) {
            String sliceId = message.getStr("shard");
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            log.info("Removing collection: " + collection + " shard: " + sliceId + " from clusterstate");
            DocCollection coll = clusterState.getCollection(collection);
            LinkedHashMap newSlices = new LinkedHashMap(coll.getSlicesMap());
            newSlices.remove(sliceId);
            DocCollection newCollection = new DocCollection(coll.getName(), newSlices, coll.getProperties(), coll.getRouter());
            return this.newState(clusterState, Collections.singletonMap(collection, newCollection));
        }

        private ClusterState removeCore(ClusterState clusterState, ZkNodeProps message) {
            String cnn = message.getStr("core_node_name");
            String collection = message.getStr("collection");
            if (!this.checkCollectionKeyExistence(message)) {
                return clusterState;
            }
            DocCollection coll = clusterState.getCollectionOrNull(collection);
            if (coll == null) {
                try {
                    this.zkClient.clean("/collections/" + collection);
                }
                catch (InterruptedException e) {
                    SolrException.log((Logger)log, (String)("Cleaning up collection in zk was interrupted:" + collection), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException e) {
                    SolrException.log((Logger)log, (String)("Problem cleaning up collection in zk:" + collection), (Throwable)e);
                }
                return clusterState;
            }
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
            boolean lastSlice = false;
            for (Slice slice : coll.getSlices()) {
                Replica replica = slice.getReplica(cnn);
                if (replica != null) {
                    Map newReplicas = slice.getReplicasCopy();
                    newReplicas.remove(cnn);
                    if (newReplicas.size() == 0) {
                        slice = null;
                        lastSlice = true;
                    } else {
                        slice = new Slice(slice.getName(), newReplicas, slice.getProperties());
                    }
                }
                if (slice == null) continue;
                newSlices.put(slice.getName(), slice);
            }
            if (lastSlice) {
                for (Slice slice : coll.getSlices()) {
                    if (slice.getReplicas().size() != 0) continue;
                    newSlices.remove(slice.getName());
                }
            }
            if (newSlices.size() == 0) {
                try {
                    this.zkClient.clean("/collections/" + collection);
                }
                catch (InterruptedException e) {
                    SolrException.log((Logger)log, (String)("Cleaning up collection in zk was interrupted:" + collection), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException e) {
                    SolrException.log((Logger)log, (String)("Problem cleaning up collection in zk:" + collection), (Throwable)e);
                }
                return this.newState(clusterState, Collections.singletonMap(collection, null));
            }
            DocCollection newCollection = new DocCollection(coll.getName(), newSlices, coll.getProperties(), coll.getRouter());
            return this.newState(clusterState, Collections.singletonMap(collection, newCollection));
        }

        @Override
        public void close() {
            this.isClosed = true;
        }
    }

    static enum LeaderStatus {
        DONT_KNOW,
        NO,
        YES;

    }
}

