/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public enum Rank {
    DOMAIN("dom."),
    KINGDOM("king."),
    SUBKINGDOM("subking."),
    SUPERPHYLUM("superphyl."),
    PHYLUM("phyl."),
    SUBPHYLUM("subphyl."),
    SUPERCLASS("supercl."),
    CLASS("cl."),
    SUBCLASS("subcl."),
    SUPERORDER("superord."),
    ORDER("ord."),
    SUBORDER("subord."),
    INFRAORDER(null),
    SUPERFAMILY("superfam."),
    FAMILY("fam."),
    SUBFAMILY("subfam."),
    TRIBE("trib."),
    SUBTRIBE("subtrib."),
    SUPRAGENERIC_NAME("supergen."),
    GENUS("gen."),
    SUBGENUS("subgen."),
    SECTION("sect."),
    SUBSECTION("subsect."),
    SERIES("ser."),
    SUBSERIES("subser."),
    INFRAGENERIC_NAME("infragen."),
    SPECIES("sp."),
    INFRASPECIFIC_NAME("agg."),
    SUBSPECIES("subsp."),
    INFRASUBSPECIFIC_NAME("infrasubsp."),
    VARIETY("var."),
    SUBVARIETY("subvar."),
    PATHOVAR("pv."),
    FORM("f."),
    SUBFORM("subf."),
    CULTIVAR_GROUP,
    CULTIVAR("cv."),
    STRAIN("strain"),
    INFORMAL,
    UNRANKED;

    public static final List<Rank> LINNEAN_RANKS;
    public static final List<Rank> DWC_RANKS;
    public static final Set<Rank> UNCOMPARABLE_RANKS;
    public static final Set<Rank> SPECIES_OR_BELOW;
    public static final Map<String, Rank> RANK_MARKER_MAP;
    public static final Map<String, Rank> RANK_MARKER_MAP_SUPRAGENERIC;
    public static final Map<String, Rank> RANK_MARKER_MAP_INFRAGENERIC;
    public static final Map<String, Rank> RANK_MARKER_MAP_INFRASPECIFIC;
    public static final SortedMap<String, Rank> SUFFICES_RANK_MAP;
    public static final Map<String, Rank> ABBREVIATION_RANK_BI_MAP;
    private static final Pattern NORMALIZE_TERM;
    private final String marker;

    public static Rank inferRank(@Nullable String rankMarker) {
        Rank markerRank;
        if (rankMarker != null && (markerRank = RANK_MARKER_MAP.get(NORMALIZE_TERM.matcher(rankMarker.toLowerCase()).replaceAll(""))) != null) {
            return markerRank;
        }
        return null;
    }

    public static Rank inferRank(@Nullable String genusOrAbove, @Nullable String infraGeneric, @Nullable String specificEpithet, @Nullable String rankMarker, @Nullable String infraSpecificEpithet) {
        Rank markerRank = Rank.inferRank(rankMarker);
        if (markerRank != null) {
            return markerRank;
        }
        Rank rank = UNRANKED;
        if (infraSpecificEpithet != null) {
            rank = INFRASPECIFIC_NAME;
        } else if (specificEpithet != null) {
            rank = SPECIES;
        } else if (infraGeneric != null) {
            rank = INFRAGENERIC_NAME;
        } else if (genusOrAbove != null) {
            for (String suffix : SUFFICES_RANK_MAP.keySet()) {
                if (!genusOrAbove.endsWith(suffix)) continue;
                rank = (Rank)((Object)SUFFICES_RANK_MAP.get(suffix));
                break;
            }
        }
        return rank;
    }

    private Rank() {
        this(null);
    }

    private Rank(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public boolean isInfraspecific() {
        return this.isSpeciesOrBelow() && this != SPECIES && this != CULTIVAR && this != CULTIVAR_GROUP && this != STRAIN;
    }

    public boolean isInfrageneric() {
        return this.ordinal() > GENUS.ordinal() && this != UNRANKED && this != INFORMAL;
    }

    public boolean isLinnean() {
        for (Rank r : LINNEAN_RANKS) {
            if (r != this) continue;
            return true;
        }
        return false;
    }

    public boolean isSpeciesOrBelow() {
        return SPECIES_OR_BELOW.contains((Object)this);
    }

    public boolean isSuprageneric() {
        return this.ordinal() < GENUS.ordinal();
    }

    public boolean isUncomparable() {
        return UNCOMPARABLE_RANKS.contains((Object)this);
    }

    public boolean higherThan(Rank other) {
        return this.ordinal() < other.ordinal();
    }

    static {
        SUFFICES_RANK_MAP = new ImmutableSortedMap.Builder((Comparator)Ordering.natural()).put((Object)"mycetidae", (Object)SUBCLASS).put((Object)"phycidae", (Object)SUBCLASS).put((Object)"mycotina", (Object)SUBPHYLUM).put((Object)"phytina", (Object)SUBPHYLUM).put((Object)"phyceae", (Object)CLASS).put((Object)"mycetes", (Object)CLASS).put((Object)"mycota", (Object)PHYLUM).put((Object)"opsida", (Object)CLASS).put((Object)"oideae", (Object)SUBFAMILY).put((Object)"aceae", (Object)FAMILY).put((Object)"phyta", (Object)PHYLUM).put((Object)"oidea", (Object)SUPERFAMILY).put((Object)"anae", (Object)SUPERORDER).put((Object)"ales", (Object)ORDER).put((Object)"acea", (Object)SUPERFAMILY).put((Object)"idae", (Object)FAMILY).put((Object)"inae", (Object)SUBFAMILY).put((Object)"eae", (Object)TRIBE).put((Object)"ini", (Object)TRIBE).build();
        ABBREVIATION_RANK_BI_MAP = new ImmutableBiMap.Builder().put((Object)"k", (Object)KINGDOM).put((Object)"sk", (Object)SUBKINGDOM).put((Object)"p", (Object)PHYLUM).put((Object)"sp", (Object)SUBPHYLUM).put((Object)"c", (Object)CLASS).put((Object)"sc", (Object)SUBCLASS).put((Object)"o", (Object)ORDER).put((Object)"so", (Object)SUBORDER).put((Object)"f", (Object)FAMILY).put((Object)"sf", (Object)SUBFAMILY).put((Object)"g", (Object)GENUS).put((Object)"sg", (Object)SUBGENUS).put((Object)"s", (Object)SPECIES).put((Object)"ss", (Object)SUBSPECIES).put((Object)"is", (Object)INFRASPECIFIC_NAME).put((Object)"v", (Object)VARIETY).put((Object)"ff", (Object)FORM).build();
        NORMALIZE_TERM = Pattern.compile("[._ -]+");
        ArrayList dwcRanks = Lists.newArrayList();
        dwcRanks.add(KINGDOM);
        dwcRanks.add(PHYLUM);
        dwcRanks.add(CLASS);
        dwcRanks.add(ORDER);
        dwcRanks.add(FAMILY);
        dwcRanks.add(GENUS);
        dwcRanks.add(SUBGENUS);
        dwcRanks.add(SPECIES);
        DWC_RANKS = ImmutableList.copyOf((Collection)dwcRanks);
        dwcRanks.remove((Object)SUBGENUS);
        LINNEAN_RANKS = ImmutableList.copyOf((Collection)dwcRanks);
        HashSet<Rank> ranks = new HashSet<Rank>();
        ranks.add(INFRAGENERIC_NAME);
        ranks.add(INFRASPECIFIC_NAME);
        ranks.add(INFRASUBSPECIFIC_NAME);
        ranks.add(INFORMAL);
        ranks.add(UNRANKED);
        UNCOMPARABLE_RANKS = ImmutableSet.copyOf(ranks);
        ranks = new HashSet();
        ranks.add(SPECIES);
        ranks.add(INFRASPECIFIC_NAME);
        ranks.add(SUBSPECIES);
        ranks.add(INFRASUBSPECIFIC_NAME);
        ranks.add(VARIETY);
        ranks.add(SUBVARIETY);
        ranks.add(PATHOVAR);
        ranks.add(FORM);
        ranks.add(SUBFORM);
        ranks.add(CULTIVAR_GROUP);
        ranks.add(CULTIVAR);
        ranks.add(STRAIN);
        SPECIES_OR_BELOW = ImmutableSet.copyOf(ranks);
        HashMap<String, Rank> ranks2 = new HashMap<String, Rank>();
        ranks2.put("fam", FAMILY);
        ranks2.put("trib", TRIBE);
        ranks2.put("sect", SECTION);
        ranks2.put("supertrib", SUPRAGENERIC_NAME);
        ranks2.put("supersubtrib", SUPRAGENERIC_NAME);
        ranks2.put("ib", SUPRAGENERIC_NAME);
        ranks2.put("gen", GENUS);
        RANK_MARKER_MAP_SUPRAGENERIC = ImmutableMap.copyOf(ranks2);
        ranks2 = new HashMap();
        ranks2.put("subgenus", SUBGENUS);
        ranks2.put("subgen", SUBGENUS);
        ranks2.put("subg", SUBGENUS);
        ranks2.put("section", SECTION);
        ranks2.put("sect", SECTION);
        ranks2.put("subsection", SUBSECTION);
        ranks2.put("subsect", SUBSECTION);
        ranks2.put("series", SERIES);
        ranks2.put("ser", SERIES);
        ranks2.put("subseries", SUBSERIES);
        ranks2.put("subser", SUBSERIES);
        ranks2.put("agg", INFRAGENERIC_NAME);
        ranks2.put("species", SPECIES);
        ranks2.put("spec", SPECIES);
        ranks2.put("spp", SPECIES);
        ranks2.put("sp", SPECIES);
        RANK_MARKER_MAP_INFRAGENERIC = ImmutableMap.copyOf(ranks2);
        ranks2 = new HashMap();
        ranks2.put("subsp", SUBSPECIES);
        ranks2.put("ssp", SUBSPECIES);
        ranks2.put("var", VARIETY);
        ranks2.put("v", VARIETY);
        ranks2.put("subvar", SUBVARIETY);
        ranks2.put("subv", SUBVARIETY);
        ranks2.put("sv", SUBVARIETY);
        ranks2.put("pv", PATHOVAR);
        ranks2.put("forma", FORM);
        ranks2.put("form", FORM);
        ranks2.put("fo", FORM);
        ranks2.put("f", FORM);
        ranks2.put("subform", SUBFORM);
        ranks2.put("subf", SUBFORM);
        ranks2.put("sf", SUBFORM);
        ranks2.put("cv", CULTIVAR);
        ranks2.put("hort", CULTIVAR);
        ranks2.put("m", INFRASUBSPECIFIC_NAME);
        ranks2.put("morph", INFRASUBSPECIFIC_NAME);
        ranks2.put("nat", INFRASUBSPECIFIC_NAME);
        ranks2.put("ab", INFRASUBSPECIFIC_NAME);
        ranks2.put("aberration", INFRASUBSPECIFIC_NAME);
        ranks2.put("\\*+", INFRASPECIFIC_NAME);
        RANK_MARKER_MAP_INFRASPECIFIC = ImmutableMap.copyOf(ranks2);
        ranks2 = new HashMap();
        ranks2.putAll(RANK_MARKER_MAP_SUPRAGENERIC);
        ranks2.putAll(RANK_MARKER_MAP_INFRAGENERIC);
        ranks2.putAll(RANK_MARKER_MAP_INFRASPECIFIC);
        ranks2.put("subser", SUBSERIES);
        RANK_MARKER_MAP = ImmutableMap.copyOf(ranks2);
    }
}

