/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util;

import com.google.common.base.Strings;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.api.vocabulary.EndpointType;
import org.gbif.api.vocabulary.IdentifierType;
import org.gbif.api.vocabulary.TechnicalInstallationType;

public final class VocabularyUtils {
    public static ContactType parseContactType(String type) {
        return VocabularyUtils.lookupEnum(type, ContactType.class);
    }

    public static EndpointType parseEndpointType(String type) {
        return VocabularyUtils.lookupEnum(type, EndpointType.class);
    }

    public static IdentifierType parseIdentifierType(String type) {
        return VocabularyUtils.lookupEnum(type, IdentifierType.class);
    }

    public static TechnicalInstallationType parseTechnicalInstallationType(String type) {
        return VocabularyUtils.lookupEnum(type, TechnicalInstallationType.class);
    }

    public static <T extends Enum<?>> T lookupEnum(String name, Class<T> vocab) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        String normedType = name.toUpperCase().replaceAll("[. _-]", "");
        Enum[] values = (Enum[])vocab.getEnumConstants();
        if (values != null) {
            for (Enum val : values) {
                String normedVal = val.name().toUpperCase().replaceAll("[. _-]", "");
                if (!normedType.equals(normedVal)) continue;
                return (T)val;
            }
        }
        throw new IllegalArgumentException("Cannot parse " + name + " into a known " + vocab.getSimpleName());
    }

    public static Class<? extends Enum<?>> lookupVocabulary(String fullyQualifiedClassName) {
        if (!Strings.isNullOrEmpty((String)fullyQualifiedClassName)) {
            try {
                Class<?> cl = Class.forName(fullyQualifiedClassName);
                if (Enum.class.isAssignableFrom(cl)) {
                    return cl;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to lookup the vocabulary: " + fullyQualifiedClassName, e);
            }
        }
        return null;
    }

    private VocabularyUtils() {
    }
}

