/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.jackson;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;

public class TermMapListDeserializer
extends JsonDeserializer<List<Map<Term, String>>> {
    private TermFactory termFactory = TermFactory.instance();

    public List<Map<Term, String>> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            JsonDeserializer deserializer = ctxt.getDeserializerProvider().findTypedValueDeserializer(ctxt.getConfig(), ctxt.constructType(List.class), null);
            List verbatimTerms = (List)deserializer.deserialize(jp, ctxt);
            ArrayList interpretedTerms = Lists.newArrayList();
            for (Map verbExtension : verbatimTerms) {
                HashMap extension = new HashMap();
                for (Map.Entry entry : verbExtension.entrySet()) {
                    Term term = this.termFactory.findTerm((String)entry.getKey());
                    if (term == null && ctxt.getConfig().isEnabled(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES)) {
                        throw ctxt.mappingException("Term not found " + (String)entry.getKey());
                    }
                    extension.put(term, entry.getValue());
                }
                interpretedTerms.add(extension);
            }
            return interpretedTerms;
        }
        throw ctxt.mappingException("Expected JSON String");
    }
}

