/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops.pool;

import java.net.SocketException;
import java.util.Random;
import java.util.Set;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.thrift.TException;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.Connection;
import org.scale7.cassandra.pelops.OperandPolicy;
import org.scale7.cassandra.pelops.exceptions.NoConnectionsAvailableException;
import org.scale7.cassandra.pelops.pool.IThriftPool;
import org.scale7.cassandra.pelops.pool.ThriftPoolBase;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class DebuggingPool
extends ThriftPoolBase {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(DebuggingPool.class);
    private Cluster cluster;
    private String keyspace;
    private OperandPolicy generalPolicy;
    private Random random;
    PooledConnection connection = null;

    public DebuggingPool(Cluster cluster, String keyspace, OperandPolicy generalPolicy) {
        this.cluster = cluster;
        this.keyspace = keyspace;
        this.generalPolicy = generalPolicy;
        this.random = new Random();
    }

    @Override
    public IThriftPool.IPooledConnection getConnection() throws NoConnectionsAvailableException {
        Cluster.Node[] nodes = this.cluster.getNodes();
        int index = nodes.length == 1 ? 0 : this.random.nextInt(nodes.length);
        logger.debug("Using node '{}'", (Object)nodes[index]);
        if (this.connection != null && this.connection.isOpen()) {
            return this.connection;
        }
        try {
            this.connection = new PooledConnection(nodes[index], this.keyspace);
            this.connection.open();
        }
        catch (Exception e) {
            throw new NoConnectionsAvailableException();
        }
        return this.connection;
    }

    @Override
    public IThriftPool.IPooledConnection getConnectionExcept(Set<String> avoidNodes) throws NoConnectionsAvailableException {
        return this.getConnection();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public OperandPolicy getOperandPolicy() {
        return this.generalPolicy;
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public class PooledConnection
    extends Connection
    implements IThriftPool.IPooledConnection {
        public PooledConnection(Cluster.Node node, String keyspace) throws SocketException, TException, InvalidRequestException {
            super(node, keyspace);
        }

        @Override
        public void release() {
        }

        @Override
        public void corrupted() {
            this.close();
        }
    }
}

