/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.spatial;

import java.util.Collection;
import java.util.List;
import org.geotools.metadata.iso.spatial.GridSpatialRepresentationImpl;
import org.opengis.geometry.primitive.Point;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeorectifiedImpl
extends GridSpatialRepresentationImpl
implements Georectified {
    private static final long serialVersionUID = 5875851898471237138L;
    private boolean checkPointAvailable;
    private InternationalString checkPointDescription;
    private List<Point> cornerPoints;
    private Point centerPoint;
    private PixelOrientation pointInPixel;
    private InternationalString transformationDimensionDescription;
    private Collection<InternationalString> transformationDimensionMapping;

    public GeorectifiedImpl() {
    }

    public GeorectifiedImpl(Georectified source) {
        super(source);
    }

    public GeorectifiedImpl(int numberOfDimensions, List<? extends Dimension> axisDimensionsProperties, CellGeometry cellGeometry, boolean transformationParameterAvailable, boolean checkPointAvailable, List<? extends Point> cornerPoints, PixelOrientation pointInPixel) {
        super(numberOfDimensions, axisDimensionsProperties, cellGeometry, transformationParameterAvailable);
        this.setCheckPointAvailable(checkPointAvailable);
        this.setCornerPoints(cornerPoints);
        this.setPointInPixel(pointInPixel);
    }

    @Override
    public boolean isCheckPointAvailable() {
        return this.checkPointAvailable;
    }

    public synchronized void setCheckPointAvailable(boolean newValue) {
        this.checkWritePermission();
        this.checkPointAvailable = newValue;
    }

    @Override
    public InternationalString getCheckPointDescription() {
        return this.checkPointDescription;
    }

    public synchronized void setCheckPointDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.checkPointDescription = newValue;
    }

    public synchronized List<Point> getCornerPoints() {
        this.cornerPoints = this.nonNullList(this.cornerPoints, Point.class);
        return this.cornerPoints;
    }

    public synchronized void setCornerPoints(List<? extends Point> newValues) {
        this.cornerPoints = this.copyList(newValues, this.cornerPoints, Point.class);
    }

    @Override
    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public synchronized void setCenterPoint(Point newValue) {
        this.checkWritePermission();
        this.centerPoint = newValue;
    }

    @Override
    public PixelOrientation getPointInPixel() {
        return this.pointInPixel;
    }

    public synchronized void setPointInPixel(PixelOrientation newValue) {
        this.checkWritePermission();
        this.pointInPixel = newValue;
    }

    @Override
    public InternationalString getTransformationDimensionDescription() {
        return this.transformationDimensionDescription;
    }

    public synchronized void setTransformationDimensionDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.transformationDimensionDescription = newValue;
    }

    public synchronized Collection<InternationalString> getTransformationDimensionMapping() {
        this.transformationDimensionMapping = this.nonNullCollection(this.transformationDimensionMapping, InternationalString.class);
        return this.transformationDimensionMapping;
    }

    public synchronized void setTransformationDimensionMapping(Collection<? extends InternationalString> newValues) {
        this.transformationDimensionMapping = this.copyCollection(newValues, this.transformationDimensionMapping, InternationalString.class);
    }
}

