/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.model;

import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.MatchType;
import au.org.ala.names.model.NameIndexField;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.SynonymType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;

public class NameSearchResult {
    private String id;
    private String lsid;
    private String cleanName;
    private boolean isHomonym;
    private String acceptedLsid;
    private String kingdom;
    private String left;
    private String right;
    private LinnaeanRankClassification rankClass;
    private RankType rank;
    private MatchType matchType;
    private SynonymType synonymType;

    public NameSearchResult(String id, String lsid, MatchType type) {
        this.id = id;
        this.lsid = StringUtils.trimToNull((String)lsid) == null ? id : StringUtils.trimToNull((String)lsid);
        this.matchType = type;
        this.isHomonym = false;
    }

    public NameSearchResult(Document doc, MatchType type) {
        this(doc.get(NameIndexField.ID.toString()), doc.get(NameIndexField.LSID.toString()), type);
        this.kingdom = doc.get(RankType.KINGDOM.getRank());
        try {
            this.rank = RankType.getForId(Integer.parseInt(doc.get(NameIndexField.RANK_ID.toString())));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.rankClass = new LinnaeanRankClassification(doc.get(RankType.KINGDOM.getRank()), doc.get(RankType.PHYLUM.getRank()), doc.get(RankType.CLASS.getRank()), doc.get(RankType.ORDER.getRank()), doc.get(RankType.FAMILY.getRank()), doc.get(RankType.GENUS.getRank()), doc.get(NameIndexField.NAME.toString()));
        this.rankClass.setSpecies(doc.get(RankType.SPECIES.getRank()));
        this.rankClass.setKid(doc.get("kid"));
        this.rankClass.setPid(doc.get("pid"));
        this.rankClass.setCid(doc.get("cid"));
        this.rankClass.setOid(doc.get("oid"));
        this.rankClass.setFid(doc.get("fid"));
        this.rankClass.setGid(doc.get("gid"));
        this.rankClass.setSid(doc.get("sid"));
        this.rankClass.setAuthorship(doc.get(NameIndexField.AUTHOR.toString()));
        this.left = doc.get("left");
        this.right = doc.get("right");
        this.synonymType = SynonymType.getTypeFor(doc.get(NameIndexField.SYNONYM_TYPE.toString()));
        String syn = doc.get(NameIndexField.ACCEPTED.toString());
        if (syn != null) {
            this.acceptedLsid = syn;
        }
    }

    public SynonymType getSynonymType() {
        return this.synonymType;
    }

    public LinnaeanRankClassification getRankClassification() {
        return this.rankClass;
    }

    @Deprecated
    public String getKingdom() {
        return this.kingdom;
    }

    public String getLsid() {
        return this.lsid;
    }

    public String getId() {
        return this.id;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchType type) {
        this.matchType = type;
    }

    @Deprecated
    public String getCleanName() {
        return this.cleanName;
    }

    @Deprecated
    public void setCleanName(String name) {
        this.cleanName = name;
    }

    @Deprecated
    public boolean hasBeenCleaned() {
        return this.cleanName != null;
    }

    public boolean isHomonym() {
        return this.isHomonym;
    }

    public boolean isSynonym() {
        return this.acceptedLsid != null;
    }

    @Deprecated
    public String getSynonymLsid() {
        return this.getAcceptedLsid();
    }

    public String getAcceptedLsid() {
        return this.acceptedLsid;
    }

    public String toString() {
        return "Match: " + (Object)((Object)this.matchType) + " id: " + this.id + " lsid: " + this.lsid + " classification: " + this.rankClass + " synonym: " + this.acceptedLsid + " rank: " + (Object)((Object)this.rank);
    }

    public Map<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("ID", this.id);
        map.put("GUID", this.lsid);
        map.put("Classification", this.rankClass.toCSV(','));
        map.put("Scientific name", this.rankClass.getScientificName());
        map.put("Authorship", this.rankClass.getAuthorship());
        map.put("Rank", this.rank.toString());
        map.put("Synonym", this.acceptedLsid);
        map.put("Match type", this.matchType.toString());
        return map;
    }

    public RankType getRank() {
        return this.rank;
    }

    public void setRank(RankType rank) {
        this.rank = rank;
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }
}

