/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.concurrent.TimeUnit;
import org.apache.solr.common.SolrException;

public class RetryUtil {
    public static void retryOnThrowable(Class clazz, long timeoutms, long intervalms, RetryCmd cmd) throws Throwable {
        long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutms, TimeUnit.MILLISECONDS);
        while (true) {
            try {
                cmd.execute();
            }
            catch (Throwable t) {
                if (clazz.isInstance(t) && System.nanoTime() < timeout) {
                    Thread.sleep(intervalms);
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, t);
            }
            break;
        }
    }

    public static interface RetryCmd {
        public void execute() throws Throwable;
    }
}

