/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.voc;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.gbif.ecat.voc.Rank;

public class RankComparator
implements Comparator<Rank> {
    public static final int LOWER = -1;
    public static final int EQUAL = 0;
    public static final int HIGHER = 1;
    private static final Set<Rank> uncomparable;

    @Override
    public int compare(Rank o1, Rank o2) {
        Rank other;
        if (o1 == o2) {
            return 0;
        }
        if (uncomparable.contains(o1) || uncomparable.contains(o2)) {
            throw new IllegalArgumentException("Uncomparable ranks " + o1 + " and " + o2);
        }
        if (Rank.InfragenericName == o1 || Rank.InfragenericName == o2) {
            other = o1;
            if (Rank.InfragenericName == o1) {
                other = o2;
            }
            if (other.compareTo(Rank.GENUS) == -1 && other.compareTo(Rank.SPECIES) == 1) {
                throw new IllegalArgumentException("Cannot compare InfragenericName with other infrageneric ranks");
            }
        }
        if (Rank.InfraspecificName == o1 || Rank.InfraspecificName == o2) {
            other = o1;
            if (Rank.InfraspecificName == o1) {
                other = o2;
            }
            if (other.compareTo(Rank.SPECIES) == -1) {
                throw new IllegalArgumentException("Cannot compare SubspecificName with other subspecific ranks");
            }
        }
        if (Rank.InfrasubspecificName == o1 || Rank.InfrasubspecificName == o2) {
            other = o1;
            if (Rank.InfrasubspecificName == o1) {
                other = o2;
            }
            if (other.compareTo(Rank.SUBSPECIES) == -1) {
                throw new IllegalArgumentException("Cannot compare InfrasubspecificName with other ranks below subspecies");
            }
        }
        int x = o2.compareTo(o1);
        return x / Math.abs(x);
    }

    static {
        HashSet<Rank> ranks = new HashSet<Rank>();
        ranks.add(Rank.Unranked);
        ranks.add(Rank.Informal);
        uncomparable = ranks;
    }
}

