/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.validation;

import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.model.SensitivityInstance;
import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.util.GeneralisedLocation;
import au.org.ala.sds.util.GeneralisedLocationFactory;
import au.org.ala.sds.util.ValidationUtils;
import au.org.ala.sds.validation.FactCollection;
import au.org.ala.sds.validation.ReportFactory;
import au.org.ala.sds.validation.ValidationOutcome;
import au.org.ala.sds.validation.ValidationReport;
import au.org.ala.sds.validation.ValidationService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConservationService
implements ValidationService {
    private static final List<String> BIRDS_AUSTRALIA = Arrays.asList("dr359", "dr570", "dr571");
    private ReportFactory reportFactory;
    private final SensitiveTaxon taxon;

    public ConservationService(SensitiveTaxon taxon, ReportFactory reportFactory) {
        this.reportFactory = reportFactory;
        this.taxon = taxon;
    }

    @Override
    public ValidationOutcome validate(Map<String, String> biocacheData) {
        FactCollection facts = new FactCollection(biocacheData);
        ValidationReport report = this.reportFactory.createValidationReport(this.taxon);
        if (!ValidationUtils.validateLocationCoords(facts, report)) {
            return new ValidationOutcome(report, false);
        }
        if (!ValidationUtils.validateLocation(facts, report)) {
            return new ValidationOutcome(report, false);
        }
        String latitude = facts.get("decimalLatitude");
        String longitude = facts.get("decimalLongitude");
        List<SensitivityZone> zones = SensitivityZone.getListFromString(facts.get("zone"));
        List<SensitivityInstance> instances = this.taxon.getInstancesForZones(zones);
        if (facts.get("dataResourceUid") == null || !BIRDS_AUSTRALIA.contains(facts.get("dataResourceUid"))) {
            SensitivityInstance.removeInstance(instances, "Birds Australia");
        }
        GeneralisedLocation gl = GeneralisedLocationFactory.getGeneralisedLocation(latitude, longitude, instances, zones);
        ValidationOutcome outcome = new ValidationOutcome(report);
        HashMap<String, Object> results = new HashMap<String, Object>();
        HashMap<String, String> originalSensitiveValues = new HashMap<String, String>();
        if (gl.isSensitive()) {
            StringBuilder extra = new StringBuilder();
            for (SensitivityInstance si : gl.getSensitivityInstances()) {
                if (extra.length() > 0) {
                    extra.append("\t");
                } else {
                    extra.append("\n");
                }
                extra.append("Sensitive in ").append(si.getZone()).append(" [").append(si.getCategory().getValue()).append(", ").append(si.getAuthority()).append("]");
            }
            String extraDesc = extra.toString();
            outcome.setSensitive(true);
            results.put("decimalLatitude", gl.getGeneralisedLatitude());
            results.put("decimalLongitude", gl.getGeneralisedLongitude());
            originalSensitiveValues.put("decimalLatitude", gl.getOriginalLatitude());
            originalSensitiveValues.put("decimalLongitude", gl.getOriginalLongitude());
            results.put("generalisationInMetres", gl.getGeneralisationInMetres());
            results.put("dataGeneralizations", gl.getDescription() + ". " + extraDesc);
            this.emptyValueIfNecessary("locationRemarks", biocacheData, originalSensitiveValues, results);
            this.emptyValueIfNecessary("verbatimLatitude", biocacheData, originalSensitiveValues, results);
            this.emptyValueIfNecessary("verbatimLongitude", biocacheData, originalSensitiveValues, results);
            this.emptyValueIfNecessary("locality", biocacheData, originalSensitiveValues, results);
            this.emptyValueIfNecessary("verbatimLocality", biocacheData, originalSensitiveValues, results);
            this.emptyValueIfNecessary("verbatimCoordinates", biocacheData, originalSensitiveValues, results);
            this.emptyValueIfNecessary("footprintWKT", biocacheData, originalSensitiveValues, results);
            if (gl.getGeneralisationInMetres().equals("") && gl.getGeneralisedLatitude() != null && gl.getGeneralisedLatitude().equals("")) {
                results.put("informationWithheld", "Location co-ordinates have been withheld in accordance with " + facts.get("stateProvince") + " sensitive species policy");
            }
        } else {
            outcome.setSensitive(false);
        }
        if (facts.get("dataResourceUid") != null && BIRDS_AUSTRALIA.contains(facts.get("dataResourceUid"))) {
            this.emptyValueIfNecessary("eventID", biocacheData, originalSensitiveValues, results);
            this.emptyValueIfNecessary("day", biocacheData, originalSensitiveValues, results);
            this.emptyValueIfNecessary("eventDate", biocacheData, originalSensitiveValues, results);
            results.put("informationWithheld", "The eventID and day information has been withheld in accordance with Birds Australia data policy");
        }
        results.put("originalSensitiveValues", originalSensitiveValues);
        outcome.setResult(results);
        outcome.setValid(true);
        outcome.setLoadable(true);
        return outcome;
    }

    private void emptyValueIfNecessary(String field, Map<String, String> facts, Map<String, String> originalSensitiveValues, Map<String, Object> results) {
        if (facts.containsKey(field)) {
            results.put(field, "");
            originalSensitiveValues.put(field, facts.get(field));
        }
    }

    public void setReportFactory(ReportFactory reportFactory) {
        this.reportFactory = reportFactory;
    }
}

