/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.model;

import au.org.ala.sds.dao.SensitivityZonesXmlDao;
import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.util.Configuration;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Logger;

public class SensitivityZoneFactory {
    protected static final Logger logger = Logger.getLogger(SensitivityZoneFactory.class);
    private static final String ZONES_RESOURCE = "sensitivity-zones.xml";
    private static Map<String, SensitivityZone> zones;

    public static SensitivityZone getZone(String key) {
        if (zones == null) {
            SensitivityZoneFactory.initZones();
        }
        return zones.get(key);
    }

    public static SensitivityZone getZoneByName(String name) {
        if (zones == null) {
            SensitivityZoneFactory.initZones();
        }
        for (SensitivityZone sz : zones.values()) {
            if (!sz.getName().equalsIgnoreCase(name)) continue;
            return sz;
        }
        return null;
    }

    private static void initZones() {
        URL url = null;
        InputStream is = null;
        try {
            url = new URL(Configuration.getInstance().getZoneUrl());
            is = url.openStream();
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred getting zones list from " + url), (Throwable)e);
            is = SensitivityZoneFactory.class.getClassLoader().getResourceAsStream(ZONES_RESOURCE);
            if (is == null) {
                logger.error((Object)"Unable to read sensitivity-zones.xml from jar file");
            }
            logger.info((Object)"Reading bundled resource sensitivity-zones.xml from jar file");
        }
        SensitivityZonesXmlDao dao = new SensitivityZonesXmlDao(is);
        try {
            zones = dao.getMap();
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred parsing zones list from " + is), (Throwable)e);
        }
    }
}

