/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.model;

import au.org.ala.sds.model.SensitivityCategory;
import au.org.ala.sds.model.SensitivityZone;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SensitivityInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BIRDS_AUSTRALIA_INSTANCE = "Birds Australia";
    private final SensitivityCategory category;
    private final String authority;
    private final String dataResourceId;
    private final SensitivityZone zone;
    private final String reason;
    private final String remarks;

    public SensitivityInstance(SensitivityCategory category, String authority, String dataResourceId, SensitivityZone zone, String reason, String remarks) {
        this.category = category;
        this.authority = authority;
        this.dataResourceId = dataResourceId;
        this.zone = zone;
        this.reason = reason;
        this.remarks = remarks;
    }

    public SensitivityCategory getCategory() {
        return this.category;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getDataResourceId() {
        return this.dataResourceId;
    }

    public SensitivityZone getZone() {
        return this.zone;
    }

    public String getReason() {
        return this.reason;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public static void removeInstance(List<SensitivityInstance> instances, String authority) {
        ArrayList<SensitivityInstance> authInstances = new ArrayList<SensitivityInstance>();
        for (SensitivityInstance instance : instances) {
            if (!instance.authority.equalsIgnoreCase(authority)) continue;
            authInstances.add(instance);
        }
        for (SensitivityInstance authInstance : authInstances) {
            instances.remove(authInstance);
        }
    }

    public static void removeAllButInstance(List<SensitivityInstance> instances, String authority) {
        ArrayList<SensitivityInstance> notAuthInstances = new ArrayList<SensitivityInstance>();
        for (SensitivityInstance instance : instances) {
            if (instance.authority.equalsIgnoreCase(authority)) continue;
            notAuthInstances.add(instance);
        }
        for (SensitivityInstance authInstance : notAuthInstances) {
            instances.remove(authInstance);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SensitivityInstance other = (SensitivityInstance)obj;
        return this.category.equals(other.category) && this.authority.equalsIgnoreCase(other.authority) && this.dataResourceId.equalsIgnoreCase(other.dataResourceId) && this.zone.equals(other.zone);
    }

    public String toString() {
        return new ToStringBuilder((Object)this.getClass().getName()).append("category", (Object)this.category).append("zone", (Object)this.zone).append("authority", (Object)this.authority).append("dataResourceId", (Object)this.dataResourceId).append("reason", (Object)this.reason).append("remarks", (Object)this.remarks).toString();
    }

    public String toJson() {
        StringBuilder json = new StringBuilder("{");
        json.append("\"category\":" + this.category.toJson() + ",");
        json.append("\"zone\":" + this.zone.toJson() + ",");
        json.append("\"authority\":\"" + this.authority + "\",");
        json.append("\"dataResourceId\":\"" + this.dataResourceId + "\",");
        if (this.reason != null) {
            json.append("\"reason\":\"" + this.reason + "\",");
        }
        if (this.remarks != null) {
            json.append("\"remarks\":\"" + this.remarks + "\",");
        }
        json.setLength(json.length() - 1);
        json.append("}");
        return json.toString();
    }
}

