/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.json.simple.parser.ParseException;

public class TracingHandler
implements InvocationHandler {
    int indent = 0;
    Object delegate;

    public TracingHandler(Object delegate) {
        this.delegate = delegate;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("startObject".equals(method.getName())) {
            this.startObject();
        } else if ("endObject".equals(method.getName())) {
            this.endObject();
        } else if ("startObjectEntry".equals(method.getName())) {
            this.startObjectEntry((String)args[0]);
        } else if ("endObjectEntry".equals(method.getName())) {
            this.endObjectEntry();
        } else if ("startArray".equals(method.getName())) {
            this.startArray();
        } else if ("endArray".equals(method.getName())) {
            this.endArray();
        } else if ("primitive".equals(method.getName())) {
            this.primitive(args[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName());
        if (args != null && args.length > 0) {
            sb.append("[");
            for (Object arg : args) {
                sb.append(arg).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("]");
        }
        return method.invoke(this.delegate, args);
    }

    void startJSON() throws ParseException, IOException {
    }

    void endJSON() throws ParseException, IOException {
    }

    boolean startObject() throws ParseException, IOException {
        System.out.println("{");
        ++this.indent;
        return true;
    }

    boolean endObject() throws ParseException, IOException {
        --this.indent;
        this.indent();
        System.out.print("}");
        return true;
    }

    boolean startObjectEntry(String key) throws ParseException, IOException {
        this.indent();
        System.out.print(key + ": ");
        return true;
    }

    boolean endObjectEntry() throws ParseException, IOException {
        System.out.println(",");
        return true;
    }

    boolean startArray() throws ParseException, IOException {
        System.out.print("[");
        return true;
    }

    boolean endArray() throws ParseException, IOException {
        System.out.print("]");
        return true;
    }

    boolean primitive(Object value) throws ParseException, IOException {
        System.out.print(value);
        return true;
    }

    void indent() {
        for (int i = 0; i < this.indent; ++i) {
            System.out.print("  ");
        }
    }
}

