/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.photoshop.PhotoshopDirectory;

public class PhotoshopReader
implements MetadataReader {
    @Override
    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata) {
        int n;
        PhotoshopDirectory photoshopDirectory = metadata.getOrCreateDirectory(PhotoshopDirectory.class);
        BufferReader bufferReader = new BufferReader(byArray);
        int n2 = n = new String(byArray, 0, 13).equals("Photoshop 3.0") ? 14 : 0;
        while (n < byArray.length) {
            try {
                int n3 = bufferReader.getUInt16(n += 4);
                int n4 = bufferReader.getUInt16(n += 2);
                if (n4 < 0 || n4 + (n += 2) > byArray.length) {
                    return;
                }
                if ((n += n4) % 2 != 0) {
                    ++n;
                }
                int n5 = bufferReader.getInt32(n);
                byte[] byArray2 = bufferReader.getBytes(n += 4, n5);
                if ((n += n5) % 2 != 0) {
                    ++n;
                }
                photoshopDirectory.setByteArray(n3, byArray2);
                if (n3 == 1028) {
                    new IptcReader().extract(byArray2, metadata);
                }
                if (n3 < 4000 || n3 > 4999) continue;
                PhotoshopDirectory._tagNameMap.put(n3, String.format("Plug-in %d Data", n3 - 4000 + 1));
            }
            catch (BufferBoundsException bufferBoundsException) {
                photoshopDirectory.addError(bufferBoundsException.getMessage());
                return;
            }
        }
    }
}

