/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.adobe.AdobeJpegReader;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jfif.JfifReader;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegDirectory;
import com.drew.metadata.jpeg.JpegReader;
import com.drew.metadata.photoshop.PhotoshopReader;
import com.drew.metadata.xmp.XmpReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class JpegMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws JpegProcessingException {
        return JpegMetadataReader.readMetadata(inputStream, true);
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream, boolean bl) throws JpegProcessingException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(inputStream, bl);
        return JpegMetadataReader.extractMetadataFromJpegSegmentReader(jpegSegmentReader.getSegmentData());
    }

    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws JpegProcessingException, IOException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        return JpegMetadataReader.extractMetadataFromJpegSegmentReader(jpegSegmentReader.getSegmentData());
    }

    @NotNull
    public static Metadata extractMetadataFromJpegSegmentReader(@NotNull JpegSegmentData jpegSegmentData) {
        byte[] byArray;
        Metadata metadata = new Metadata();
        for (int n = 0; n < 16; n = (int)((byte)(n + 1))) {
            Iterator<byte[]> iterator;
            if (n == 4 || n == 12 || (iterator = (Iterator<byte[]>)jpegSegmentData.getSegment((byte)(-64 + n))) == null) continue;
            Object object = metadata.getOrCreateDirectory(JpegDirectory.class);
            object.setInt(-3, n);
            new JpegReader().extract((byte[])iterator, metadata);
            break;
        }
        if ((byArray = jpegSegmentData.getSegment((byte)-2)) != null) {
            new JpegCommentReader().extract(byArray, metadata);
        }
        for (Object object : jpegSegmentData.getSegments((byte)-32)) {
            if (((byte[])object).length <= 3 || !new String((byte[])object, 0, 4).equals("JFIF")) continue;
            new JfifReader().extract((byte[])object, metadata);
        }
        for (Object object : jpegSegmentData.getSegments((byte)-31)) {
            if (((byte[])object).length > 3 && "EXIF".equalsIgnoreCase(new String((byte[])object, 0, 4))) {
                new ExifReader().extract((byte[])object, metadata);
            }
            if (((byte[])object).length <= 27 || !"http://ns.adobe.com/xap/1.0/".equalsIgnoreCase(new String((byte[])object, 0, 28))) continue;
            new XmpReader().extract((byte[])object, metadata);
        }
        for (Object object : jpegSegmentData.getSegments((byte)-30)) {
            if (((byte[])object).length <= 10 || !new String((byte[])object, 0, 11).equalsIgnoreCase("ICC_PROFILE")) continue;
            byte[] byArray2 = new byte[((byte[])object).length - 14];
            System.arraycopy(object, 14, byArray2, 0, ((byte[])object).length - 14);
            new IccReader().extract(byArray2, metadata);
        }
        for (Object object : jpegSegmentData.getSegments((byte)-19)) {
            if (((byte[])object).length > 12 && "Photoshop 3.0".compareTo(new String((byte[])object, 0, 13)) == 0) {
                new PhotoshopReader().extract((byte[])object, metadata);
                continue;
            }
            new IptcReader().extract((byte[])object, metadata);
        }
        for (Object object : jpegSegmentData.getSegments((byte)-18)) {
            if (((byte[])object).length != 12 || "Adobe".compareTo(new String((byte[])object, 0, 5)) != 0) continue;
            new AdobeJpegReader().extract((byte[])object, metadata);
        }
        return metadata;
    }

    private JpegMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }
}

