/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Processed$;
import au.org.ala.biocache.processor.RecordProcessor;
import au.org.ala.biocache.util.OptionParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class ProcessSingleRecord$
implements Tool {
    public static final ProcessSingleRecord$ MODULE$;
    private final Logger logger;

    static {
        new ProcessSingleRecord$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public String cmd() {
        return "process-single";
    }

    @Override
    public String desc() {
        return "Process a single record";
    }

    @Override
    public void main(String[] args) {
        ObjectRef uuid = new ObjectRef((Object)"");
        OptionParser parser = new OptionParser(uuid){
            {
                this.arg("uuid", "record UUID", (Function1<String, BoxedUnit>)new Serializable(this, uuid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef uuid$1;

                    public final void apply(String v) {
                        this.uuid$1.elem = v;
                    }
                    {
                        this.uuid$1 = uuid$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            this.processRecord((String)uuid.elem);
        }
    }

    public void processRecord(String uuid) {
        RecordProcessor processor = new RecordProcessor();
        Option<FullRecord[]> records = Config$.MODULE$.occurrenceDAO().getAllVersionsByRowKey(uuid, Config$.MODULE$.occurrenceDAO().getAllVersionsByRowKey$default$2());
        if (records.isEmpty()) {
            records = Config$.MODULE$.occurrenceDAO().getAllVersionsByUuid(uuid, Config$.MODULE$.occurrenceDAO().getAllVersionsByUuid$default$2());
        }
        if (records.isEmpty()) {
            this.logger().info("UUID or row key not stored....");
        } else {
            this.logger().info("Processing record.....");
            processor.processRecord(((FullRecord[])records.get())[0], ((FullRecord[])records.get())[1]);
            Option<FullRecord> processedRecord = Config$.MODULE$.occurrenceDAO().getByRowKey(((FullRecord[])records.get())[1].rowKey(), Processed$.MODULE$, Config$.MODULE$.occurrenceDAO().getByRowKey$default$3());
            ObjectMapper objectMapper = new ObjectMapper();
            if (processedRecord.isEmpty()) {
                this.logger().info("Record not found");
            } else {
                this.logger().info(objectMapper.writeValueAsString(processedRecord.get()));
            }
        }
        Predef$.MODULE$.print((Object)"\n\nSupply a Row Key for a record: ");
    }

    public String readStdIn() {
        return new BufferedReader(new InputStreamReader(System.in)).readLine().trim();
    }

    private ProcessSingleRecord$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"ProcessSingleRecord");
    }
}

