/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class ExportByFacetQuery$
implements Tool {
    public static final ExportByFacetQuery$ MODULE$;

    static {
        new ExportByFacetQuery$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "export-facet-query";
    }

    @Override
    public String desc() {
        return "Exports records based a file of inputs and specified field to facet query";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void main(String[] args) {
        ObjectRef filterQueries;
        ObjectRef fieldsToExport;
        ObjectRef recordOutputFile;
        ObjectRef facetField = new ObjectRef((Object)"species_guid");
        ObjectRef facetInputFile = new ObjectRef((Object)new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/facet-output-").append((Object)((String)facetField.elem)).append((Object)".txt").toString());
        OptionParser parser = new OptionParser(facetField, facetInputFile, recordOutputFile = new ObjectRef((Object)new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/record-output-").append((Object)((String)facetField.elem)).append((Object)".txt").toString()), fieldsToExport = new ObjectRef((Object)((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))), filterQueries = new ObjectRef((Object)((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))))){
            {
                this.arg("facet-field", "The field to facet on", (Function1<String, BoxedUnit>)new Serializable(this, facetField$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef facetField$1;

                    public final void apply(String v) {
                        this.facetField$1.elem = v;
                    }
                    {
                        this.facetField$1 = facetField$1;
                    }
                });
                this.arg("facet-input-file", "The field to facet on", (Function1<String, BoxedUnit>)new Serializable(this, facetInputFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef facetInputFile$1;

                    public final void apply(String v) {
                        this.facetInputFile$1.elem = v;
                    }
                    {
                        this.facetInputFile$1 = facetInputFile$1;
                    }
                });
                this.arg("record-output-file", "The file to dump records to", (Function1<String, BoxedUnit>)new Serializable(this, recordOutputFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef recordOutputFile$1;

                    public final void apply(String v) {
                        this.recordOutputFile$1.elem = v;
                    }
                    {
                        this.recordOutputFile$1 = recordOutputFile$1;
                    }
                });
                this.arg("list of fields", "Space separated list of fields to export", (Function1<String, BoxedUnit>)new Serializable(this, fieldsToExport$2){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef fieldsToExport$2;

                    public final void apply(String v) {
                        this.fieldsToExport$2.elem = (String[])Predef$.MODULE$.refArrayOps((Object[])v.split(" ")).toArray(ClassTag$.MODULE$.apply(String.class));
                    }
                    {
                        this.fieldsToExport$2 = fieldsToExport$2;
                    }
                });
                this.opt("fq", "filter query", "An additional filter query to use when exporting", (Function1<String, BoxedUnit>)new Serializable(this, filterQueries$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef filterQueries$1;

                    public final void apply(String v) {
                        this.filterQueries$1.elem = v.split("&");
                    }
                    {
                        this.filterQueries$1 = filterQueries$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            IntRef counter = new IntRef(0);
            CSVReader csvReader = new CSVReader((Reader)new FileReader((String)facetInputFile.elem), '\t');
            FileWriter fileWriter = new FileWriter(new File((String)recordOutputFile.elem));
            String taxonID = this.getTaxonID(csvReader);
            while (true) {
                void var9_9;
                String string;
                void var10_10;
                void var8_8;
                if (taxonID == null) {
                    Config$.MODULE$.indexDAO().shutdown();
                    fileWriter.flush();
                    fileWriter.close();
                    break;
                }
                Config$.MODULE$.indexDAO().pageOverIndex((Function1<Map<String, Object>, Object>)new Serializable(fieldsToExport, (IntRef)var8_8, (FileWriter)var10_10){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef fieldsToExport$2;
                    private final IntRef counter$1;
                    private final FileWriter fileWriter$2;

                    public final boolean apply(Map<String, Object> map) {
                        ++this.counter$1.elem;
                        if (this.counter$1.elem % 1000 == 0) {
                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Exported :").append((Object)BoxesRunTime.boxToInteger((int)this.counter$1.elem)).toString());
                            this.fileWriter$2.flush();
                        }
                        String[] outputLine = (String[])Predef$.MODULE$.refArrayOps((Object[])((String[])this.fieldsToExport$2.elem)).map((Function1)new Serializable(this, map){
                            public static final long serialVersionUID = 0L;
                            private final Map map$1;

                            public final String apply(String f) {
                                return ExportByFacetQuery$.MODULE$.getFromMap(this.map$1, f);
                            }
                            {
                                this.map$1 = map$1;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        this.fileWriter$2.write(Predef$.MODULE$.refArrayOps((Object[])outputLine).mkString("\t"));
                        this.fileWriter$2.write("\n");
                        return true;
                    }
                    {
                        this.fieldsToExport$2 = fieldsToExport$2;
                        this.counter$1 = counter$1;
                        this.fileWriter$2 = fileWriter$2;
                    }
                }, (String[])fieldsToExport.elem, new StringBuilder().append((Object)((String)facetField.elem)).append((Object)":\"").append((Object)string).append((Object)"\"").toString(), (String[])filterQueries.elem, Config$.MODULE$.indexDAO().pageOverIndex$default$5(), Config$.MODULE$.indexDAO().pageOverIndex$default$6(), Config$.MODULE$.indexDAO().pageOverIndex$default$7());
                string = this.getTaxonID((CSVReader)var9_9);
            }
        }
    }

    public void downloadSingleTaxonByStream(String query, String taxonID, String[] fieldsToExport, String facetField, String[] filterQueries, String[] sortFields, FileWriter fileWriter, Option<FileWriter> subspeciesWriter, Option<String[]> multivaluedFields) {
        String q = query == null ? new StringBuilder().append((Object)facetField).append((Object)":\"").append((Object)taxonID).append((Object)"\"").toString() : query;
        Config$.MODULE$.indexDAO().streamIndex((Function1<Map<String, Object>, Object>)new Serializable(fieldsToExport, fileWriter, subspeciesWriter){
            public static final long serialVersionUID = 0L;
            private final String[] fieldsToExport$1;
            private final FileWriter fileWriter$1;
            private final Option subspeciesWriter$1;

            public final boolean apply(Map<String, Object> map) {
                Object subspecies;
                String outputLine = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fieldsToExport$1).map((Function1)new Serializable(this, map){
                    public static final long serialVersionUID = 0L;
                    private final Map map$2;

                    public final String apply(String f) {
                        return ExportByFacetQuery$.MODULE$.getFromMap(this.map$2, f);
                    }
                    {
                        this.map$2 = map$2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\t");
                this.fileWriter$1.write(outputLine);
                this.fileWriter$1.write("\n");
                if (this.subspeciesWriter$1.isDefined() && (subspecies = map.get("subspecies_guid")) != null) {
                    ((Writer)this.subspeciesWriter$1.get()).write(outputLine);
                    ((Writer)this.subspeciesWriter$1.get()).write("\n");
                }
                return true;
            }
            {
                this.fieldsToExport$1 = fieldsToExport$1;
                this.fileWriter$1 = fileWriter$1;
                this.subspeciesWriter$1 = subspeciesWriter$1;
            }
        }, fieldsToExport, q, filterQueries, sortFields, multivaluedFields);
    }

    public void downloadSingleTaxon(String taxonID, String[] fieldsToExport, String facetField, String[] filterQueries, Option<String> sortField, Option<String> sortDir, FileWriter fileWriter, Option<String[]> multivaluedFields) {
        IntRef counter = new IntRef(0);
        Config$.MODULE$.indexDAO().pageOverIndex((Function1<Map<String, Object>, Object>)new Serializable(fieldsToExport, fileWriter, counter){
            public static final long serialVersionUID = 0L;
            private final String[] fieldsToExport$3;
            private final FileWriter fileWriter$3;
            private final IntRef counter$2;

            public final boolean apply(Map<String, Object> map) {
                ++this.counter$2.elem;
                if (this.counter$2.elem % 1000 == 0) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Exported :").append((Object)BoxesRunTime.boxToInteger((int)this.counter$2.elem)).toString());
                    this.fileWriter$3.flush();
                }
                String[] outputLine = (String[])Predef$.MODULE$.refArrayOps((Object[])this.fieldsToExport$3).map((Function1)new Serializable(this, map){
                    public static final long serialVersionUID = 0L;
                    private final Map map$3;

                    public final String apply(String f) {
                        return ExportByFacetQuery$.MODULE$.getFromMap(this.map$3, f);
                    }
                    {
                        this.map$3 = map$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                this.fileWriter$3.write(Predef$.MODULE$.refArrayOps((Object[])outputLine).mkString("\t"));
                this.fileWriter$3.write("\n");
                return true;
            }
            {
                this.fieldsToExport$3 = fieldsToExport$3;
                this.fileWriter$3 = fileWriter$3;
                this.counter$2 = counter$2;
            }
        }, fieldsToExport, new StringBuilder().append((Object)facetField).append((Object)":\"").append((Object)taxonID).append((Object)"\"").toString(), filterQueries, sortField, sortDir, multivaluedFields);
        fileWriter.flush();
    }

    public String downloadSingleTaxonByStream$default$1() {
        return null;
    }

    public Option<FileWriter> downloadSingleTaxonByStream$default$8() {
        return None$.MODULE$;
    }

    public Option<String[]> downloadSingleTaxonByStream$default$9() {
        return None$.MODULE$;
    }

    public Option<String> downloadSingleTaxon$default$5() {
        return None$.MODULE$;
    }

    public Option<String> downloadSingleTaxon$default$6() {
        return None$.MODULE$;
    }

    public Option<String[]> downloadSingleTaxon$default$8() {
        return None$.MODULE$;
    }

    public String getTaxonID(CSVReader csvReader) {
        String[] row = csvReader.readNext();
        return row != null && row.length > 0 ? (String)Predef$.MODULE$.refArrayOps((Object[])row).head() : null;
    }

    public String getFromMap(Map<String, Object> map, String key) {
        Object value = map.get(key);
        return value == null ? "" : value.toString();
    }

    private ExportByFacetQuery$() {
        MODULE$ = this;
        Tool$class.$init$(this);
    }
}

