/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.util;

import java.io.Serializable;

public class LayerFilter
implements Serializable {
    static final long serialVersionUID = -2733856402542621244L;
    String layername = "";
    double minimum_value = 0.0;
    double maximum_value = 0.0;

    public LayerFilter(String layername, double min, double max) {
        this.layername = layername;
        this.minimum_value = min;
        this.maximum_value = max;
    }

    public String getLayername() {
        return this.layername;
    }

    public double getMinimum_value() {
        return this.minimum_value;
    }

    public double getMaximum_value() {
        return this.maximum_value;
    }

    public boolean isValid(double value) {
        return !Double.isNaN(value) && value >= this.minimum_value && value <= this.maximum_value;
    }

    public static LayerFilter[] parseLayerFilters(String s) {
        if (s.toUpperCase().startsWith("ENVELOPE(")) {
            s = s.substring("ENVELOPE(".length(), s.length() - 1);
        }
        String[] terms = s.split(":");
        LayerFilter[] lf = new LayerFilter[terms.length];
        int i = 0;
        for (String t : terms) {
            System.out.println("parsing filter term: " + t);
            lf[i] = LayerFilter.parseLayerFilter(t);
            ++i;
        }
        return lf;
    }

    public static LayerFilter parseLayerFilter(String s) {
        if (s.toUpperCase().startsWith("ENVELOPE(")) {
            s = s.substring("ENVELOPE(".length(), s.length() - 1);
        }
        String[] tokens = s.split(",");
        return new LayerFilter(tokens[0], Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2]));
    }
}

