/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.ala.layers.client.Client;
import org.ala.layers.dao.FieldDAO;
import org.ala.layers.dao.LayerDAO;
import org.ala.layers.dao.LayerIntersectDAO;
import org.ala.layers.dao.ObjectDAO;
import org.ala.layers.dto.Field;
import org.ala.layers.dto.Layer;
import org.ala.layers.dto.Objects;
import org.ala.layers.intersect.Grid;
import org.ala.layers.intersect.IntersectConfig;
import org.ala.layers.util.Bil2diva;
import org.ala.layers.util.Diva2bil;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AnalysisLayerUtil {
    public static void main(String[] args) {
        System.out.println("prepare one grid file for analysis.\nargs[0] = source diva grid filename (without .gri or .grd)\nargs[1] = output diva grid filename (without .gri or .grd)\nargs[2] = resolution in decimal degrees, e.g. 0.01\nargs[3] = path to gdal\n\nprepare all grid files for analysis.\nargs[0] = 'all', prepare all layers for analysis\n\nprepare all shape or grid files for analysis.\nargs[0] = 'all', operate on all layers\nargs[1] = 'shapes' or 'grids' to operate on only grids or shapes\n\n");
        if (args == null || args.length == 0) {
            args = new String[]{"all", "grids"};
        }
        if (args.length == 1 && (args[0].equals("auto") || args[0].equals("all"))) {
            AnalysisLayerUtil.processShapeFiles();
            AnalysisLayerUtil.processGridFiles();
        } else if (args.length == 2 && (args[0].equals("auto") || args[0].equals("all"))) {
            if (args[1].equals("shapes")) {
                AnalysisLayerUtil.processShapeFiles();
            } else {
                AnalysisLayerUtil.processGridFiles();
            }
        } else if (args.length == 4) {
            if (AnalysisLayerUtil.diva2Analysis(args[0], args[1], Double.parseDouble(args[2]), args[3], true)) {
                System.out.println("successful");
            } else {
                System.out.println("unsuccessful");
            }
        }
    }

    static boolean diva2Analysis(String srcFilepath, String dstFilepath, Double resolution, String gdalPath, boolean force) {
        try {
            File sgrd = new File(srcFilepath + ".grd");
            File sgri = new File(srcFilepath + ".gri");
            File dgrd = new File(dstFilepath + ".grd");
            File dgri = new File(dstFilepath + ".gri");
            if (force || !dgrd.exists() || !dgri.exists() || dgrd.lastModified() < sgrd.lastModified() || dgri.lastModified() < sgri.lastModified()) {
                double maxy;
                Grid g = new Grid(srcFilepath);
                double minx = g.xmin == (double)((int)(g.xmin / resolution)) * resolution ? g.xmin : (double)((int)(g.xmin / resolution)) * resolution + resolution;
                double maxx = g.xmax == (double)((int)(g.xmax / resolution)) * resolution ? g.xmax : (double)((int)(g.xmax / resolution)) * resolution;
                double miny = g.ymin == (double)((int)(g.ymin / resolution)) * resolution ? g.ymin : (double)((int)(g.ymin / resolution)) * resolution + resolution;
                double d = maxy = g.ymax == (double)((int)(g.ymax / resolution)) * resolution ? g.ymax : (double)((int)(g.ymax / resolution)) * resolution;
                if (maxx < minx + 2.0 * resolution) {
                    maxx = minx + 2.0 * resolution;
                }
                if (maxy < miny + 2.0 * resolution) {
                    maxy = miny + 2.0 * resolution;
                }
                new File(new File(dstFilepath).getParent()).mkdirs();
                if (minx == g.xmin && miny == g.ymin && maxx == g.xmax && maxy == g.ymax && resolution == g.xres && resolution == g.yres) {
                    AnalysisLayerUtil.fileCopy(srcFilepath + ".gri", dstFilepath + ".gri");
                    AnalysisLayerUtil.fileCopy(srcFilepath + ".grd", dstFilepath + ".grd");
                } else {
                    File tmpBil = File.createTempFile("tmpbil", "");
                    if (!Diva2bil.diva2bil(srcFilepath, tmpBil.getPath())) {
                        return false;
                    }
                    File tmpxBil = File.createTempFile("tmpxbil", "");
                    if (!AnalysisLayerUtil.gdal_warp(gdalPath, tmpBil.getPath() + ".bil", tmpxBil.getPath() + ".bil", resolution, minx, miny, maxx, maxy, g.nodatavalue)) {
                        return false;
                    }
                    if (!Bil2diva.bil2diva(tmpxBil.getPath(), dstFilepath, "")) {
                        return false;
                    }
                    AnalysisLayerUtil.deleteFiles(new String[]{tmpBil.getPath(), tmpBil.getPath() + ".bil", tmpBil.getPath() + ".hdr", tmpxBil.getPath(), tmpxBil.getPath() + ".bil", tmpxBil.getPath() + ".hdr", tmpxBil.getPath() + ".bil.aux.xml"});
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean gdal_warp(String gdalPath, String srcFilename, String dstFilename, double resolution, double minx, double miny, double maxx, double maxy, double nodatavalue) {
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            System.out.println("Got gdal_path: " + gdalPath);
            String base_command = gdalPath + "gdalwarp -te " + minx + " " + miny + " " + maxx + " " + maxy + " -dstnodata " + String.valueOf(nodatavalue) + " -tr " + resolution + " " + resolution + " -of EHdr ";
            String command = base_command + srcFilename + " " + dstFilename;
            System.out.println("Exec'ing " + command);
            Process proc = runtime.exec(command);
            System.out.println("Setting up output stream readers");
            InputStreamReader isr = new InputStreamReader(proc.getInputStream());
            InputStreamReader eisr = new InputStreamReader(proc.getErrorStream());
            BufferedReader br = new BufferedReader(isr);
            BufferedReader ebr = new BufferedReader(eisr);
            System.out.printf("Output of running %s is:", command);
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            while ((line = ebr.readLine()) != null) {
                System.out.println(line);
            }
            int exitVal = proc.waitFor();
            System.out.println(exitVal);
            if (exitVal == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return false;
    }

    private static void deleteFiles(String[] filesToDelete) {
        for (String s : filesToDelete) {
            try {
                new File(s).delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void fileCopy(String src, String dst) {
        try {
            int len;
            FileInputStream fis = new FileInputStream(src);
            FileOutputStream fos = new FileOutputStream(dst);
            byte[] buf = new byte[0x100000];
            while ((len = fis.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processShapeFiles() {
        LayerIntersectDAO liDao = Client.getLayerIntersectDao();
        LayerDAO layerDao = Client.getLayerDao();
        FieldDAO fieldDao = Client.getFieldDao();
        liDao.getConfig();
        List<Double> resolutions = IntersectConfig.getAnalysisResolutions();
        List<Field> fields = fieldDao.getFields();
        for (Field f : fields) {
            try {
                if (!f.isAnalysis().booleanValue() || !f.getType().equals("c")) continue;
                System.out.println("processing: " + f.getId());
                Layer l = layerDao.getLayerById(Integer.parseInt(f.getSpid()));
                File tmpShp = File.createTempFile("tmpshp", "");
                for (Double d : resolutions) {
                    StringBuilder stringBuilder = new StringBuilder();
                    liDao.getConfig();
                    String string = stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(l.getPath_orig()).toString();
                    String string2 = tmpShp.getPath();
                    String string3 = f.getId();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    liDao.getConfig();
                    String string4 = stringBuilder2.append(IntersectConfig.getAnalysisLayerFilesPath()).append(d).append(File.separator).append(f.getId()).toString();
                    liDao.getConfig();
                    if (AnalysisLayerUtil.shp2Analysis(string, string2, string3, string4, d, IntersectConfig.getGdalPath(), false)) {
                        System.out.println("successful for: " + f.getId() + " @ " + d);
                        continue;
                    }
                    System.out.println("unsuccessful for: " + f.getId() + " @ " + d);
                }
                AnalysisLayerUtil.deleteFiles(new String[]{tmpShp.getPath(), tmpShp.getPath() + ".shp", tmpShp.getPath() + ".shx", tmpShp.getPath() + ".dbf", tmpShp.getPath() + ".fix", tmpShp.getPath() + ".qix", tmpShp.getPath() + ".prj", tmpShp.getPath() + ".txt"});
            }
            catch (Exception e) {
                System.out.println("Error processing: " + f.getId());
                e.printStackTrace();
            }
        }
    }

    private static void processGridFiles() {
        LayerIntersectDAO liDao = Client.getLayerIntersectDao();
        LayerDAO layerDao = Client.getLayerDao();
        FieldDAO fieldDao = Client.getFieldDao();
        liDao.getConfig();
        List<Double> resolutions = IntersectConfig.getAnalysisResolutions();
        List<Field> fields = fieldDao.getFields();
        for (Field f : fields) {
            try {
                int i;
                if (!f.isAnalysis().booleanValue() || !f.getType().equals("e") && !f.getType().equals("a") && !f.getType().equals("b")) continue;
                Layer l = layerDao.getLayerById(Integer.parseInt(f.getSpid()));
                StringBuilder stringBuilder = new StringBuilder();
                liDao.getConfig();
                Grid g = new Grid(stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(l.getPath_orig()).toString());
                double minRes = Math.min(g.xres, g.yres);
                for (i = 0; i < resolutions.size() && resolutions.get(i) != minRes; ++i) {
                    if (!(resolutions.get(i) > minRes)) continue;
                    if (i <= 0) break;
                    --i;
                    break;
                }
                while (i < resolutions.size()) {
                    if (resolutions.get(i) >= minRes) {
                        System.out.println("processing: " + l.getPath_orig());
                        StringBuilder stringBuilder2 = new StringBuilder();
                        liDao.getConfig();
                        String string = stringBuilder2.append(IntersectConfig.getLayerFilesPath()).append(l.getPath_orig()).toString();
                        StringBuilder stringBuilder3 = new StringBuilder();
                        liDao.getConfig();
                        String string2 = stringBuilder3.append(IntersectConfig.getAnalysisLayerFilesPath()).append(resolutions.get(i)).append(File.separator).append(f.getId()).toString();
                        liDao.getConfig();
                        if (AnalysisLayerUtil.diva2Analysis(string, string2, resolutions.get(i), IntersectConfig.getGdalPath(), false)) {
                            if (f.getType().equals("a") || f.getType().equals("b")) {
                                StringBuilder stringBuilder4 = new StringBuilder();
                                liDao.getConfig();
                                String string3 = stringBuilder4.append(IntersectConfig.getLayerFilesPath()).append(l.getPath_orig()).append(".txt").toString();
                                StringBuilder stringBuilder5 = new StringBuilder();
                                liDao.getConfig();
                                AnalysisLayerUtil.copyFile(string3, stringBuilder5.append(IntersectConfig.getAnalysisLayerFilesPath()).append(resolutions.get(i)).append(File.separator).append(f.getId()).append(".txt").toString());
                            }
                            System.out.println("successful for: " + f.getId() + " @ " + resolutions.get(i));
                        } else {
                            System.out.println("unsuccessful for: " + f.getId() + " @ " + resolutions.get(i));
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("error processing: " + f.getId());
                e.printStackTrace();
            }
        }
    }

    static boolean shp2Analysis(String srcOrigFilepath, String srcFilepath, String fieldId, String dstFilepath, Double resolution, String gdalPath, boolean force) {
        try {
            File sshp = new File(srcOrigFilepath + ".shp");
            File tmpShp = new File(srcFilepath + ".shp");
            File dgrd = new File(dstFilepath + ".grd");
            File dgri = new File(dstFilepath + ".gri");
            if (force || !dgrd.exists() || !dgri.exists() || dgrd.lastModified() < sshp.lastModified() || dgri.lastModified() < sshp.lastModified()) {
                double maxy;
                new File(new File(dstFilepath).getParent()).mkdirs();
                if (!tmpShp.exists() && !AnalysisLayerUtil.fieldToShapeFile(fieldId, srcFilepath)) {
                    return false;
                }
                FileDataStore store = FileDataStoreFinder.getDataStore((File)tmpShp);
                ReferencedEnvelope re = store.getFeatureSource().getBounds();
                double minx = re.getMinX() == (double)((int)(re.getMinX() / resolution)) * resolution ? re.getMinX() : (double)((int)(re.getMinX() / resolution)) * resolution + resolution;
                double maxx = re.getMaxX() == (double)((int)(re.getMaxX() / resolution)) * resolution ? re.getMaxX() : (double)((int)(re.getMaxX() / resolution)) * resolution;
                double miny = re.getMinY() == (double)((int)(re.getMinY() / resolution)) * resolution ? re.getMinY() : (double)((int)(re.getMinY() / resolution)) * resolution + resolution;
                double d = maxy = re.getMaxY() == (double)((int)(re.getMaxY() / resolution)) * resolution ? re.getMaxY() : (double)((int)(re.getMaxY() / resolution)) * resolution;
                if (maxx < minx + 2.0 * resolution) {
                    maxx = minx + 2.0 * resolution;
                }
                if (maxy < miny + 2.0 * resolution) {
                    maxy = miny + 2.0 * resolution;
                }
                File tmpBil = File.createTempFile("tmpbil", "");
                if (!AnalysisLayerUtil.gdal_rasterize(gdalPath, tmpShp.getPath(), tmpBil.getPath() + ".bil", resolution, minx, miny, maxx, maxy)) {
                    return false;
                }
                if (!Bil2diva.bil2diva(tmpBil.getPath(), dstFilepath, "")) {
                    return false;
                }
                AnalysisLayerUtil.copyFile(srcFilepath + ".txt", dstFilepath + ".txt");
                AnalysisLayerUtil.deleteFiles(new String[]{tmpBil.getPath(), tmpBil.getPath() + ".bil", tmpBil.getPath() + ".hdr"});
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean gdal_rasterize(String gdalPath, String srcFilename, String dstFilename, double resolution, double minx, double miny, double maxx, double maxy) {
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            System.out.println("Got gdal_path: " + gdalPath);
            String layername = new File(srcFilename).getName().replace(".shp", "");
            String base_command = gdalPath + "gdal_rasterize -ot Int16 -of EHdr" + " -te " + minx + " " + miny + " " + maxx + " " + maxy + " -l " + layername + " -a id " + " -tr " + resolution + " " + resolution + " ";
            String command = base_command + srcFilename + " " + dstFilename;
            System.out.println("Exec'ing " + command);
            Process proc = runtime.exec(command);
            System.out.println("Setting up output stream readers");
            InputStreamReader isr = new InputStreamReader(proc.getInputStream());
            InputStreamReader eisr = new InputStreamReader(proc.getErrorStream());
            BufferedReader br = new BufferedReader(isr);
            BufferedReader ebr = new BufferedReader(eisr);
            System.out.printf("Output of running %s is:", command);
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            while ((line = ebr.readLine()) != null) {
                System.out.println(line);
            }
            int exitVal = proc.waitFor();
            System.out.println(exitVal);
            if (exitVal == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean fieldToShapeFile(String fid, String path) {
        boolean ret = true;
        try {
            SimpleFeatureType TYPE = DataUtilities.createType((String)"tmpshp", (String)"the_geom:MultiPolygon,id:int");
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", new File(path + ".shp").toURI().toURL());
            params.put("create spatial index", Boolean.FALSE);
            ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
            newDataStore.createSchema(TYPE);
            newDataStore.forceSchemaCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            DefaultTransaction transaction = new DefaultTransaction("create");
            String typeName = newDataStore.getTypeNames()[0];
            SimpleFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
            SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
            featureStore.setTransaction((Transaction)transaction);
            SimpleFeatureCollection collection = FeatureCollections.newCollection();
            OutputStreamWriter fw = null;
            try {
                fw = new FileWriter(path + ".txt");
                int count = 1;
                ObjectDAO objectDao = Client.getObjectDao();
                for (Objects o : objectDao.getObjectsById(fid)) {
                    String wkt = objectDao.getObjectsGeometryById(o.getPid(), "wkt");
                    WKTReader r = new WKTReader();
                    Geometry geom = r.read(wkt);
                    SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
                    featureBuilder.add((Object)geom);
                    featureBuilder.add((Object)count);
                    SimpleFeature f = featureBuilder.buildFeature(String.valueOf(count));
                    collection.add((Feature)f);
                    if (count > 1) {
                        fw.write("\n");
                    }
                    fw.write(count + "=" + o.getId());
                    ++count;
                }
                featureStore.addFeatures((FeatureCollection)collection);
                transaction.commit();
                transaction.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                ret = false;
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (Exception e) {
                        ret = false;
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            ret = false;
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(String src, String dst) {
        BufferedReader br = null;
        OutputStreamWriter fw = null;
        try {
            int n;
            br = new BufferedReader(new FileReader(src));
            fw = new FileWriter(dst);
            char[] buffer = new char[1024];
            while ((n = br.read(buffer)) > 0) {
                fw.write(buffer, 0, n);
            }
            br.close();
            fw.close();
        }
        catch (Exception e) {
            System.out.println("failure to copy: " + src + " to " + dst);
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

