/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.tabulation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.ala.layers.client.Client;
import org.ala.layers.dao.FieldDAO;
import org.ala.layers.dao.LayerDAO;
import org.ala.layers.dao.LayerIntersectDAO;
import org.ala.layers.dao.ObjectDAO;
import org.ala.layers.dto.Field;
import org.ala.layers.dto.Layer;
import org.ala.layers.dto.Objects;
import org.ala.layers.intersect.Grid;
import org.ala.layers.intersect.IntersectConfig;
import org.ala.layers.intersect.SimpleShapeFile;
import org.ala.layers.tabulation.AreaThread;
import org.ala.layers.tabulation.DistributionThread;
import org.ala.layers.tabulation.Pair;
import org.ala.layers.util.SpatialUtil;
import org.ala.spatial.analysis.layers.Records;

public class TabulationGenerator {
    static int CONCURRENT_THREADS = 6;
    static String db_url = "jdbc:postgresql://ala-maps-db.vm.csiro.au:5432/layersdb";
    static String db_usr = "postgres";
    static String db_pwd = "postgres";
    static String allFidPairsSQL = "SELECT (CASE WHEN f1.id < f2.id THEN f1.id ELSE f2.id END) as fid1, (CASE WHEN f1.id < f2.id THEN f2.id ELSE f1.id END) as fid2, (CASE WHEN f1.id < f2.id THEN f1.domain ELSE f2.domain END) as domain1, (CASE WHEN f1.id < f2.id THEN f2.domain ELSE f1.domain END) as domain2 FROM (select f3.id, f3.intersect, l1.domain from fields f3, layers l1 where f3.spid='' || l1.id) f1, (select f4.id, f4.intersect, l2.domain from fields f4, layers l2 where f4.spid='' || l2.id) f2 WHERE f1.id != f2.id AND f1.intersect=true AND f2.intersect=true group by fid1, fid2, domain1, domain2 order by fid1, fid2";
    static String existingTabulationssql = "SELECT fid1, fid2 from tabulation group by fid1, fid2";
    static String fidPairsToProcessSQL = "SELECT a.fid1, a.domain1, a.fid2, a.domain2 FROM (" + allFidPairsSQL + ") a WHERE (a.fid1, a.fid2) NOT IN (" + existingTabulationssql + ") group by a.fid1, a.fid2, a.domain1, a.domain2;";

    private static Connection getConnection() {
        Connection conn = null;
        try {
            Class.forName("org.postgresql.Driver");
            String url = db_url;
            conn = DriverManager.getConnection(url, db_usr, db_pwd);
        }
        catch (Exception e) {
            System.out.println("Unable to create Connection");
            e.printStackTrace(System.out);
        }
        return conn;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("args[0] = threadcount,\nargs[1] = db connection string,\n args[2] = db username,\n args[3] = password,\n args[4] = (optional) specify one step to run, '1' pair objects, '3' delete invalid objects, '4' area, '5' occurrences, '6' grid x grid comparisons\n args[5] = (required when args[4]=5 or 6) path to records file,");
        if (args.length >= 5) {
            CONCURRENT_THREADS = Integer.parseInt(args[0]);
            db_url = args[1];
            db_usr = args[2];
            db_pwd = args[3];
        }
        if (args.length < 5) {
            System.out.println("all");
            TabulationGenerator.updatePairObjects();
            TabulationGenerator.deleteInvalidObjects();
            long start = System.currentTimeMillis();
            while (TabulationGenerator.updateArea() > 0) {
                System.out.println("time since start= " + (System.currentTimeMillis() - start) + "ms");
            }
        } else if (args[4].equals("1")) {
            System.out.println("1");
            TabulationGenerator.updatePairObjects();
        } else if (args[4].equals("2")) {
            System.out.println("2");
        } else if (args[4].equals("3")) {
            System.out.println("3");
            TabulationGenerator.deleteInvalidObjects();
        } else if (args[4].equals("4")) {
            System.out.println("4");
            long start = System.currentTimeMillis();
            while (TabulationGenerator.updateArea() > 0) {
                System.out.println("time since start= " + (System.currentTimeMillis() - start) + "ms");
            }
        } else if (args[4].equals("5")) {
            System.out.println("5");
            FieldDAO fieldDao = Client.getFieldDao();
            LayerDAO layerDao = Client.getLayerDao();
            ObjectDAO objectDao = Client.getObjectDao();
            LayerIntersectDAO layerIntersectDao = Client.getLayerIntersectDao();
            System.out.println("TEST: " + fieldDao.getFields());
            System.out.println("RECORDS FILE: " + args[5]);
            File f = new File(args[5]);
            if (f.exists()) {
                Records records = new Records(f.getAbsolutePath());
                TabulationGenerator.updateOccurrencesSpecies2(records, CONCURRENT_THREADS);
            } else {
                System.out.println("Please provide a valid path to the species occurrence file");
            }
        } else if (args[4].equals("6")) {
            System.out.println("6");
            FieldDAO fieldDao = Client.getFieldDao();
            LayerDAO layerDao = Client.getLayerDao();
            ObjectDAO objectDao = Client.getObjectDao();
            LayerIntersectDAO layerIntersectDao = Client.getLayerIntersectDao();
            System.out.println("TEST: " + fieldDao.getFields());
            System.out.println("RECORDS FILE: " + args[5]);
            File f = new File(args[5]);
            if (f.exists()) {
                Records records = new Records(f.getAbsolutePath());
                TabulationGenerator.updatePairObjectsGridToGrid(records);
            } else {
                System.out.println("Please provide a valid path to the species occurrence file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePairObjects() {
        Connection conn = null;
        try {
            conn = TabulationGenerator.getConnection();
            String sql = fidPairsToProcessSQL;
            Statement s1 = conn.createStatement();
            ResultSet rs1 = s1.executeQuery(sql);
            ConcurrentLinkedQueue<String> data = new ConcurrentLinkedQueue<String>();
            while (rs1.next()) {
                String layer1 = Client.getFieldDao().getFieldById(rs1.getString("fid1")).getSpid();
                String layer2 = Client.getFieldDao().getFieldById(rs1.getString("fid2")).getSpid();
                String path1 = Client.getLayerDao().getLayerById(Integer.parseInt(layer1)).getPath_orig();
                String path2 = Client.getLayerDao().getLayerById(Integer.parseInt(layer2)).getPath_orig();
                StringBuilder stringBuilder = new StringBuilder();
                Client.getLayerIntersectDao().getConfig();
                File f1 = new File(stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(path1).append(".shp").toString());
                StringBuilder stringBuilder2 = new StringBuilder();
                Client.getLayerIntersectDao().getConfig();
                File f2 = new File(stringBuilder2.append(IntersectConfig.getLayerFilesPath()).append(path2).append(".shp").toString());
                if (!TabulationGenerator.isSameDomain(TabulationGenerator.parseDomain(rs1.getString("domain1")), TabulationGenerator.parseDomain(rs1.getString("domain2"))) || !f1.exists() || !f2.exists() || f1.length() >= 0x3200000L || f2.length() >= 0x3200000L) continue;
                System.out.println("will do tabulation on: " + rs1.getString("fid1") + ", " + rs1.getString("fid2"));
                data.add(rs1.getString("fid1") + "," + rs1.getString("fid2"));
            }
            System.out.println("next " + data.size());
            int size = data.size();
            if (size == 0) {
                return;
            }
            DistributionThread[] threads = new DistributionThread[CONCURRENT_THREADS];
            for (int j = 0; j < CONCURRENT_THREADS; ++j) {
                threads[j] = new DistributionThread(TabulationGenerator.getConnection().createStatement(), data);
                threads[j].start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static String[] parseDomain(String domain) {
        if (domain == null || domain.length() == 0) {
            return null;
        }
        String[] domains = domain.split(",");
        for (int i = 0; i < domains.length; ++i) {
            domains[i] = domains[i].trim();
        }
        return domains;
    }

    static boolean isSameDomain(String[] domain1, String[] domain2) {
        if (domain1 == null || domain2 == null) {
            return true;
        }
        for (String s1 : domain1) {
            for (String s2 : domain2) {
                if (!s1.equalsIgnoreCase(s2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePairObjectsGridToGrid(Records records) {
        Connection conn = null;
        try {
            conn = TabulationGenerator.getConnection();
            String sql = fidPairsToProcessSQL;
            Statement s1 = conn.createStatement();
            Statement s2 = conn.createStatement();
            ResultSet rs1 = s1.executeQuery(sql);
            while (rs1.next()) {
                String layer1 = Client.getFieldDao().getFieldById(rs1.getString("fid1")).getSpid();
                String layer2 = Client.getFieldDao().getFieldById(rs1.getString("fid2")).getSpid();
                String path1 = Client.getLayerDao().getLayerById(Integer.parseInt(layer1)).getPath_orig();
                String path2 = Client.getLayerDao().getLayerById(Integer.parseInt(layer2)).getPath_orig();
                StringBuilder stringBuilder = new StringBuilder();
                Client.getLayerIntersectDao().getConfig();
                File f1 = new File(stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(path1).append(".shp").toString());
                StringBuilder stringBuilder2 = new StringBuilder();
                Client.getLayerIntersectDao().getConfig();
                File f2 = new File(stringBuilder2.append(IntersectConfig.getLayerFilesPath()).append(path2).append(".shp").toString());
                if (!TabulationGenerator.isSameDomain(TabulationGenerator.parseDomain(rs1.getString("domain1")), TabulationGenerator.parseDomain(rs1.getString("domain2"))) || f1.exists() && f2.exists() && f1.length() < 0x3200000L && f2.length() < 0x3200000L) continue;
                System.out.println("gridToGrid: " + rs1.getString("fid1") + ", " + rs1.getString("fid2"));
                sql = TabulationGenerator.gridToGrid(rs1.getString("fid1"), rs1.getString("fid2"), records);
                s2.execute(sql);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static String gridToGrid(String fieldId1, String fieldId2, Records records) throws IOException {
        FileWriter fw = new FileWriter(fieldId1 + "_" + fieldId2 + ".sql");
        Client.getLayerIntersectDao().getConfig();
        List<Double> resolutions = IntersectConfig.getAnalysisResolutions();
        Double resolution = resolutions.get(0);
        resolution = Double.parseDouble(TabulationGenerator.confirmResolution(new String[]{fieldId1, fieldId2}, String.valueOf(resolution)));
        System.out.println("RESOLUTION: " + resolution);
        double[][] field1Extents = TabulationGenerator.getLayerExtents(String.valueOf(resolution), fieldId1);
        System.out.println("Extents for " + fieldId1 + ": " + field1Extents);
        double[][] field2Extents = TabulationGenerator.getLayerExtents(String.valueOf(resolution), fieldId2);
        System.out.println("Extents for " + fieldId2 + ": " + field2Extents);
        double[][] extents = TabulationGenerator.internalExtents(field1Extents, field2Extents);
        System.out.println("Internal extents: " + extents);
        if (!TabulationGenerator.isValidExtents(extents)) {
            System.out.println("Warning, no overlap between grids: " + fieldId1 + " and " + fieldId2);
            return null;
        }
        int width = 0;
        int height = 0;
        System.out.println("resolution: " + resolution);
        height = (int)Math.ceil((extents[1][1] - extents[0][1]) / resolution);
        width = (int)Math.ceil((extents[1][0] - extents[0][0]) / resolution);
        String pth1 = TabulationGenerator.getLayerPath("" + resolution, fieldId1);
        String pth2 = TabulationGenerator.getLayerPath("" + resolution, fieldId2);
        System.out.println("PATH 1: " + pth1);
        System.out.println("PATH 2: " + pth2);
        Grid grid1 = new Grid(pth1);
        Grid grid2 = new Grid(pth2);
        grid1.getGrid();
        grid2.getGrid();
        Properties p1 = new Properties();
        p1.load(new FileReader(pth1 + ".txt"));
        Properties p2 = new Properties();
        p2.load(new FileReader(pth2 + ".txt"));
        List<Objects> objects1 = Client.getObjectDao().getObjectsById(fieldId1);
        List<Objects> objects2 = Client.getObjectDao().getObjectsById(fieldId2);
        block0: for (Map.Entry<Object, Object> entry : p1.entrySet()) {
            for (Objects o : objects1) {
                if ((o.getId() != null || entry.getValue() != null) && (o.getId() == null || entry.getValue() == null || !o.getId().equalsIgnoreCase((String)entry.getValue()))) continue;
                entry.setValue(o.getPid());
                continue block0;
            }
        }
        block2: for (Map.Entry<Object, Object> entry : p2.entrySet()) {
            for (Objects o : objects2) {
                if ((o.getId() != null || entry.getValue() != null) && (o.getId() == null || entry.getValue() == null || !o.getId().equalsIgnoreCase((String)entry.getValue()))) continue;
                entry.setValue(o.getPid());
                continue block2;
            }
        }
        HashMap<String, Pair> map = new HashMap<String, Pair>();
        if (records != null) {
            for (int i = 0; i < records.getRecordsSize(); ++i) {
                int v1 = (int)grid1.getValues2(new double[][]{{records.getLongitude(i), records.getLatitude(i)}})[0];
                int v2 = (int)grid2.getValues2(new double[][]{{records.getLongitude(i), records.getLatitude(i)}})[0];
                String key = v1 + " " + v2;
                Pair p = (Pair)map.get(key);
                if (p == null) {
                    p = new Pair(key);
                    map.put(key, p);
                }
                p.species.set(records.getSpeciesNumber(i));
                ++p.occurrences;
            }
        }
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int v1 = (int)grid1.getValues2(new double[][]{{extents[0][0] + resolution * (double)i, extents[0][1] + resolution * (double)j}})[0];
                int v2 = (int)grid2.getValues2(new double[][]{{extents[0][0] + resolution * (double)i, extents[0][1] + resolution * (double)j}})[0];
                String key = v1 + " " + v2;
                Pair p = (Pair)map.get(key);
                if (p == null) {
                    p = new Pair(key);
                    map.put(key, p);
                }
                p.area += SpatialUtil.cellArea(resolution, extents[0][1] + resolution * (double)j) * 1000000.0;
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry p : map.entrySet()) {
            if (p1.get(((Pair)p.getValue()).v1) == null || p2.get(((Pair)p.getValue()).v2) == null) continue;
            String sql = "INSERT INTO tabulation (fid1, fid2, pid1, pid2, area, occurrences, species) VALUES ('" + fieldId1 + "','" + fieldId2 + "'," + "'" + p1.get(((Pair)p.getValue()).v1) + "','" + p2.get(((Pair)p.getValue()).v2) + "'," + ((Pair)p.getValue()).area + "," + ((Pair)p.getValue()).occurrences + "," + ((Pair)p.getValue()).species.cardinality() + ");";
            sb.append(sql);
            fw.write(sql);
            fw.write("\n");
            fw.flush();
        }
        fw.close();
        return sb.toString();
    }

    private static String confirmResolution(String[] layers, String resolution) {
        try {
            TreeMap<Double, String> resolutions = new TreeMap<Double, String>();
            for (String layer : layers) {
                String res;
                Double d;
                int start;
                int end;
                String path = TabulationGenerator.getLayerPath(resolution, layer);
                if (path == null || (end = path.lastIndexOf(File.separator)) <= 0 || (start = path.lastIndexOf(File.separator, end - 1)) <= 0 || !((d = Double.valueOf(Double.parseDouble(res = path.substring(start + 1, end)))) < 1.0)) continue;
                resolutions.put(d, res);
            }
            if (resolutions.size() > 0) {
                resolution = (String)resolutions.firstEntry().getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resolution;
    }

    static double[][] internalExtents(double[][] e1, double[][] e2) {
        double[][] internalExtents = new double[2][2];
        internalExtents[0][0] = Math.max(e1[0][0], e2[0][0]);
        internalExtents[0][1] = Math.max(e1[0][1], e2[0][1]);
        internalExtents[1][0] = Math.min(e1[1][0], e2[1][0]);
        internalExtents[1][1] = Math.min(e1[1][1], e2[1][1]);
        return internalExtents;
    }

    static boolean isValidExtents(double[][] e) {
        return e[0][0] < e[1][0] && e[0][1] < e[1][1];
    }

    static double[][] getLayerExtents(String resolution, String layer) {
        double[][] extents = new double[2][2];
        Grid g = Grid.getGrid(TabulationGenerator.getLayerPath(resolution, layer));
        extents[0][0] = g.xmin;
        extents[0][1] = g.ymin;
        extents[1][0] = g.xmax;
        extents[1][1] = g.ymax;
        return extents;
    }

    public static String getLayerPath(String resolution, String layer) {
        Client.getLayerIntersectDao().getConfig();
        String analysisLayerDir = IntersectConfig.getAnalysisLayerFilesPath();
        String field = TabulationGenerator.getFieldId(layer);
        File file = new File(analysisLayerDir + File.separator + resolution + File.separator + field + ".grd");
        try {
            while (!file.exists()) {
                TreeMap<Double, String> resolutionDirs = new TreeMap<Double, String>();
                for (File dir : new File(analysisLayerDir).listFiles()) {
                    if (!dir.isDirectory()) continue;
                    try {
                        System.out.println(dir.getName());
                        resolutionDirs.put(Double.parseDouble(dir.getName()), dir.getName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                String newResolution = (String)resolutionDirs.higherEntry(Double.parseDouble(resolution)).getValue();
                if (!newResolution.equals(resolution)) {
                    resolution = newResolution;
                    file = new File(analysisLayerDir + File.separator + resolution + File.separator + field + ".grd");
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String layerPath = analysisLayerDir + File.separator + resolution + File.separator + field;
        if (new File(layerPath + ".grd").exists()) {
            return layerPath;
        }
        System.out.println("getLayerPath, not a default layer, checking analysis output for: " + layer);
        String[] info = Client.getLayerIntersectDao().getConfig().getAnalysisLayerInfo(layer);
        if (info != null) {
            return info[1];
        }
        System.out.println("getLayerPath, cannot find for: " + layer + ", " + resolution);
        return null;
    }

    public static String getFieldId(String layerShortName) {
        String field = layerShortName;
        try {
            String id = String.valueOf(Client.getLayerDao().getLayerByName(layerShortName).getId());
            for (Field f : Client.getFieldDao().getFields()) {
                if (f.getSpid() == null || !f.getSpid().equals(id)) continue;
                field = f.getId();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateArea() {
        Connection conn = null;
        try {
            conn = TabulationGenerator.getConnection();
            String sql = "SELECT pid1, pid2, ST_AsText(the_geom) as wkt FROM tabulation WHERE pid1 is not null AND area is null  limit 100";
            if (conn == null) {
                System.out.println("connection is null");
            } else {
                System.out.println("connection is not null");
            }
            Statement s1 = conn.createStatement();
            ResultSet rs1 = s1.executeQuery(sql);
            ConcurrentLinkedQueue<String[]> data = new ConcurrentLinkedQueue<String[]>();
            while (rs1.next()) {
                data.add(new String[]{rs1.getString("pid1"), rs1.getString("pid2"), rs1.getString("wkt")});
            }
            System.out.println("next " + data.size());
            int size = data.size();
            if (size == 0) {
                int n = 0;
                return n;
            }
            AreaThread[] threads = new AreaThread[CONCURRENT_THREADS];
            for (int j = 0; j < CONCURRENT_THREADS; ++j) {
                threads[j] = new AreaThread(data, TabulationGenerator.getConnection().createStatement());
                threads[j].start();
            }
            int n = size;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateOccurrencesSpecies2(Records records, int threadCount) {
        FieldDAO fieldDao = Client.getFieldDao();
        LayerDAO layerDao = Client.getLayerDao();
        ObjectDAO objectDao = Client.getObjectDao();
        LayerIntersectDAO layerIntersectDao = Client.getLayerIntersectDao();
        HashSet<String> uniquePoints = new HashSet<String>();
        for (int i = 0; i < records.getRecordsSize(); ++i) {
            uniquePoints.add(records.getLongitude(i) + " " + records.getLatitude(i));
        }
        ArrayList pts = new ArrayList(uniquePoints);
        Collections.sort(pts);
        uniquePoints = null;
        double[][] points = new double[pts.size()][2];
        for (int i = 0; i < points.length; ++i) {
            String[] p = ((String)pts.get(i)).split(" ");
            points[i][0] = Double.NaN;
            points[i][1] = Double.NaN;
            try {
                points[i][0] = Double.parseDouble(p[0]);
                points[i][1] = Double.parseDouble(p[1]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int[] pointIdx = new int[records.getRecordsSize()];
        for (int i = 0; i < records.getRecordsSize(); ++i) {
            pointIdx[i] = Collections.binarySearch(pts, records.getLongitude(i) + " " + records.getLatitude(i));
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<File> files = new ArrayList<File>();
        for (Field f : fieldDao.getFields()) {
            if (!f.isIntersect().booleanValue()) continue;
            try {
                String fieldName = f.getSid();
                Layer l = layerDao.getLayerById(Integer.valueOf(f.getSpid()));
                StringBuilder stringBuilder = new StringBuilder();
                layerIntersectDao.getConfig();
                String filename = stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(l.getPath_orig()).toString();
                System.out.println(filename);
                SimpleShapeFile ssf = null;
                if (layerIntersectDao.getConfig().getShapeFileCache() != null) {
                    ssf = layerIntersectDao.getConfig().getShapeFileCache().get(filename);
                }
                if (ssf == null) {
                    ssf = new SimpleShapeFile(filename, fieldName);
                }
                int column_idx = ssf.getColumnIdx(fieldName);
                String[] catagories = ssf.getColumnLookup(column_idx);
                int[] values = ssf.intersect(points, catagories, column_idx, threadCount);
                List<Objects> objects = objectDao.getObjectsById(f.getId());
                int[] catToPid = new int[catagories.length];
                block32: for (int j = 0; j < objects.size(); ++j) {
                    for (int i = 0; i < catagories.length; ++i) {
                        if ((catagories[i] == null || objects.get(j).getId() == null) && catagories[i] == objects.get(j).getId()) {
                            catToPid[i] = j;
                            continue block32;
                        }
                        if (catagories[i] == null || objects.get(j).getId() == null || catagories[i].compareTo(objects.get(j).getId()) != 0) continue;
                        catToPid[i] = j;
                        continue block32;
                    }
                }
                OutputStreamWriter fw = null;
                try {
                    File tmp = File.createTempFile(f.getId(), "tabulation_generator");
                    System.out.println("**** tmp file **** > " + tmp.getPath());
                    fields.add(f);
                    files.add(tmp);
                    fw = new FileWriter(tmp);
                    if (values != null) {
                        for (int i = 0; i < values.length; ++i) {
                            if (i > 0) {
                                fw.append("\n");
                            }
                            if (values[i] >= 0) {
                                fw.append(objects.get(catToPid[values[i]]).getPid());
                                continue;
                            }
                            fw.append("n/a");
                        }
                    }
                    System.out.println("**** OK ***** > " + l.getPath_orig());
                }
                catch (Exception e) {
                    System.out.println("problem with sampling: " + l.getPath_orig());
                    e.printStackTrace();
                }
                finally {
                    if (fw == null) continue;
                    try {
                        fw.close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception e) {
                System.out.println("problem with sampling: " + f.getId());
                e.printStackTrace();
            }
        }
        Connection conn = null;
        try {
            conn = TabulationGenerator.getConnection();
            Statement statement = conn.createStatement();
            for (int i = 0; i < fields.size(); ++i) {
                String[] s1 = TabulationGenerator.loadFile((File)files.get(i), pts.size());
                for (int j = i + 1; j < fields.size(); ++j) {
                    String[] s2 = TabulationGenerator.loadFile((File)files.get(j), pts.size());
                    ArrayList<String> sqlUpdates = TabulationGenerator.compare(records, pointIdx, s1, s2);
                    StringBuilder sb = new StringBuilder();
                    for (String s : sqlUpdates) {
                        sb.append(s).append(";\n");
                    }
                    statement.execute(sb.toString());
                    System.out.println(sb.toString());
                }
            }
            statement.execute("UPDATE tabulation SET occurrences=0 WHERE occurrences is null;");
            statement.execute("UPDATE tabulation SET species=0 WHERE species is null;");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            for (int i = 0; i < files.size(); ++i) {
                System.out.println("FILE: " + ((File)files.get(i)).getPath());
                ((File)files.get(i)).delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return 0;
    }

    static String[] loadFile(File f, int size) {
        String[] s = new String[size];
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(f));
            int i = 0;
            while ((line = br.readLine()) != null) {
                s[i] = line;
                ++i;
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteInvalidObjects() {
        Connection conn = null;
        try {
            String sql = "delete from tabulation where the_geom is not null and st_area(the_geom) = 0;";
            conn = TabulationGenerator.getConnection();
            conn.createStatement().execute(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static ArrayList<String> compare(Records records, int[] pointIdx, String[] s1, String[] s2) {
        ArrayList<String> sqlUpdates = new ArrayList<String>();
        HashMap<String, BitSet> species = new HashMap<String, BitSet>();
        HashMap<String, Integer> occurrences = new HashMap<String, Integer>();
        for (int i = 0; i < pointIdx.length; ++i) {
            String key = s1[pointIdx[i]] + " " + s2[pointIdx[i]];
            BitSet bitset = (BitSet)species.get(key);
            if (bitset == null) {
                bitset = new BitSet();
            }
            bitset.set(records.getSpeciesNumber(i));
            species.put(key, bitset);
            Integer count = (Integer)occurrences.get(key);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            occurrences.put(key, count);
        }
        for (String k : species.keySet()) {
            String[] pids = k.split(" ");
            sqlUpdates.add("UPDATE tabulation SET species = " + ((BitSet)species.get(k)).cardinality() + ", " + "occurrences = " + occurrences.get(k) + " WHERE (pid1='" + pids[0] + "' AND pid2='" + pids[1] + "') " + "OR (pid1='" + pids[1] + "' AND pid2='" + pids[0] + "')");
        }
        return sqlUpdates;
    }
}

