/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.intersect;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.ala.layers.intersect.ComplexRegion;
import org.ala.layers.intersect.DBF;
import org.ala.layers.intersect.IntersectionThread;
import org.ala.layers.intersect.PointPos;
import org.ala.layers.intersect.ShapeHeader;
import org.ala.layers.intersect.ShapeRecords;
import org.ala.layers.intersect.ShapesReference;
import org.ala.layers.intersect.SimpleRegion;

public class SimpleShapeFile
implements Serializable {
    static final long serialVersionUID = -9046250209453575076L;
    ShapeHeader shapeheader;
    ShapeRecords shaperecords;
    DBF dbf;
    ShapesReference shapesreference;
    short[] singleColumn;
    String[] singleLookup;

    public SimpleShapeFile(String fileprefix, String column) {
        if (!this.loadRegion(fileprefix)) {
            this.dbf = new DBF(fileprefix + ".dbf", column);
            this.singleLookup = this.getColumnLookup(0);
            this.singleColumn = new short[this.dbf.dbfrecords.records.size()];
            for (int i = 0; i < this.singleColumn.length; ++i) {
                this.singleColumn[i] = (short)Arrays.binarySearch(this.singleLookup, this.dbf.getValue(i, 0));
            }
            this.dbf = null;
            this.shapeheader = new ShapeHeader(fileprefix);
            this.shaperecords = new ShapeRecords(fileprefix, this.shapeheader.getShapeType());
            this.shapeheader = null;
            this.shapesreference = new ShapesReference(this.shaperecords);
            this.shaperecords = null;
        }
    }

    public boolean loadRegion(String filename) {
        if (new File(filename).exists()) {
            try {
                FileInputStream fis = new FileInputStream(filename);
                BufferedInputStream bis = new BufferedInputStream(fis);
                ObjectInputStream ois = new ObjectInputStream(bis);
                this.shapesreference = (ShapesReference)ois.readObject();
                this.singleLookup = (String[])ois.readObject();
                this.singleColumn = (short[])ois.readObject();
                ois.close();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static ComplexRegion loadShapeInRegion(String filename, int idx) {
        ComplexRegion cr = null;
        try {
            FileInputStream fis = new FileInputStream(filename + "_" + idx);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(bis);
            cr = (ComplexRegion)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cr;
    }

    public String[] listColumns() {
        return this.dbf.getColumnNames();
    }

    public String[] getColumnLookup(int column) {
        if (this.singleLookup != null) {
            return this.singleLookup;
        }
        return this.dbf.getColumnLookup(column);
    }

    public int getColumnIdx(String column_name) {
        if (this.singleColumn != null) {
            return 0;
        }
        return this.dbf.getColumnIdx(column_name);
    }

    public int[] intersect(double[][] points, String[] lookup, int column, int threadcount) {
        int i;
        PointPos[] p = new PointPos[points.length];
        for (i = 0; i < p.length; ++i) {
            p[i] = new PointPos(points[i][0], points[i][1], i);
        }
        Arrays.sort(p, new Comparator<PointPos>(){

            @Override
            public int compare(PointPos o1, PointPos o2) {
                if (o1.x == o2.x) {
                    return o1.y - o2.y > 0.0 ? 1 : -1;
                }
                return o1.x - o2.x > 0.0 ? 1 : -1;
            }
        });
        ArrayList<Integer> threadstart = new ArrayList<Integer>(threadcount * 10);
        int step = (int)Math.ceil((double)points.length / (double)(threadcount * 10));
        if (step % 2 != 0) {
            ++step;
        }
        int pos = 0;
        for (i = 0; i < threadcount * 10; ++i) {
            threadstart.add(new Integer(pos));
            pos += step;
        }
        LinkedBlockingQueue<Integer> lbq = new LinkedBlockingQueue<Integer>(threadstart);
        CountDownLatch cdl = new CountDownLatch(lbq.size());
        IntersectionThread[] it = new IntersectionThread[threadcount];
        int[] target = new int[points.length];
        for (i = 0; i < threadcount; ++i) {
            it[i] = new IntersectionThread(this.shapesreference, p, lbq, step, target, cdl);
        }
        try {
            cdl.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (i = 0; i < threadcount; ++i) {
            it[i].interrupt();
        }
        if (this.singleColumn == null) {
            for (i = 0; i < target.length; ++i) {
                String s = this.dbf.getValue(target[i], column);
                int v = Arrays.binarySearch(lookup, s);
                if (v < 0) {
                    v = -1;
                }
                target[i] = v;
            }
        } else {
            for (i = 0; i < target.length; ++i) {
                target[i] = target[i] >= 0 && target[i] < this.singleColumn.length ? this.singleColumn[target[i]] : -1;
            }
        }
        return target;
    }

    public String intersect(double longitude, double latitude) {
        int idx = this.shapesreference.intersection(longitude, latitude);
        if (idx >= 0 && idx < this.singleColumn.length) {
            return this.singleLookup[this.singleColumn[idx]];
        }
        return null;
    }

    public int intersectInt(double longitude, double latitude) {
        if (this.singleColumn != null) {
            int v = this.shapesreference.intersection(longitude, latitude);
            if (v >= 0) {
                return this.singleColumn[v];
            }
            return -1;
        }
        return this.shapesreference.intersection(longitude, latitude);
    }

    public String getHeaderString() {
        return this.shapeheader.toString();
    }

    public String getValueString(int idx) {
        return this.singleLookup[idx];
    }

    public String[] getColumnLookup() {
        return this.singleLookup;
    }

    public static SimpleRegion parseWKT(String pointsString) {
        if (pointsString == null) {
            return null;
        }
        ArrayList<ArrayList<SimpleRegion>> regions = new ArrayList<ArrayList<SimpleRegion>>();
        if (pointsString.startsWith("GEOMETRYCOLLECTION")) {
            regions.addAll(SimpleShapeFile.parseGeometryCollection(pointsString.substring("GEOMETRYCOLLECTION(".length(), pointsString.length() - 1)));
        } else if (pointsString.startsWith("MULTIPOLYGON")) {
            regions.addAll(SimpleShapeFile.parseMultipolygon(pointsString.substring("MULTIPOLYGON(((".length(), pointsString.length() - 3)));
        } else if (pointsString.startsWith("POLYGON")) {
            regions.add(SimpleShapeFile.parsePolygon(pointsString.substring("POLYGON((".length(), pointsString.length() - 2)));
        }
        if (regions.size() == 0) {
            return null;
        }
        if (regions.size() == 1 && ((ArrayList)regions.get(0)).size() == 1) {
            return (SimpleRegion)((ArrayList)regions.get(0)).get(0);
        }
        ComplexRegion cr = new ComplexRegion();
        for (int i = 0; i < regions.size(); ++i) {
            cr.addSet((ArrayList)regions.get(i));
        }
        cr.useMask(-1, -1, -1);
        return cr;
    }

    static ArrayList<ArrayList<SimpleRegion>> parseGeometryCollection(String pointsString) {
        ArrayList<String> stringsList = new ArrayList<String>();
        int posStart = SimpleShapeFile.minPos(pointsString, "POLYGON", "MULTIPOLYGON", 0);
        int posEnd = SimpleShapeFile.minPos(pointsString, "POLYGON", "MULTIPOLYGON", posStart + 10);
        while (posEnd > 0) {
            stringsList.add(pointsString.substring(posStart, posEnd - 1));
            posStart = posEnd;
            posEnd = SimpleShapeFile.minPos(pointsString, "POLYGON", "MULTIPOLYGON", posStart + 10);
        }
        stringsList.add(pointsString.substring(posStart, pointsString.length()));
        ArrayList<ArrayList<SimpleRegion>> regions = new ArrayList<ArrayList<SimpleRegion>>();
        for (int i = 0; i < stringsList.size(); ++i) {
            if (((String)stringsList.get(i)).startsWith("MULTIPOLYGON")) {
                regions.addAll(SimpleShapeFile.parseMultipolygon(((String)stringsList.get(i)).substring("MULTIPOLYGON(((".length(), ((String)stringsList.get(i)).length() - 3)));
                continue;
            }
            if (!((String)stringsList.get(i)).startsWith("POLYGON")) continue;
            regions.add(SimpleShapeFile.parsePolygon(((String)stringsList.get(i)).substring("POLYGON((".length(), ((String)stringsList.get(i)).length() - 2)));
        }
        return regions;
    }

    static ArrayList<ArrayList<SimpleRegion>> parseMultipolygon(String multipolygon) {
        ArrayList<ArrayList<SimpleRegion>> regions = new ArrayList<ArrayList<SimpleRegion>>();
        String[] splitMultipolygon = multipolygon.split("\\)\\),\\(\\(");
        for (int j = 0; j < splitMultipolygon.length; ++j) {
            regions.add(SimpleShapeFile.parsePolygon(splitMultipolygon[j]));
        }
        return regions;
    }

    static ArrayList<SimpleRegion> parsePolygon(String polygon) {
        ArrayList<SimpleRegion> regions = new ArrayList<SimpleRegion>();
        for (String p : polygon.split("\\),\\(")) {
            regions.add(SimpleRegion.parseSimpleRegion(p));
        }
        return regions;
    }

    static int minPos(String lookIn, String lookFor1, String lookFor2, int startPos) {
        int p1 = lookIn.indexOf(lookFor1, startPos);
        int p2 = lookIn.indexOf(lookFor2, startPos);
        int pos = p1 < 0 ? p2 : (p2 < 0 ? p1 : Math.min(p1, p2));
        return pos;
    }
}

