/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.intersect;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.ala.layers.intersect.PointPos;
import org.ala.layers.intersect.ShapesReference;

class IntersectionThread
implements Runnable {
    Thread t = new Thread(this);
    ShapesReference shapesreference;
    PointPos[] points;
    LinkedBlockingQueue<Integer> lbq;
    int step;
    int[] target;
    CountDownLatch cdl;

    public IntersectionThread(ShapesReference shapesreference_, PointPos[] points_, LinkedBlockingQueue<Integer> lbq_, int step_, int[] target_, CountDownLatch cdl_) {
        this.t.setPriority(1);
        this.points = points_;
        this.shapesreference = shapesreference_;
        this.lbq = lbq_;
        this.step = step_;
        this.target = target_;
        this.cdl = cdl_;
        this.t.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                int sv;
                Integer start;
                int end;
                if ((end = (start = this.lbq.take()) + this.step) > this.target.length) {
                    end = this.target.length;
                }
                for (int i = sv = start.intValue(); i < end; ++i) {
                    int idx;
                    this.target[this.points[i].pos] = i > sv && this.points[i - 1].x == this.points[i].x && this.points[i - 1].y == this.points[i].y ? this.target[this.points[i - 1].pos] : ((idx = this.shapesreference.intersection(this.points[i].x, this.points[i].y)) >= 0 ? idx : -1);
                }
                this.cdl.countDown();
            }
        }
        catch (InterruptedException ie) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isAlive() {
        return this.t.isAlive();
    }

    void interrupt() {
        this.t.interrupt();
    }
}

