/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.intersect;

import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.ala.layers.intersect.DBFField;
import org.ala.layers.intersect.DBFHeader;
import org.ala.layers.intersect.DBFRecord;

class DBFRecords
implements Serializable {
    static final long serialVersionUID = -2450196133919654852L;
    ArrayList<DBFRecord> records = new ArrayList();
    boolean isvalid = false;

    public DBFRecords(String filename, DBFHeader header) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            FileChannel fc = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)fc.size() - header.getRecordsOffset());
            fc.read(buffer, header.getRecordsOffset());
            buffer.flip();
            ArrayList<DBFField> fields = header.getFields();
            for (int i = 0; i < header.getNumberOfRecords() && buffer.hasRemaining(); ++i) {
                this.records.add(new DBFRecord(buffer, fields));
            }
            fis.close();
            this.isvalid = true;
        }
        catch (Exception e) {
            System.out.println("loading records error: " + filename + ": " + e.toString());
            e.printStackTrace();
        }
    }

    DBFRecords(String filename, DBFHeader header, int[] columnIdx) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            FileChannel fc = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)fc.size() - header.getRecordsOffset());
            fc.read(buffer, header.getRecordsOffset());
            buffer.flip();
            ArrayList<DBFField> fields = header.getFields();
            for (int i = 0; i < header.getNumberOfRecords() && buffer.hasRemaining(); ++i) {
                this.records.add(new DBFRecord(buffer, fields, columnIdx));
            }
            fis.close();
            this.isvalid = true;
        }
        catch (Exception e) {
            System.out.println("loading records error: " + filename + ": " + e.toString());
            e.printStackTrace();
        }
    }

    public String getValue(int row, int column) {
        if (row >= 0 && row < this.records.size()) {
            return this.records.get(row).getValue(column);
        }
        return "";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (DBFRecord r : this.records) {
            sb.append(r.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

