/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.grid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.ala.layers.grid.GridGroup;

public class GridCacheReader {
    ArrayList<GridGroup> groups = new ArrayList();

    public GridCacheReader(String directory) {
        File dir;
        if (directory != null && (dir = new File(directory)) != null && dir.exists() && dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                try {
                    if (!f.getName().endsWith(".txt")) continue;
                    GridGroup g = new GridGroup(f.getPath());
                    this.groups.add(g);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public HashMap<String, Float> sample(double longitude, double latitude) throws IOException {
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (GridGroup g : this.groups) {
            map.putAll(g.sample(longitude, latitude));
        }
        return map;
    }

    public static void main(String[] args) {
        System.out.println("Test sampling on a grid cache with random points.\n\nargs[0] = output test results\nargs[1] = ready/diva_cache path");
        try {
            FileWriter fw = new FileWriter(args[0]);
            for (int i = 1; i < 5000; i += 10) {
                long t = GridCacheReader.largerTest(i, args[1]);
                fw.append(String.valueOf(i)).append(",").append(String.valueOf(t)).append("\n");
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    static void smallerTest(String diva_cache_path) {
        try {
            HashMap<String, Float> map = new GridCacheReader(diva_cache_path).sample(130.0, -22.0);
            for (String k : map.keySet()) {
                System.out.println(k + " > " + map.get(k));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static long largerTest(int size, String diva_cache_path) {
        try {
            ArrayList<Double> points = new ArrayList<Double>(2000);
            Random r = new Random(System.currentTimeMillis());
            for (int i = 0; i < size; ++i) {
                points.add(r.nextDouble() * 40.0 + 110.0);
                points.add(r.nextDouble() * 30.0 - 40.0);
            }
            int threadCount = 100;
            final LinkedBlockingQueue<GridCacheReader> lbqReaders = new LinkedBlockingQueue<GridCacheReader>();
            final LinkedBlockingQueue lbqPoints = new LinkedBlockingQueue();
            ArrayList<1> tasks = new ArrayList<1>();
            int pos = 0;
            int step = points.size() / threadCount;
            if (step % 2 == 1) {
                --step;
            }
            for (int i = 0; i < threadCount; ++i) {
                lbqReaders.add(new GridCacheReader(diva_cache_path));
                if (i == threadCount - 1) {
                    step = points.size();
                }
                lbqPoints.add(points.subList(pos, Math.min(points.size(), pos + step)));
                pos += step;
                tasks.add(new Callable<ArrayList<HashMap<String, Float>>>(){

                    @Override
                    public ArrayList<HashMap<String, Float>> call() throws Exception {
                        GridCacheReader gcr = (GridCacheReader)lbqReaders.take();
                        List points = (List)lbqPoints.take();
                        ArrayList<HashMap<String, Float>> list = new ArrayList<HashMap<String, Float>>();
                        for (int i = 0; i < points.size(); i += 2) {
                            HashMap<String, Float> map = gcr.sample((Double)points.get(i), (Double)points.get(i + 1));
                            map.put("longitude", Float.valueOf(((Double)points.get(i)).floatValue()));
                            map.put("latitude", Float.valueOf(((Double)points.get(i + 1)).floatValue()));
                            list.add(map);
                        }
                        return list;
                    }
                });
            }
            System.out.println("starting...");
            long start = System.currentTimeMillis();
            ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
            List output = executorService.invokeAll(tasks);
            long end = System.currentTimeMillis() - start;
            System.out.println("sampling time " + end + "ms for " + points.size() / 2);
            return end;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    static ArrayList<Double> loadPoints(String filename) {
        ArrayList<Double> points = new ArrayList<Double>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            br.readLine();
            while ((line = br.readLine()) != null) {
                String[] s = line.split(",");
                if (line.length() <= 0 || s.length != 2) continue;
                try {
                    double latitude = Double.parseDouble(s[0]);
                    double longitude = Double.parseDouble(s[1]);
                    points.add(longitude);
                    points.add(latitude);
                }
                catch (Exception e) {}
            }
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return points;
    }

    public ArrayList<String> getFileNames() {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < this.groups.size(); ++i) {
            fileNames.addAll(this.groups.get((int)i).files);
        }
        return fileNames;
    }

    public void updateNames(String fileName, String name) {
        for (int i = 0; i < this.groups.size(); ++i) {
            ArrayList<String> files = this.groups.get((int)i).files;
            for (int j = 0; j < files.size(); ++j) {
                if (!files.get(j).equals(fileName)) continue;
                this.groups.get((int)i).names.set(j, name);
                return;
            }
        }
    }

    public int getGroupCount() {
        return this.groups.size();
    }
}

