/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.ala.layers.dao.FieldDAO;
import org.ala.layers.dao.LayerIntersectDAO;
import org.ala.layers.dao.TabulationDAO;
import org.ala.layers.dto.IntersectionFile;
import org.ala.layers.dto.Tabulation;
import org.ala.layers.intersect.IntersectConfig;
import org.ala.layers.tabulation.TabulationUtil;
import org.ala.layers.util.SpatialUtil;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="tabulationDao")
public class TabulationDAOImpl
implements TabulationDAO {
    private static final Logger logger = Logger.getLogger(TabulationDAOImpl.class);
    private SimpleJdbcTemplate jdbcTemplate;
    @Resource(name="layerIntersectDao")
    private LayerIntersectDAO layerIntersectDao;
    @Resource(name="fieldDao")
    private FieldDAO fieldDao;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Override
    public List<Tabulation> getTabulation(String fid1, String fid2, String wkt) {
        String sql;
        String max;
        String min;
        List tabulations = null;
        if (fid1.compareTo(fid2) < 0) {
            min = fid1;
            max = fid2;
        } else {
            min = fid2;
            max = fid1;
        }
        if (wkt == null || wkt.length() == 0) {
            sql = "SELECT i.pid1, i.pid2, i.fid1, i.fid2, i.area, o1.name as name1, o2.name as name2, i.occurrences, i.species FROM (SELECT pid1, pid2, fid1, fid2, area, occurrences, species FROM tabulation WHERE fid1= ? AND fid2 = ? ) i, (select t1.pid1 as pid, name from tabulation t1 left join objects o3 on t1.fid1=o3.fid and t1.pid1=o3.pid where t1.fid1= ? group by t1.pid1, name) o1, (select t2.pid2 as pid, name from tabulation t2 left join objects o4 on t2.fid2=o4.fid and t2.pid2=o4.pid where t2.fid2= ? group by t2.pid2, name) o2 WHERE i.pid1=o1.pid AND i.pid2=o2.pid ;";
            tabulations = this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Tabulation.class), new Object[]{min, max, min, max});
        } else {
            sql = "SELECT fid1, pid1, fid2, pid2, ST_AsText(newgeom) as geometry, name1, name2, occurrences, species FROM (SELECT fid1, pid1, fid2, pid2, (ST_INTERSECTION(ST_GEOMFROMTEXT( ? ,4326), i.the_geom)) as newgeom, o1.name as name1, o2.name as name2, i.occurrences, i.species FROM (SELECT * FROM tabulation WHERE fid1= ? AND fid2 = ? ) i, (select t1.pid1 as pid, name from tabulation t1 left join objects o3 on t1.fid1=o3.fid and t1.pid1=o3.pid where t1.fid1= ? group by t1.pid1, name) o1, (select t2.pid2 as pid, name from tabulation t2 left join objects o4 on t2.fid2=o4.fid and t2.pid2=o4.pid where t2.fid2= ? group by t2.pid2, name) o2 WHERE i.pid1=o1.pid AND i.pid2=o2.pid) a WHERE a.newgeom is not null AND ST_Area(a.newgeom) > 0;";
            tabulations = this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Tabulation.class), new Object[]{wkt, min, max, min, max});
            for (Tabulation t : tabulations) {
                try {
                    t.setArea(SpatialUtil.calculateArea(t.getGeometry()));
                    this.layerIntersectDao.getConfig();
                    t.setOccurrences(TabulationUtil.calculateOccurrences(IntersectConfig.getOccurrenceSpeciesRecordsFilename(), t.getGeometry()));
                    this.layerIntersectDao.getConfig();
                    t.setSpecies(TabulationUtil.calculateSpecies(IntersectConfig.getOccurrenceSpeciesRecordsFilename(), t.getGeometry()));
                }
                catch (Exception e) {
                    logger.error((Object)("fid1:" + fid1 + " fid2:" + fid2 + " wkt:" + wkt), (Throwable)e);
                }
            }
        }
        IntersectionFile f = this.layerIntersectDao.getConfig().getIntersectionFile(min);
        if (f.getType().equals("a")) {
            for (Tabulation t : tabulations) {
                t.setName1(f.getClasses().get(Integer.parseInt(t.getPid1().split(":")[1])).getName());
            }
        }
        if ((f = this.layerIntersectDao.getConfig().getIntersectionFile(max)).getType().equals("a")) {
            for (Tabulation t : tabulations) {
                t.setName2(f.getClasses().get(Integer.parseInt(t.getPid2().split(":")[1])).getName());
            }
        }
        return tabulations;
    }

    @Override
    public List<Tabulation> listTabulations() {
        String incompleteTabulations = "select fid1, fid2 from tabulation where area is null and the_geom is not null group by fid1, fid2";
        String sql = "SELECT fid1, fid2, f1.name as name1, f2.name as name2  FROM (select t1.* from (select fid1, fid2, sum(area) a from tabulation group by fid1, fid2) t1 left join  (" + incompleteTabulations + ") i on t1.fid1=i.fid1 and t1.fid2=i.fid2 where i.fid1 is null" + ") t" + ", fields f1, fields f2 " + " WHERE f1.id = fid1 AND f2.id = fid2 AND a > 0 " + " AND f1.intersect=true AND f2.intersect=true " + " GROUP BY fid1, fid2, name1, name2;";
        return this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Tabulation.class), new Object[0]);
    }

    @Override
    public List<Tabulation> getTabulationSingle(String fid, String wkt) {
        if (wkt != null && wkt.length() > 0) {
            String sql = "SELECT fid as fid1, pid as pid1, name as name1, 'user area' as fid2, 'user area' as pid2, 'user area' as name2,  ST_AsText(newgeom) as geometry FROM (SELECT fid, pid, name, (ST_INTERSECTION(ST_GEOMFROMTEXT( ? ,4326), the_geom)) as newgeom FROM objects WHERE fid= ? ) o WHERE newgeom is not null AND ST_Area(newgeom) > 0;";
            List tabulations = this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Tabulation.class), new Object[]{wkt, fid});
            for (Tabulation t : tabulations) {
                try {
                    t.setArea(SpatialUtil.calculateArea(t.getGeometry()));
                }
                catch (Exception e) {
                    logger.error((Object)("fid:" + fid + " wkt:" + wkt), (Throwable)e);
                }
            }
            return tabulations;
        }
        String sql = "SELECT fid1, pid1, name as name1, 'world' as fid2, 'world' as pid2, 'world' as name2,  ST_AsText(newgeom) as geometry, area_km as area FROM (SELECT name, fid as fid1, pid as pid1, the_geom as newgeom, area_km FROM objects WHERE fid= ? ) t WHERE newgeom is not null AND ST_Area(newgeom) > 0;";
        List tabulations = this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Tabulation.class), new Object[]{fid});
        return tabulations;
    }
}

