/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.record;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gbif.dwc.terms.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarwinCoreTaxon {
    private static final Logger LOG = LoggerFactory.getLogger(DarwinCoreTaxon.class);
    private static final String CLASSIFICATION_DELIMITER = " | ";
    private static final Pattern NORM_AUTHORS = Pattern.compile("[^a-z0-9]+");
    private String type;
    private String modified;
    private String language;
    private String license;
    private String rightsHolder;
    private String accessRights;
    private String bibliographicCitation;
    private String references;
    private String institutionID;
    private String collectionID;
    private String datasetID;
    private String institutionCode;
    private String collectionCode;
    private String datasetName;
    private String ownerInstitutionCode;
    private String basisOfRecord;
    private String informationWithheld;
    private String dataGeneralizations;
    private String dynamicProperties;
    private String taxonID;
    private String scientificNameID;
    private String acceptedNameUsageID;
    private String parentNameUsageID;
    private String originalNameUsageID;
    private String nameAccordingToID;
    private String namePublishedInID;
    private String taxonConceptID;
    private String scientificName;
    private String acceptedNameUsage;
    private String parentNameUsage;
    private String originalNameUsage;
    private String nameAccordingTo;
    private String namePublishedIn;
    private String namePublishedInYear;
    private String higherClassification;
    private String kingdom;
    private String phylum;
    private String classs;
    private String order;
    private String family;
    private String genus;
    private String subgenus;
    private String specificEpithet;
    private String infraspecificEpithet;
    private String taxonRank;
    private String verbatimTaxonRank;
    private String scientificNameAuthorship;
    private String vernacularName;
    private String nomenclaturalCode;
    private String taxonomicStatus;
    private String nomenclaturalStatus;
    private String taxonRemarks;

    public DarwinCoreTaxon() {
    }

    public DarwinCoreTaxon(String scientificName) {
        this.scientificName = this.norm(scientificName);
    }

    public String buildHigherClassification(Character lowestRank) {
        StringBuilder buf = new StringBuilder();
        if (this.kingdom != null) {
            buf.append(StringUtils.capitalize((String)this.kingdom.toLowerCase()));
            buf.append(CLASSIFICATION_DELIMITER);
        }
        if (lowestRank == null || lowestRank.charValue() != 'k') {
            if (this.phylum != null) {
                buf.append(StringUtils.capitalize((String)this.phylum.toLowerCase()));
                buf.append(CLASSIFICATION_DELIMITER);
            }
            if (lowestRank == null || lowestRank.charValue() != 'p') {
                if (this.classs != null) {
                    buf.append(StringUtils.capitalize((String)this.classs.toLowerCase()));
                    buf.append(CLASSIFICATION_DELIMITER);
                }
                if (lowestRank == null || lowestRank.charValue() != 'c') {
                    if (this.order != null) {
                        buf.append(StringUtils.capitalize((String)this.order.toLowerCase()));
                        buf.append(CLASSIFICATION_DELIMITER);
                    }
                    if (lowestRank == null || lowestRank.charValue() != 'o') {
                        if (this.family != null) {
                            buf.append(StringUtils.capitalize((String)this.family.toLowerCase()));
                            buf.append(CLASSIFICATION_DELIMITER);
                        }
                        if (lowestRank == null || lowestRank.charValue() != 'f') {
                            if (this.genus != null) {
                                buf.append(StringUtils.capitalize((String)this.genus.toLowerCase()));
                                buf.append(CLASSIFICATION_DELIMITER);
                            }
                            if ((lowestRank == null || lowestRank.charValue() != 'g') && this.subgenus != null) {
                                buf.append(StringUtils.capitalize((String)this.subgenus.toLowerCase()));
                                buf.append(CLASSIFICATION_DELIMITER);
                            }
                        }
                    }
                }
            }
        }
        if (buf.length() > CLASSIFICATION_DELIMITER.length()) {
            buf.delete(buf.length() - CLASSIFICATION_DELIMITER.length(), buf.length());
        }
        return buf.toString();
    }

    public String getFullScientificName() {
        String normedAuthors;
        String normedSciName;
        if (this.scientificNameAuthorship != null && this.scientificName != null && !(normedSciName = NORM_AUTHORS.matcher(this.scientificName.toLowerCase()).replaceAll(" ")).contains(normedAuthors = NORM_AUTHORS.matcher(this.scientificNameAuthorship.toLowerCase()).replaceAll(" "))) {
            return this.scientificName + " " + this.scientificNameAuthorship;
        }
        if (this.scientificName == null) {
            String sciname = null;
            if (this.genus != null) {
                if (this.specificEpithet != null) {
                    sciname = this.genus + " " + this.specificEpithet;
                    if (this.infraspecificEpithet != null) {
                        sciname = sciname + " " + this.infraspecificEpithet;
                    }
                    if (sciname != null && this.scientificNameAuthorship != null) {
                        sciname = sciname + " " + this.scientificNameAuthorship;
                    }
                } else {
                    sciname = this.subgenus != null ? this.subgenus : this.genus;
                }
            }
            return sciname;
        }
        return this.scientificName;
    }

    public String getLowestScientificName() {
        String sciname = this.getFullScientificName();
        if (sciname == null) {
            if (this.family != null) {
                sciname = this.family;
            } else if (this.order != null) {
                sciname = this.order;
            } else if (this.classs != null) {
                sciname = this.classs;
            } else if (this.phylum != null) {
                sciname = this.phylum;
            } else if (this.kingdom != null) {
                sciname = this.kingdom;
            }
        }
        return sciname;
    }

    public String getProperty(Term prop) {
        String getter = String.format("get%s", this.getPropertyName(prop));
        try {
            Method m = this.getClass().getMethod(getter, new Class[0]);
            Object val = m.invoke((Object)this, new Object[0]);
            return val == null ? null : val.toString();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("non existing dwc property: " + prop);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getPropertyName(Term prop) {
        String propName = StringUtils.capitalize((String)prop.simpleName());
        if (propName.equalsIgnoreCase("Class")) {
            propName = "Classs";
        }
        return propName;
    }

    public String getTaxonRankInterpreted() {
        if (this.scientificName != null || this.taxonRank != null) {
            return this.taxonRank;
        }
        if (this.genus != null && this.specificEpithet != null && this.infraspecificEpithet != null) {
            if (this.taxonRank != null) {
                return this.taxonRank;
            }
            if (this.verbatimTaxonRank != null) {
                return this.verbatimTaxonRank;
            }
            return "infraspecies";
        }
        if (this.genus != null && this.specificEpithet != null) {
            return "species";
        }
        if (this.subgenus != null) {
            return "subgenus";
        }
        if (this.genus != null) {
            return "genus";
        }
        if (this.family != null) {
            return "family";
        }
        if (this.order != null) {
            return "order";
        }
        if (this.classs != null) {
            return "class";
        }
        if (this.phylum != null) {
            return "phylum";
        }
        if (this.kingdom != null) {
            return "kingdom";
        }
        return null;
    }

    protected String norm(String x) {
        if ((x = StringUtils.trimToNull((String)x)) != null && (x.equalsIgnoreCase("\\N") || x.equalsIgnoreCase("NULL"))) {
            x = null;
        }
        return x;
    }

    public boolean setProperty(Term prop, String value) {
        if (prop == null) {
            return false;
        }
        String setterName = null;
        try {
            setterName = String.format("set%s", this.getPropertyName(prop));
            Method m = this.getClass().getMethod(setterName, String.class);
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            LOG.warn("Trying to access bad dwc property setter: " + setterName + " for property " + prop);
            return false;
        }
        return true;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("taxonID", (Object)this.taxonID).append("scientificName", (Object)this.scientificName).toString();
    }

    public String getAcceptedNameUsage() {
        return this.acceptedNameUsage;
    }

    public String getAcceptedNameUsageID() {
        return this.acceptedNameUsageID;
    }

    public String getAccessRights() {
        return this.accessRights;
    }

    public String getBasisOfRecord() {
        return this.basisOfRecord;
    }

    public String getBibliographicCitation() {
        return this.bibliographicCitation;
    }

    public String getClasss() {
        return this.classs;
    }

    public String getCollectionCode() {
        return this.collectionCode;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getDataGeneralizations() {
        return this.dataGeneralizations;
    }

    public String getDatasetID() {
        return this.datasetID;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getDynamicProperties() {
        return this.dynamicProperties;
    }

    public String getFamily() {
        return this.family;
    }

    public String getGenus() {
        return this.genus;
    }

    public String getHigherClassification() {
        return this.higherClassification;
    }

    public String getInformationWithheld() {
        return this.informationWithheld;
    }

    public String getInfraspecificEpithet() {
        return this.infraspecificEpithet;
    }

    public String getInstitutionCode() {
        return this.institutionCode;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getKingdom() {
        return this.kingdom;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLicense() {
        return this.license;
    }

    public String getModified() {
        return this.modified;
    }

    public String getNameAccordingTo() {
        return this.nameAccordingTo;
    }

    public String getNameAccordingToID() {
        return this.nameAccordingToID;
    }

    public String getNamePublishedIn() {
        return this.namePublishedIn;
    }

    public String getNamePublishedInID() {
        return this.namePublishedInID;
    }

    public String getNamePublishedInYear() {
        return this.namePublishedInYear;
    }

    public String getNomenclaturalCode() {
        return this.nomenclaturalCode;
    }

    public String getNomenclaturalStatus() {
        return this.nomenclaturalStatus;
    }

    public String getOrder() {
        return this.order;
    }

    public String getOriginalNameUsage() {
        return this.originalNameUsage;
    }

    public String getOriginalNameUsageID() {
        return this.originalNameUsageID;
    }

    public String getOwnerInstitutionCode() {
        return this.ownerInstitutionCode;
    }

    public String getParentNameUsage() {
        return this.parentNameUsage;
    }

    public String getParentNameUsageID() {
        return this.parentNameUsageID;
    }

    public String getPhylum() {
        return this.phylum;
    }

    public String getReferences() {
        return this.references;
    }

    public String getRightsHolder() {
        return this.rightsHolder;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public String getScientificNameAuthorship() {
        return this.scientificNameAuthorship;
    }

    public String getScientificNameID() {
        return this.scientificNameID;
    }

    public String getSpecificEpithet() {
        return this.specificEpithet;
    }

    public String getSubgenus() {
        return this.subgenus;
    }

    public String getTaxonConceptID() {
        return this.taxonConceptID;
    }

    public String getTaxonID() {
        return this.taxonID;
    }

    public String getTaxonomicStatus() {
        return this.taxonomicStatus;
    }

    public String getTaxonRank() {
        return this.taxonRank;
    }

    public String getTaxonRemarks() {
        return this.taxonRemarks;
    }

    public String getType() {
        return this.type;
    }

    public String getVerbatimTaxonRank() {
        return this.verbatimTaxonRank;
    }

    public String getVernacularName() {
        return this.vernacularName;
    }

    public void setAcceptedNameUsage(String acceptedNameUsage) {
        this.acceptedNameUsage = acceptedNameUsage;
    }

    public void setAcceptedNameUsageID(String acceptedNameUsageID) {
        this.acceptedNameUsageID = acceptedNameUsageID;
    }

    public void setAccessRights(String accessRights) {
        this.accessRights = this.norm(accessRights);
    }

    public void setBasisOfRecord(String basisOfRecord) {
        this.basisOfRecord = this.norm(basisOfRecord);
    }

    public void setBibliographicCitation(String bibliographicCitation) {
        this.bibliographicCitation = bibliographicCitation;
    }

    public void setClasss(String classs) {
        this.classs = this.norm(classs);
    }

    public void setCollectionCode(String collectionCode) {
        this.collectionCode = this.norm(collectionCode);
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = this.norm(collectionID);
    }

    public void setDataGeneralizations(String dataGeneralizations) {
        this.dataGeneralizations = this.norm(dataGeneralizations);
    }

    public void setDatasetID(String datasetID) {
        this.datasetID = this.norm(datasetID);
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public void setDynamicProperties(String dynamicProperties) {
        this.dynamicProperties = dynamicProperties;
    }

    public void setFamily(String family) {
        this.family = this.norm(family);
    }

    public void setGenus(String genus) {
        this.genus = this.norm(genus);
    }

    public void setHigherClassification(String higherClassification) {
        this.higherClassification = higherClassification;
    }

    public void setInformationWithheld(String informationWithheld) {
        this.informationWithheld = this.norm(informationWithheld);
    }

    public void setInfraspecificEpithet(String infraspecificEpithet) {
        this.infraspecificEpithet = this.norm(infraspecificEpithet);
    }

    public void setInstitutionCode(String institutionCode) {
        this.institutionCode = this.norm(institutionCode);
    }

    public void setInstitutionID(String institutionID) {
        this.institutionID = institutionID;
    }

    public void setKingdom(String kingdom) {
        this.kingdom = this.norm(kingdom);
    }

    public void setLanguage(String language) {
        this.language = this.norm(language);
    }

    public void setLicense(String license) {
        this.license = this.norm(license);
    }

    public void setModified(String modified) {
        this.modified = this.norm(modified);
    }

    public void setNameAccordingTo(String nameAccordingTo) {
        this.nameAccordingTo = nameAccordingTo;
    }

    public void setNameAccordingToID(String nameAccordingToID) {
        this.nameAccordingToID = nameAccordingToID;
    }

    public void setNamePublishedIn(String namePublishedIn) {
        this.namePublishedIn = this.norm(namePublishedIn);
    }

    public void setNamePublishedInID(String namePublishedInID) {
        this.namePublishedInID = namePublishedInID;
    }

    public void setNamePublishedInYear(String namePublishedInYear) {
        this.namePublishedInYear = namePublishedInYear;
    }

    public void setNomenclaturalCode(String nomenclaturalCode) {
        this.nomenclaturalCode = this.norm(nomenclaturalCode);
    }

    public void setNomenclaturalStatus(String nomenclaturalStatus) {
        this.nomenclaturalStatus = this.norm(nomenclaturalStatus);
    }

    public void setOrder(String order) {
        this.order = this.norm(order);
    }

    public void setOriginalNameUsage(String originalNameUsage) {
        this.originalNameUsage = originalNameUsage;
    }

    public void setOriginalNameUsageID(String originalNameUsageID) {
        this.originalNameUsageID = originalNameUsageID;
    }

    public void setOwnerInstitutionCode(String ownerInstitutionCode) {
        this.ownerInstitutionCode = ownerInstitutionCode;
    }

    public void setParentNameUsage(String parentNameUsage) {
        this.parentNameUsage = parentNameUsage;
    }

    public void setParentNameUsageID(String parentNameUsageID) {
        this.parentNameUsageID = parentNameUsageID;
    }

    public void setPhylum(String phylum) {
        this.phylum = this.norm(phylum);
    }

    public void setReferences(String references) {
        this.references = this.norm(references);
    }

    public void setRightsHolder(String rightsHolder) {
        this.rightsHolder = this.norm(rightsHolder);
    }

    public void setScientificName(String scientificName) {
        this.scientificName = this.norm(scientificName);
    }

    public void setScientificNameAuthorship(String scientificNameAuthorship) {
        this.scientificNameAuthorship = this.norm(scientificNameAuthorship);
    }

    public void setScientificNameID(String scientificNameID) {
        this.scientificNameID = scientificNameID;
    }

    public void setSpecificEpithet(String specificEpithet) {
        this.specificEpithet = this.norm(specificEpithet);
    }

    public void setSubgenus(String subgenus) {
        this.subgenus = this.norm(subgenus);
    }

    public void setTaxonConceptID(String taxonConceptID) {
        this.taxonConceptID = taxonConceptID;
    }

    public void setTaxonID(String taxonID) {
        this.taxonID = this.norm(taxonID);
    }

    public void setTaxonomicStatus(String taxonomicStatus) {
        this.taxonomicStatus = this.norm(taxonomicStatus);
    }

    public void setTaxonRank(String taxonRank) {
        this.taxonRank = this.norm(taxonRank);
    }

    public void setTaxonRemarks(String taxonRemarks) {
        this.taxonRemarks = this.norm(taxonRemarks);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVerbatimTaxonRank(String verbatimTaxonRank) {
        this.verbatimTaxonRank = verbatimTaxonRank;
    }

    public void setVernacularName(String vernacularName) {
        this.vernacularName = vernacularName;
    }
}

