/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.core;

import com.google.common.base.Strings;
import org.gbif.common.parsers.core.Parsable;
import org.gbif.common.parsers.core.ParseResult;

public final class ASCIIParser
implements Parsable<String> {
    private static ASCIIParser singletonObject = null;

    private ASCIIParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASCIIParser getInstance() {
        Class<ASCIIParser> clazz = ASCIIParser.class;
        synchronized (ASCIIParser.class) {
            if (singletonObject == null) {
                singletonObject = new ASCIIParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonObject;
        }
    }

    @Override
    public ParseResult<String> parse(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return ParseResult.fail();
        }
        StringBuilder sb = new StringBuilder();
        for (char c : input.toCharArray()) {
            ASCIIParser.foldToASCII(c, sb);
        }
        return ParseResult.success(ParseResult.CONFIDENCE.DEFINITE, sb.toString());
    }

    private static final void foldToASCII(char c, StringBuilder sb) {
        if (c < '\u0080') {
            sb.append(c);
        } else {
            switch (c) {
                case '\u00c0': 
                case '\u00c1': 
                case '\u00c2': 
                case '\u00c3': 
                case '\u00c4': 
                case '\u00c5': 
                case '\u0100': 
                case '\u0102': 
                case '\u0104': 
                case '\u018f': 
                case '\u01cd': 
                case '\u01de': 
                case '\u01e0': 
                case '\u01fa': 
                case '\u0200': 
                case '\u0202': 
                case '\u0226': 
                case '\u023a': 
                case '\u1d00': 
                case '\u1e00': 
                case '\u1ea0': 
                case '\u1ea2': 
                case '\u1ea4': 
                case '\u1ea6': 
                case '\u1ea8': 
                case '\u1eaa': 
                case '\u1eac': 
                case '\u1eae': 
                case '\u1eb0': 
                case '\u1eb2': 
                case '\u1eb4': 
                case '\u1eb6': 
                case '\u24b6': 
                case '\uff21': {
                    sb.append('A');
                    break;
                }
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e2': 
                case '\u00e3': 
                case '\u00e4': 
                case '\u00e5': 
                case '\u0101': 
                case '\u0103': 
                case '\u0105': 
                case '\u01ce': 
                case '\u01df': 
                case '\u01e1': 
                case '\u01fb': 
                case '\u0201': 
                case '\u0203': 
                case '\u0227': 
                case '\u0250': 
                case '\u0259': 
                case '\u025a': 
                case '\u1d8f': 
                case '\u1d95': 
                case '\u1e01': 
                case '\u1e9a': 
                case '\u1ea1': 
                case '\u1ea3': 
                case '\u1ea5': 
                case '\u1ea7': 
                case '\u1ea9': 
                case '\u1eab': 
                case '\u1ead': 
                case '\u1eaf': 
                case '\u1eb1': 
                case '\u1eb3': 
                case '\u1eb5': 
                case '\u1eb7': 
                case '\u2090': 
                case '\u2094': 
                case '\u24d0': 
                case '\u2c65': 
                case '\u2c6f': 
                case '\uff41': {
                    sb.append('a');
                    break;
                }
                case '\ua732': {
                    sb.append('A');
                    sb.append('A');
                    break;
                }
                case '\u00c6': 
                case '\u01e2': 
                case '\u01fc': 
                case '\u1d01': {
                    sb.append('A');
                    sb.append('E');
                    break;
                }
                case '\ua734': {
                    sb.append('A');
                    sb.append('O');
                    break;
                }
                case '\ua736': {
                    sb.append('A');
                    sb.append('U');
                    break;
                }
                case '\ua738': 
                case '\ua73a': {
                    sb.append('A');
                    sb.append('V');
                    break;
                }
                case '\ua73c': {
                    sb.append('A');
                    sb.append('Y');
                    break;
                }
                case '\u249c': {
                    sb.append('(');
                    sb.append('a');
                    sb.append(')');
                    break;
                }
                case '\ua733': {
                    sb.append('a');
                    sb.append('a');
                    break;
                }
                case '\u00e6': 
                case '\u01e3': 
                case '\u01fd': 
                case '\u1d02': {
                    sb.append('a');
                    sb.append('e');
                    break;
                }
                case '\ua735': {
                    sb.append('a');
                    sb.append('o');
                    break;
                }
                case '\ua737': {
                    sb.append('a');
                    sb.append('u');
                    break;
                }
                case '\ua739': 
                case '\ua73b': {
                    sb.append('a');
                    sb.append('v');
                    break;
                }
                case '\ua73d': {
                    sb.append('a');
                    sb.append('y');
                    break;
                }
                case '\u0181': 
                case '\u0182': 
                case '\u0243': 
                case '\u0299': 
                case '\u1d03': 
                case '\u1e02': 
                case '\u1e04': 
                case '\u1e06': 
                case '\u24b7': 
                case '\uff22': {
                    sb.append('B');
                    break;
                }
                case '\u0180': 
                case '\u0183': 
                case '\u0253': 
                case '\u1d6c': 
                case '\u1d80': 
                case '\u1e03': 
                case '\u1e05': 
                case '\u1e07': 
                case '\u24d1': 
                case '\uff42': {
                    sb.append('b');
                    break;
                }
                case '\u249d': {
                    sb.append('(');
                    sb.append('b');
                    sb.append(')');
                    break;
                }
                case '\u00c7': 
                case '\u0106': 
                case '\u0108': 
                case '\u010a': 
                case '\u010c': 
                case '\u0187': 
                case '\u023b': 
                case '\u0297': 
                case '\u1d04': 
                case '\u1e08': 
                case '\u24b8': 
                case '\uff23': {
                    sb.append('C');
                    break;
                }
                case '\u00e7': 
                case '\u0107': 
                case '\u0109': 
                case '\u010b': 
                case '\u010d': 
                case '\u0188': 
                case '\u023c': 
                case '\u0255': 
                case '\u1e09': 
                case '\u2184': 
                case '\u24d2': 
                case '\ua73e': 
                case '\ua73f': 
                case '\uff43': {
                    sb.append('c');
                    break;
                }
                case '\u249e': {
                    sb.append('(');
                    sb.append('c');
                    sb.append(')');
                    break;
                }
                case '\u00d0': 
                case '\u010e': 
                case '\u0110': 
                case '\u0189': 
                case '\u018a': 
                case '\u018b': 
                case '\u1d05': 
                case '\u1d06': 
                case '\u1e0a': 
                case '\u1e0c': 
                case '\u1e0e': 
                case '\u1e10': 
                case '\u1e12': 
                case '\u24b9': 
                case '\ua779': 
                case '\uff24': {
                    sb.append('D');
                    break;
                }
                case '\u00f0': 
                case '\u010f': 
                case '\u0111': 
                case '\u018c': 
                case '\u0221': 
                case '\u0256': 
                case '\u0257': 
                case '\u1d6d': 
                case '\u1d81': 
                case '\u1d91': 
                case '\u1e0b': 
                case '\u1e0d': 
                case '\u1e0f': 
                case '\u1e11': 
                case '\u1e13': 
                case '\u24d3': 
                case '\ua77a': 
                case '\uff44': {
                    sb.append('d');
                    break;
                }
                case '\u01c4': 
                case '\u01f1': {
                    sb.append('D');
                    sb.append('Z');
                    break;
                }
                case '\u01c5': 
                case '\u01f2': {
                    sb.append('D');
                    sb.append('z');
                    break;
                }
                case '\u249f': {
                    sb.append('(');
                    sb.append('d');
                    sb.append(')');
                    break;
                }
                case '\u0238': {
                    sb.append('d');
                    sb.append('b');
                    break;
                }
                case '\u01c6': 
                case '\u01f3': 
                case '\u02a3': 
                case '\u02a5': {
                    sb.append('d');
                    sb.append('z');
                    break;
                }
                case '\u00c8': 
                case '\u00c9': 
                case '\u00ca': 
                case '\u00cb': 
                case '\u0112': 
                case '\u0114': 
                case '\u0116': 
                case '\u0118': 
                case '\u011a': 
                case '\u018e': 
                case '\u0190': 
                case '\u0204': 
                case '\u0206': 
                case '\u0228': 
                case '\u0246': 
                case '\u1d07': 
                case '\u1e14': 
                case '\u1e16': 
                case '\u1e18': 
                case '\u1e1a': 
                case '\u1e1c': 
                case '\u1eb8': 
                case '\u1eba': 
                case '\u1ebc': 
                case '\u1ebe': 
                case '\u1ec0': 
                case '\u1ec2': 
                case '\u1ec4': 
                case '\u1ec6': 
                case '\u24ba': 
                case '\u2c7b': 
                case '\uff25': {
                    sb.append('E');
                    break;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': 
                case '\u00eb': 
                case '\u0113': 
                case '\u0115': 
                case '\u0117': 
                case '\u0119': 
                case '\u011b': 
                case '\u01dd': 
                case '\u0205': 
                case '\u0207': 
                case '\u0229': 
                case '\u0247': 
                case '\u0258': 
                case '\u025b': 
                case '\u025c': 
                case '\u025d': 
                case '\u025e': 
                case '\u029a': 
                case '\u1d08': 
                case '\u1d92': 
                case '\u1d93': 
                case '\u1d94': 
                case '\u1e15': 
                case '\u1e17': 
                case '\u1e19': 
                case '\u1e1b': 
                case '\u1e1d': 
                case '\u1eb9': 
                case '\u1ebb': 
                case '\u1ebd': 
                case '\u1ebf': 
                case '\u1ec1': 
                case '\u1ec3': 
                case '\u1ec5': 
                case '\u1ec7': 
                case '\u2091': 
                case '\u24d4': 
                case '\u2c78': 
                case '\uff45': {
                    sb.append('e');
                    break;
                }
                case '\u24a0': {
                    sb.append('(');
                    sb.append('e');
                    sb.append(')');
                    break;
                }
                case '\u0191': 
                case '\u1e1e': 
                case '\u24bb': 
                case '\ua730': 
                case '\ua77b': 
                case '\ua7fb': 
                case '\uff26': {
                    sb.append('F');
                    break;
                }
                case '\u0192': 
                case '\u1d6e': 
                case '\u1d82': 
                case '\u1e1f': 
                case '\u1e9b': 
                case '\u24d5': 
                case '\ua77c': 
                case '\uff46': {
                    sb.append('f');
                    break;
                }
                case '\u24a1': {
                    sb.append('(');
                    sb.append('f');
                    sb.append(')');
                    break;
                }
                case '\ufb00': {
                    sb.append('f');
                    sb.append('f');
                    break;
                }
                case '\ufb03': {
                    sb.append('f');
                    sb.append('f');
                    sb.append('i');
                    break;
                }
                case '\ufb04': {
                    sb.append('f');
                    sb.append('f');
                    sb.append('l');
                    break;
                }
                case '\ufb01': {
                    sb.append('f');
                    sb.append('i');
                    break;
                }
                case '\ufb02': {
                    sb.append('f');
                    sb.append('l');
                    break;
                }
                case '\u011c': 
                case '\u011e': 
                case '\u0120': 
                case '\u0122': 
                case '\u0193': 
                case '\u01e4': 
                case '\u01e5': 
                case '\u01e6': 
                case '\u01e7': 
                case '\u01f4': 
                case '\u0262': 
                case '\u029b': 
                case '\u1e20': 
                case '\u24bc': 
                case '\ua77d': 
                case '\ua77e': 
                case '\uff27': {
                    sb.append('G');
                    break;
                }
                case '\u011d': 
                case '\u011f': 
                case '\u0121': 
                case '\u0123': 
                case '\u01f5': 
                case '\u0260': 
                case '\u0261': 
                case '\u1d77': 
                case '\u1d79': 
                case '\u1d83': 
                case '\u1e21': 
                case '\u24d6': 
                case '\ua77f': 
                case '\uff47': {
                    sb.append('g');
                    break;
                }
                case '\u24a2': {
                    sb.append('(');
                    sb.append('g');
                    sb.append(')');
                    break;
                }
                case '\u0124': 
                case '\u0126': 
                case '\u021e': 
                case '\u029c': 
                case '\u1e22': 
                case '\u1e24': 
                case '\u1e26': 
                case '\u1e28': 
                case '\u1e2a': 
                case '\u24bd': 
                case '\u2c67': 
                case '\u2c75': 
                case '\uff28': {
                    sb.append('H');
                    break;
                }
                case '\u0125': 
                case '\u0127': 
                case '\u021f': 
                case '\u0265': 
                case '\u0266': 
                case '\u02ae': 
                case '\u02af': 
                case '\u1e23': 
                case '\u1e25': 
                case '\u1e27': 
                case '\u1e29': 
                case '\u1e2b': 
                case '\u1e96': 
                case '\u24d7': 
                case '\u2c68': 
                case '\u2c76': 
                case '\uff48': {
                    sb.append('h');
                    break;
                }
                case '\u01f6': {
                    sb.append('H');
                    sb.append('V');
                    break;
                }
                case '\u24a3': {
                    sb.append('(');
                    sb.append('h');
                    sb.append(')');
                    break;
                }
                case '\u0195': {
                    sb.append('h');
                    sb.append('v');
                    break;
                }
                case '\u00cc': 
                case '\u00cd': 
                case '\u00ce': 
                case '\u00cf': 
                case '\u0128': 
                case '\u012a': 
                case '\u012c': 
                case '\u012e': 
                case '\u0130': 
                case '\u0196': 
                case '\u0197': 
                case '\u01cf': 
                case '\u0208': 
                case '\u020a': 
                case '\u026a': 
                case '\u1d7b': 
                case '\u1e2c': 
                case '\u1e2e': 
                case '\u1ec8': 
                case '\u1eca': 
                case '\u24be': 
                case '\ua7fe': 
                case '\uff29': {
                    sb.append('I');
                    break;
                }
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ee': 
                case '\u00ef': 
                case '\u0129': 
                case '\u012b': 
                case '\u012d': 
                case '\u012f': 
                case '\u0131': 
                case '\u01d0': 
                case '\u0209': 
                case '\u020b': 
                case '\u0268': 
                case '\u1d09': 
                case '\u1d62': 
                case '\u1d7c': 
                case '\u1d96': 
                case '\u1e2d': 
                case '\u1e2f': 
                case '\u1ec9': 
                case '\u1ecb': 
                case '\u2071': 
                case '\u24d8': 
                case '\uff49': {
                    sb.append('i');
                    break;
                }
                case '\u0132': {
                    sb.append('I');
                    sb.append('J');
                    break;
                }
                case '\u24a4': {
                    sb.append('(');
                    sb.append('i');
                    sb.append(')');
                    break;
                }
                case '\u0133': {
                    sb.append('i');
                    sb.append('j');
                    break;
                }
                case '\u0134': 
                case '\u0248': 
                case '\u1d0a': 
                case '\u24bf': 
                case '\uff2a': {
                    sb.append('J');
                    break;
                }
                case '\u0135': 
                case '\u01f0': 
                case '\u0237': 
                case '\u0249': 
                case '\u025f': 
                case '\u0284': 
                case '\u029d': 
                case '\u24d9': 
                case '\u2c7c': 
                case '\uff4a': {
                    sb.append('j');
                    break;
                }
                case '\u24a5': {
                    sb.append('(');
                    sb.append('j');
                    sb.append(')');
                    break;
                }
                case '\u0136': 
                case '\u0198': 
                case '\u01e8': 
                case '\u1d0b': 
                case '\u1e30': 
                case '\u1e32': 
                case '\u1e34': 
                case '\u24c0': 
                case '\u2c69': 
                case '\ua740': 
                case '\ua742': 
                case '\ua744': 
                case '\uff2b': {
                    sb.append('K');
                    break;
                }
                case '\u0137': 
                case '\u0199': 
                case '\u01e9': 
                case '\u029e': 
                case '\u1d84': 
                case '\u1e31': 
                case '\u1e33': 
                case '\u1e35': 
                case '\u24da': 
                case '\u2c6a': 
                case '\ua741': 
                case '\ua743': 
                case '\ua745': 
                case '\uff4b': {
                    sb.append('k');
                    break;
                }
                case '\u24a6': {
                    sb.append('(');
                    sb.append('k');
                    sb.append(')');
                    break;
                }
                case '\u0139': 
                case '\u013b': 
                case '\u013d': 
                case '\u013f': 
                case '\u0141': 
                case '\u023d': 
                case '\u029f': 
                case '\u1d0c': 
                case '\u1e36': 
                case '\u1e38': 
                case '\u1e3a': 
                case '\u1e3c': 
                case '\u24c1': 
                case '\u2c60': 
                case '\u2c62': 
                case '\ua746': 
                case '\ua748': 
                case '\ua780': 
                case '\uff2c': {
                    sb.append('L');
                    break;
                }
                case '\u013a': 
                case '\u013c': 
                case '\u013e': 
                case '\u0140': 
                case '\u0142': 
                case '\u019a': 
                case '\u0234': 
                case '\u026b': 
                case '\u026c': 
                case '\u026d': 
                case '\u1d85': 
                case '\u1e37': 
                case '\u1e39': 
                case '\u1e3b': 
                case '\u1e3d': 
                case '\u24db': 
                case '\u2c61': 
                case '\ua747': 
                case '\ua749': 
                case '\ua781': 
                case '\uff4c': {
                    sb.append('l');
                    break;
                }
                case '\u01c7': {
                    sb.append('L');
                    sb.append('J');
                    break;
                }
                case '\u1efa': {
                    sb.append('L');
                    sb.append('L');
                    break;
                }
                case '\u01c8': {
                    sb.append('L');
                    sb.append('j');
                    break;
                }
                case '\u24a7': {
                    sb.append('(');
                    sb.append('l');
                    sb.append(')');
                    break;
                }
                case '\u01c9': {
                    sb.append('l');
                    sb.append('j');
                    break;
                }
                case '\u1efb': {
                    sb.append('l');
                    sb.append('l');
                    break;
                }
                case '\u02aa': {
                    sb.append('l');
                    sb.append('s');
                    break;
                }
                case '\u02ab': {
                    sb.append('l');
                    sb.append('z');
                    break;
                }
                case '\u019c': 
                case '\u1d0d': 
                case '\u1e3e': 
                case '\u1e40': 
                case '\u1e42': 
                case '\u24c2': 
                case '\u2c6e': 
                case '\ua7fd': 
                case '\ua7ff': 
                case '\uff2d': {
                    sb.append('M');
                    break;
                }
                case '\u026f': 
                case '\u0270': 
                case '\u0271': 
                case '\u1d6f': 
                case '\u1d86': 
                case '\u1e3f': 
                case '\u1e41': 
                case '\u1e43': 
                case '\u24dc': 
                case '\uff4d': {
                    sb.append('m');
                    break;
                }
                case '\u24a8': {
                    sb.append('(');
                    sb.append('m');
                    sb.append(')');
                    break;
                }
                case '\u00d1': 
                case '\u0143': 
                case '\u0145': 
                case '\u0147': 
                case '\u014a': 
                case '\u019d': 
                case '\u01f8': 
                case '\u0220': 
                case '\u0274': 
                case '\u1d0e': 
                case '\u1e44': 
                case '\u1e46': 
                case '\u1e48': 
                case '\u1e4a': 
                case '\u24c3': 
                case '\uff2e': {
                    sb.append('N');
                    break;
                }
                case '\u00f1': 
                case '\u0144': 
                case '\u0146': 
                case '\u0148': 
                case '\u0149': 
                case '\u014b': 
                case '\u019e': 
                case '\u01f9': 
                case '\u0235': 
                case '\u0272': 
                case '\u0273': 
                case '\u1d70': 
                case '\u1d87': 
                case '\u1e45': 
                case '\u1e47': 
                case '\u1e49': 
                case '\u1e4b': 
                case '\u207f': 
                case '\u24dd': 
                case '\uff4e': {
                    sb.append('n');
                    break;
                }
                case '\u01ca': {
                    sb.append('N');
                    sb.append('J');
                    break;
                }
                case '\u01cb': {
                    sb.append('N');
                    sb.append('j');
                    break;
                }
                case '\u24a9': {
                    sb.append('(');
                    sb.append('n');
                    sb.append(')');
                    break;
                }
                case '\u01cc': {
                    sb.append('n');
                    sb.append('j');
                    break;
                }
                case '\u00d2': 
                case '\u00d3': 
                case '\u00d4': 
                case '\u00d5': 
                case '\u00d6': 
                case '\u00d8': 
                case '\u014c': 
                case '\u014e': 
                case '\u0150': 
                case '\u0186': 
                case '\u019f': 
                case '\u01a0': 
                case '\u01d1': 
                case '\u01ea': 
                case '\u01ec': 
                case '\u01fe': 
                case '\u020c': 
                case '\u020e': 
                case '\u022a': 
                case '\u022c': 
                case '\u022e': 
                case '\u0230': 
                case '\u1d0f': 
                case '\u1d10': 
                case '\u1e4c': 
                case '\u1e4e': 
                case '\u1e50': 
                case '\u1e52': 
                case '\u1ecc': 
                case '\u1ece': 
                case '\u1ed0': 
                case '\u1ed2': 
                case '\u1ed4': 
                case '\u1ed6': 
                case '\u1ed8': 
                case '\u1eda': 
                case '\u1edc': 
                case '\u1ede': 
                case '\u1ee0': 
                case '\u1ee2': 
                case '\u24c4': 
                case '\ua74a': 
                case '\ua74c': 
                case '\uff2f': {
                    sb.append('O');
                    break;
                }
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': 
                case '\u00f5': 
                case '\u00f6': 
                case '\u00f8': 
                case '\u014d': 
                case '\u014f': 
                case '\u0151': 
                case '\u01a1': 
                case '\u01d2': 
                case '\u01eb': 
                case '\u01ed': 
                case '\u01ff': 
                case '\u020d': 
                case '\u020f': 
                case '\u022b': 
                case '\u022d': 
                case '\u022f': 
                case '\u0231': 
                case '\u0254': 
                case '\u0275': 
                case '\u1d16': 
                case '\u1d17': 
                case '\u1d97': 
                case '\u1e4d': 
                case '\u1e4f': 
                case '\u1e51': 
                case '\u1e53': 
                case '\u1ecd': 
                case '\u1ecf': 
                case '\u1ed1': 
                case '\u1ed3': 
                case '\u1ed5': 
                case '\u1ed7': 
                case '\u1ed9': 
                case '\u1edb': 
                case '\u1edd': 
                case '\u1edf': 
                case '\u1ee1': 
                case '\u1ee3': 
                case '\u2092': 
                case '\u24de': 
                case '\u2c7a': 
                case '\ua74b': 
                case '\ua74d': 
                case '\uff4f': {
                    sb.append('o');
                    break;
                }
                case '\u0152': 
                case '\u0276': {
                    sb.append('O');
                    sb.append('E');
                    break;
                }
                case '\ua74e': {
                    sb.append('O');
                    sb.append('O');
                    break;
                }
                case '\u0222': 
                case '\u1d15': {
                    sb.append('O');
                    sb.append('U');
                    break;
                }
                case '\u24aa': {
                    sb.append('(');
                    sb.append('o');
                    sb.append(')');
                    break;
                }
                case '\u0153': 
                case '\u1d14': {
                    sb.append('o');
                    sb.append('e');
                    break;
                }
                case '\ua74f': {
                    sb.append('o');
                    sb.append('o');
                    break;
                }
                case '\u0223': {
                    sb.append('o');
                    sb.append('u');
                    break;
                }
                case '\u01a4': 
                case '\u1d18': 
                case '\u1e54': 
                case '\u1e56': 
                case '\u24c5': 
                case '\u2c63': 
                case '\ua750': 
                case '\ua752': 
                case '\ua754': 
                case '\uff30': {
                    sb.append('P');
                    break;
                }
                case '\u01a5': 
                case '\u1d71': 
                case '\u1d7d': 
                case '\u1d88': 
                case '\u1e55': 
                case '\u1e57': 
                case '\u24df': 
                case '\ua751': 
                case '\ua753': 
                case '\ua755': 
                case '\ua7fc': 
                case '\uff50': {
                    sb.append('p');
                    break;
                }
                case '\u24ab': {
                    sb.append('(');
                    sb.append('p');
                    sb.append(')');
                    break;
                }
                case '\u024a': 
                case '\u24c6': 
                case '\ua756': 
                case '\ua758': 
                case '\uff31': {
                    sb.append('Q');
                    break;
                }
                case '\u0138': 
                case '\u024b': 
                case '\u02a0': 
                case '\u24e0': 
                case '\ua757': 
                case '\ua759': 
                case '\uff51': {
                    sb.append('q');
                    break;
                }
                case '\u24ac': {
                    sb.append('(');
                    sb.append('q');
                    sb.append(')');
                    break;
                }
                case '\u0239': {
                    sb.append('q');
                    sb.append('p');
                    break;
                }
                case '\u0154': 
                case '\u0156': 
                case '\u0158': 
                case '\u0210': 
                case '\u0212': 
                case '\u024c': 
                case '\u0280': 
                case '\u0281': 
                case '\u1d19': 
                case '\u1d1a': 
                case '\u1e58': 
                case '\u1e5a': 
                case '\u1e5c': 
                case '\u1e5e': 
                case '\u24c7': 
                case '\u2c64': 
                case '\ua75a': 
                case '\ua782': 
                case '\uff32': {
                    sb.append('R');
                    break;
                }
                case '\u0155': 
                case '\u0157': 
                case '\u0159': 
                case '\u0211': 
                case '\u0213': 
                case '\u024d': 
                case '\u027c': 
                case '\u027d': 
                case '\u027e': 
                case '\u027f': 
                case '\u1d63': 
                case '\u1d72': 
                case '\u1d73': 
                case '\u1d89': 
                case '\u1e59': 
                case '\u1e5b': 
                case '\u1e5d': 
                case '\u1e5f': 
                case '\u24e1': 
                case '\ua75b': 
                case '\ua783': 
                case '\uff52': {
                    sb.append('r');
                    break;
                }
                case '\u24ad': {
                    sb.append('(');
                    sb.append('r');
                    sb.append(')');
                    break;
                }
                case '\u015a': 
                case '\u015c': 
                case '\u015e': 
                case '\u0160': 
                case '\u0218': 
                case '\u1e60': 
                case '\u1e62': 
                case '\u1e64': 
                case '\u1e66': 
                case '\u1e68': 
                case '\u24c8': 
                case '\ua731': 
                case '\ua785': 
                case '\uff33': {
                    sb.append('S');
                    break;
                }
                case '\u015b': 
                case '\u015d': 
                case '\u015f': 
                case '\u0161': 
                case '\u017f': 
                case '\u0219': 
                case '\u023f': 
                case '\u0282': 
                case '\u1d74': 
                case '\u1d8a': 
                case '\u1e61': 
                case '\u1e63': 
                case '\u1e65': 
                case '\u1e67': 
                case '\u1e69': 
                case '\u1e9c': 
                case '\u1e9d': 
                case '\u24e2': 
                case '\ua784': 
                case '\uff53': {
                    sb.append('s');
                    break;
                }
                case '\u1e9e': {
                    sb.append('S');
                    sb.append('S');
                    break;
                }
                case '\u24ae': {
                    sb.append('(');
                    sb.append('s');
                    sb.append(')');
                    break;
                }
                case '\u00df': {
                    sb.append('s');
                    sb.append('s');
                    break;
                }
                case '\ufb06': {
                    sb.append('s');
                    sb.append('t');
                    break;
                }
                case '\u0162': 
                case '\u0164': 
                case '\u0166': 
                case '\u01ac': 
                case '\u01ae': 
                case '\u021a': 
                case '\u023e': 
                case '\u1d1b': 
                case '\u1e6a': 
                case '\u1e6c': 
                case '\u1e6e': 
                case '\u1e70': 
                case '\u24c9': 
                case '\ua786': 
                case '\uff34': {
                    sb.append('T');
                    break;
                }
                case '\u0163': 
                case '\u0165': 
                case '\u0167': 
                case '\u01ab': 
                case '\u01ad': 
                case '\u021b': 
                case '\u0236': 
                case '\u0287': 
                case '\u0288': 
                case '\u1d75': 
                case '\u1e6b': 
                case '\u1e6d': 
                case '\u1e6f': 
                case '\u1e71': 
                case '\u1e97': 
                case '\u24e3': 
                case '\u2c66': 
                case '\uff54': {
                    sb.append('t');
                    break;
                }
                case '\u00de': 
                case '\ua766': {
                    sb.append('T');
                    sb.append('H');
                    break;
                }
                case '\ua728': {
                    sb.append('T');
                    sb.append('Z');
                    break;
                }
                case '\u24af': {
                    sb.append('(');
                    sb.append('t');
                    sb.append(')');
                    break;
                }
                case '\u02a8': {
                    sb.append('t');
                    sb.append('c');
                    break;
                }
                case '\u00fe': 
                case '\u1d7a': 
                case '\ua767': {
                    sb.append('t');
                    sb.append('h');
                    break;
                }
                case '\u02a6': {
                    sb.append('t');
                    sb.append('s');
                    break;
                }
                case '\ua729': {
                    sb.append('t');
                    sb.append('z');
                    break;
                }
                case '\u00d9': 
                case '\u00da': 
                case '\u00db': 
                case '\u00dc': 
                case '\u0168': 
                case '\u016a': 
                case '\u016c': 
                case '\u016e': 
                case '\u0170': 
                case '\u0172': 
                case '\u01af': 
                case '\u01d3': 
                case '\u01d5': 
                case '\u01d7': 
                case '\u01d9': 
                case '\u01db': 
                case '\u0214': 
                case '\u0216': 
                case '\u0244': 
                case '\u1d1c': 
                case '\u1d7e': 
                case '\u1e72': 
                case '\u1e74': 
                case '\u1e76': 
                case '\u1e78': 
                case '\u1e7a': 
                case '\u1ee4': 
                case '\u1ee6': 
                case '\u1ee8': 
                case '\u1eea': 
                case '\u1eec': 
                case '\u1eee': 
                case '\u1ef0': 
                case '\u24ca': 
                case '\uff35': {
                    sb.append('U');
                    break;
                }
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fb': 
                case '\u00fc': 
                case '\u0169': 
                case '\u016b': 
                case '\u016d': 
                case '\u016f': 
                case '\u0171': 
                case '\u0173': 
                case '\u01b0': 
                case '\u01d4': 
                case '\u01d6': 
                case '\u01d8': 
                case '\u01da': 
                case '\u01dc': 
                case '\u0215': 
                case '\u0217': 
                case '\u0289': 
                case '\u1d64': 
                case '\u1d99': 
                case '\u1e73': 
                case '\u1e75': 
                case '\u1e77': 
                case '\u1e79': 
                case '\u1e7b': 
                case '\u1ee5': 
                case '\u1ee7': 
                case '\u1ee9': 
                case '\u1eeb': 
                case '\u1eed': 
                case '\u1eef': 
                case '\u1ef1': 
                case '\u24e4': 
                case '\uff55': {
                    sb.append('u');
                    break;
                }
                case '\u24b0': {
                    sb.append('(');
                    sb.append('u');
                    sb.append(')');
                    break;
                }
                case '\u1d6b': {
                    sb.append('u');
                    sb.append('e');
                    break;
                }
                case '\u01b2': 
                case '\u0245': 
                case '\u1d20': 
                case '\u1e7c': 
                case '\u1e7e': 
                case '\u1efc': 
                case '\u24cb': 
                case '\ua75e': 
                case '\ua768': 
                case '\uff36': {
                    sb.append('V');
                    break;
                }
                case '\u028b': 
                case '\u028c': 
                case '\u1d65': 
                case '\u1d8c': 
                case '\u1e7d': 
                case '\u1e7f': 
                case '\u24e5': 
                case '\u2c71': 
                case '\u2c74': 
                case '\ua75f': 
                case '\uff56': {
                    sb.append('v');
                    break;
                }
                case '\ua760': {
                    sb.append('V');
                    sb.append('Y');
                    break;
                }
                case '\u24b1': {
                    sb.append('(');
                    sb.append('v');
                    sb.append(')');
                    break;
                }
                case '\ua761': {
                    sb.append('v');
                    sb.append('y');
                    break;
                }
                case '\u0174': 
                case '\u01f7': 
                case '\u1d21': 
                case '\u1e80': 
                case '\u1e82': 
                case '\u1e84': 
                case '\u1e86': 
                case '\u1e88': 
                case '\u24cc': 
                case '\u2c72': 
                case '\uff37': {
                    sb.append('W');
                    break;
                }
                case '\u0175': 
                case '\u01bf': 
                case '\u028d': 
                case '\u1e81': 
                case '\u1e83': 
                case '\u1e85': 
                case '\u1e87': 
                case '\u1e89': 
                case '\u1e98': 
                case '\u24e6': 
                case '\u2c73': 
                case '\uff57': {
                    sb.append('w');
                    break;
                }
                case '\u24b2': {
                    sb.append('(');
                    sb.append('w');
                    sb.append(')');
                    break;
                }
                case '\u1e8a': 
                case '\u1e8c': 
                case '\u24cd': 
                case '\uff38': {
                    sb.append('X');
                    break;
                }
                case '\u1d8d': 
                case '\u1e8b': 
                case '\u1e8d': 
                case '\u2093': 
                case '\u24e7': 
                case '\uff58': {
                    sb.append('x');
                    break;
                }
                case '\u24b3': {
                    sb.append('(');
                    sb.append('x');
                    sb.append(')');
                    break;
                }
                case '\u00dd': 
                case '\u0176': 
                case '\u0178': 
                case '\u01b3': 
                case '\u0232': 
                case '\u024e': 
                case '\u028f': 
                case '\u1e8e': 
                case '\u1ef2': 
                case '\u1ef4': 
                case '\u1ef6': 
                case '\u1ef8': 
                case '\u1efe': 
                case '\u24ce': 
                case '\uff39': {
                    sb.append('Y');
                    break;
                }
                case '\u00fd': 
                case '\u00ff': 
                case '\u0177': 
                case '\u01b4': 
                case '\u0233': 
                case '\u024f': 
                case '\u028e': 
                case '\u1e8f': 
                case '\u1e99': 
                case '\u1ef3': 
                case '\u1ef5': 
                case '\u1ef7': 
                case '\u1ef9': 
                case '\u1eff': 
                case '\u24e8': 
                case '\uff59': {
                    sb.append('y');
                    break;
                }
                case '\u24b4': {
                    sb.append('(');
                    sb.append('y');
                    sb.append(')');
                    break;
                }
                case '\u0179': 
                case '\u017b': 
                case '\u017d': 
                case '\u01b5': 
                case '\u021c': 
                case '\u0224': 
                case '\u1d22': 
                case '\u1e90': 
                case '\u1e92': 
                case '\u1e94': 
                case '\u24cf': 
                case '\u2c6b': 
                case '\ua762': 
                case '\uff3a': {
                    sb.append('Z');
                    break;
                }
                case '\u017a': 
                case '\u017c': 
                case '\u017e': 
                case '\u01b6': 
                case '\u021d': 
                case '\u0225': 
                case '\u0240': 
                case '\u0290': 
                case '\u0291': 
                case '\u1d76': 
                case '\u1d8e': 
                case '\u1e91': 
                case '\u1e93': 
                case '\u1e95': 
                case '\u24e9': 
                case '\u2c6c': 
                case '\ua763': 
                case '\uff5a': {
                    sb.append('z');
                    break;
                }
                case '\u24b5': {
                    sb.append('(');
                    sb.append('z');
                    sb.append(')');
                    break;
                }
                case '\u2070': 
                case '\u2080': 
                case '\u24ea': 
                case '\u24ff': 
                case '\uff10': {
                    sb.append('0');
                    break;
                }
                case '\u00b9': 
                case '\u2081': 
                case '\u2460': 
                case '\u24f5': 
                case '\u2776': 
                case '\u2780': 
                case '\u278a': 
                case '\uff11': {
                    sb.append('1');
                    break;
                }
                case '\u2488': {
                    sb.append('1');
                    sb.append('.');
                    break;
                }
                case '\u2474': {
                    sb.append('(');
                    sb.append('1');
                    sb.append(')');
                    break;
                }
                case '\u00b2': 
                case '\u2082': 
                case '\u2461': 
                case '\u24f6': 
                case '\u2777': 
                case '\u2781': 
                case '\u278b': 
                case '\uff12': {
                    sb.append('2');
                    break;
                }
                case '\u2489': {
                    sb.append('2');
                    sb.append('.');
                    break;
                }
                case '\u2475': {
                    sb.append('(');
                    sb.append('2');
                    sb.append(')');
                    break;
                }
                case '\u00b3': 
                case '\u2083': 
                case '\u2462': 
                case '\u24f7': 
                case '\u2778': 
                case '\u2782': 
                case '\u278c': 
                case '\uff13': {
                    sb.append('3');
                    break;
                }
                case '\u248a': {
                    sb.append('3');
                    sb.append('.');
                    break;
                }
                case '\u2476': {
                    sb.append('(');
                    sb.append('3');
                    sb.append(')');
                    break;
                }
                case '\u2074': 
                case '\u2084': 
                case '\u2463': 
                case '\u24f8': 
                case '\u2779': 
                case '\u2783': 
                case '\u278d': 
                case '\uff14': {
                    sb.append('4');
                    break;
                }
                case '\u248b': {
                    sb.append('4');
                    sb.append('.');
                    break;
                }
                case '\u2477': {
                    sb.append('(');
                    sb.append('4');
                    sb.append(')');
                    break;
                }
                case '\u2075': 
                case '\u2085': 
                case '\u2464': 
                case '\u24f9': 
                case '\u277a': 
                case '\u2784': 
                case '\u278e': 
                case '\uff15': {
                    sb.append('5');
                    break;
                }
                case '\u248c': {
                    sb.append('5');
                    sb.append('.');
                    break;
                }
                case '\u2478': {
                    sb.append('(');
                    sb.append('5');
                    sb.append(')');
                    break;
                }
                case '\u2076': 
                case '\u2086': 
                case '\u2465': 
                case '\u24fa': 
                case '\u277b': 
                case '\u2785': 
                case '\u278f': 
                case '\uff16': {
                    sb.append('6');
                    break;
                }
                case '\u248d': {
                    sb.append('6');
                    sb.append('.');
                    break;
                }
                case '\u2479': {
                    sb.append('(');
                    sb.append('6');
                    sb.append(')');
                    break;
                }
                case '\u2077': 
                case '\u2087': 
                case '\u2466': 
                case '\u24fb': 
                case '\u277c': 
                case '\u2786': 
                case '\u2790': 
                case '\uff17': {
                    sb.append('7');
                    break;
                }
                case '\u248e': {
                    sb.append('7');
                    sb.append('.');
                    break;
                }
                case '\u247a': {
                    sb.append('(');
                    sb.append('7');
                    sb.append(')');
                    break;
                }
                case '\u2078': 
                case '\u2088': 
                case '\u2467': 
                case '\u24fc': 
                case '\u277d': 
                case '\u2787': 
                case '\u2791': 
                case '\uff18': {
                    sb.append('8');
                    break;
                }
                case '\u248f': {
                    sb.append('8');
                    sb.append('.');
                    break;
                }
                case '\u247b': {
                    sb.append('(');
                    sb.append('8');
                    sb.append(')');
                    break;
                }
                case '\u2079': 
                case '\u2089': 
                case '\u2468': 
                case '\u24fd': 
                case '\u277e': 
                case '\u2788': 
                case '\u2792': 
                case '\uff19': {
                    sb.append('9');
                    break;
                }
                case '\u2490': {
                    sb.append('9');
                    sb.append('.');
                    break;
                }
                case '\u247c': {
                    sb.append('(');
                    sb.append('9');
                    sb.append(')');
                    break;
                }
                case '\u2469': 
                case '\u24fe': 
                case '\u277f': 
                case '\u2789': 
                case '\u2793': {
                    sb.append('1');
                    sb.append('0');
                    break;
                }
                case '\u2491': {
                    sb.append('1');
                    sb.append('0');
                    sb.append('.');
                    break;
                }
                case '\u247d': {
                    sb.append('(');
                    sb.append('1');
                    sb.append('0');
                    sb.append(')');
                    break;
                }
                case '\u246a': 
                case '\u24eb': {
                    sb.append('1');
                    sb.append('1');
                    break;
                }
                case '\u2492': {
                    sb.append('1');
                    sb.append('1');
                    sb.append('.');
                    break;
                }
                case '\u247e': {
                    sb.append('(');
                    sb.append('1');
                    sb.append('1');
                    sb.append(')');
                    break;
                }
                case '\u246b': 
                case '\u24ec': {
                    sb.append('1');
                    sb.append('2');
                    break;
                }
                case '\u2493': {
                    sb.append('1');
                    sb.append('2');
                    sb.append('.');
                    break;
                }
                case '\u247f': {
                    sb.append('(');
                    sb.append('1');
                    sb.append('2');
                    sb.append(')');
                    break;
                }
                case '\u246c': 
                case '\u24ed': {
                    sb.append('1');
                    sb.append('3');
                    break;
                }
                case '\u2494': {
                    sb.append('1');
                    sb.append('3');
                    sb.append('.');
                    break;
                }
                case '\u2480': {
                    sb.append('(');
                    sb.append('1');
                    sb.append('3');
                    sb.append(')');
                    break;
                }
                case '\u246d': 
                case '\u24ee': {
                    sb.append('1');
                    sb.append('4');
                    break;
                }
                case '\u2495': {
                    sb.append('1');
                    sb.append('4');
                    sb.append('.');
                    break;
                }
                case '\u2481': {
                    sb.append('(');
                    sb.append('1');
                    sb.append('4');
                    sb.append(')');
                    break;
                }
                case '\u246e': 
                case '\u24ef': {
                    sb.append('1');
                    sb.append('5');
                    break;
                }
                case '\u2496': {
                    sb.append('1');
                    sb.append('5');
                    sb.append('.');
                    break;
                }
                case '\u2482': {
                    sb.append('(');
                    sb.append('1');
                    sb.append('5');
                    sb.append(')');
                    break;
                }
                case '\u246f': 
                case '\u24f0': {
                    sb.append('1');
                    sb.append('6');
                    break;
                }
                case '\u2497': {
                    sb.append('1');
                    sb.append('6');
                    sb.append('.');
                    break;
                }
                case '\u2483': {
                    sb.append('(');
                    sb.append('1');
                    sb.append('6');
                    sb.append(')');
                    break;
                }
                case '\u2470': 
                case '\u24f1': {
                    sb.append('1');
                    sb.append('7');
                    break;
                }
                case '\u2498': {
                    sb.append('1');
                    sb.append('7');
                    sb.append('.');
                    break;
                }
                case '\u2484': {
                    sb.append('(');
                    sb.append('1');
                    sb.append('7');
                    sb.append(')');
                    break;
                }
                case '\u2471': 
                case '\u24f2': {
                    sb.append('1');
                    sb.append('8');
                    break;
                }
                case '\u2499': {
                    sb.append('1');
                    sb.append('8');
                    sb.append('.');
                    break;
                }
                case '\u2485': {
                    sb.append('(');
                    sb.append('1');
                    sb.append('8');
                    sb.append(')');
                    break;
                }
                case '\u2472': 
                case '\u24f3': {
                    sb.append('1');
                    sb.append('9');
                    break;
                }
                case '\u249a': {
                    sb.append('1');
                    sb.append('9');
                    sb.append('.');
                    break;
                }
                case '\u2486': {
                    sb.append('(');
                    sb.append('1');
                    sb.append('9');
                    sb.append(')');
                    break;
                }
                case '\u2473': 
                case '\u24f4': {
                    sb.append('2');
                    sb.append('0');
                    break;
                }
                case '\u249b': {
                    sb.append('2');
                    sb.append('0');
                    sb.append('.');
                    break;
                }
                case '\u2487': {
                    sb.append('(');
                    sb.append('2');
                    sb.append('0');
                    sb.append(')');
                    break;
                }
                case '\u00ab': 
                case '\u00bb': 
                case '\u201c': 
                case '\u201d': 
                case '\u201e': 
                case '\u2033': 
                case '\u2036': 
                case '\u275d': 
                case '\u275e': 
                case '\u276e': 
                case '\u276f': 
                case '\uff02': {
                    sb.append('\"');
                    break;
                }
                case '\u2018': 
                case '\u2019': 
                case '\u201a': 
                case '\u201b': 
                case '\u2032': 
                case '\u2035': 
                case '\u2039': 
                case '\u203a': 
                case '\u275b': 
                case '\u275c': 
                case '\uff07': {
                    sb.append('\'');
                    break;
                }
                case '\u2010': 
                case '\u2011': 
                case '\u2012': 
                case '\u2013': 
                case '\u2014': 
                case '\u207b': 
                case '\u208b': 
                case '\uff0d': {
                    sb.append('-');
                    break;
                }
                case '\u2045': 
                case '\u2772': 
                case '\uff3b': {
                    sb.append('[');
                    break;
                }
                case '\u2046': 
                case '\u2773': 
                case '\uff3d': {
                    sb.append(']');
                    break;
                }
                case '\u207d': 
                case '\u208d': 
                case '\u2768': 
                case '\u276a': 
                case '\uff08': {
                    sb.append('(');
                    break;
                }
                case '\u2e28': {
                    sb.append('(');
                    sb.append('(');
                    break;
                }
                case '\u207e': 
                case '\u208e': 
                case '\u2769': 
                case '\u276b': 
                case '\uff09': {
                    sb.append(')');
                    break;
                }
                case '\u2e29': {
                    sb.append(')');
                    sb.append(')');
                    break;
                }
                case '\u276c': 
                case '\u2770': 
                case '\uff1c': {
                    sb.append('<');
                    break;
                }
                case '\u276d': 
                case '\u2771': 
                case '\uff1e': {
                    sb.append('>');
                    break;
                }
                case '\u2774': 
                case '\uff5b': {
                    sb.append('{');
                    break;
                }
                case '\u2775': 
                case '\uff5d': {
                    sb.append('}');
                    break;
                }
                case '\u207a': 
                case '\u208a': 
                case '\uff0b': {
                    sb.append('+');
                    break;
                }
                case '\u207c': 
                case '\u208c': 
                case '\uff1d': {
                    sb.append('=');
                    break;
                }
                case '\uff01': {
                    sb.append('!');
                    break;
                }
                case '\u203c': {
                    sb.append('!');
                    sb.append('!');
                    break;
                }
                case '\u2049': {
                    sb.append('!');
                    sb.append('?');
                    break;
                }
                case '\uff03': {
                    sb.append('#');
                    break;
                }
                case '\uff04': {
                    sb.append('$');
                    break;
                }
                case '\u2052': 
                case '\uff05': {
                    sb.append('%');
                    break;
                }
                case '\uff06': {
                    sb.append('&');
                    break;
                }
                case '\u204e': 
                case '\uff0a': {
                    sb.append('*');
                    break;
                }
                case '\uff0c': {
                    sb.append(',');
                    break;
                }
                case '\uff0e': {
                    sb.append('.');
                    break;
                }
                case '\u2044': 
                case '\uff0f': {
                    sb.append('/');
                    break;
                }
                case '\uff1a': {
                    sb.append(':');
                    break;
                }
                case '\u204f': 
                case '\uff1b': {
                    sb.append(';');
                    break;
                }
                case '\uff1f': {
                    sb.append('?');
                    break;
                }
                case '\u2047': {
                    sb.append('?');
                    sb.append('?');
                    break;
                }
                case '\u2048': {
                    sb.append('?');
                    sb.append('!');
                    break;
                }
                case '\uff20': {
                    sb.append('@');
                    break;
                }
                case '\uff3c': {
                    sb.append('\\');
                    break;
                }
                case '\u2038': 
                case '\uff3e': {
                    sb.append('^');
                    break;
                }
                case '\uff3f': {
                    sb.append('_');
                    break;
                }
                case '\u2053': 
                case '\uff5e': {
                    sb.append('~');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }
}

