/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.CharRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class ExportUtil$
implements Tool {
    public static final ExportUtil$ MODULE$;
    private final Logger logger;

    static {
        new ExportUtil$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "export";
    }

    @Override
    public String desc() {
        return "Export data as CSV or JSON";
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public void main(String[] args) {
        ObjectRef fieldsToExport = new ObjectRef((Object)Nil$.MODULE$);
        ObjectRef fieldsRequired = new ObjectRef((Object)Nil$.MODULE$);
        BooleanRef includeRowKey = new BooleanRef(false);
        CharRef charSeparator = new CharRef('\t');
        ObjectRef entity = new ObjectRef((Object)"");
        ObjectRef filePath = new ObjectRef((Object)"");
        ObjectRef startkey = new ObjectRef((Object)"");
        ObjectRef endkey = new ObjectRef((Object)"");
        BooleanRef distinct = new BooleanRef(false);
        BooleanRef json = new BooleanRef(false);
        IntRef maxRecords = new IntRef(Integer.MAX_VALUE);
        OptionParser parser = new OptionParser(fieldsToExport, fieldsRequired, includeRowKey, charSeparator, entity, filePath, startkey, endkey, distinct, json, maxRecords){
            {
                this.arg("entity", "the entity (column family in cassandra) to export from. e.g. occ", (Function1<String, BoxedUnit>)new Serializable(this, entity$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef entity$1;

                    public final void apply(String v) {
                        this.entity$1.elem = v;
                    }
                    {
                        this.entity$1 = entity$1;
                    }
                });
                this.arg("file-path", "file to export to", (Function1<String, BoxedUnit>)new Serializable(this, filePath$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef filePath$1;

                    public final void apply(String v) {
                        this.filePath$1.elem = v;
                    }
                    {
                        this.filePath$1 = filePath$1;
                    }
                });
                this.opt("c", "columns", "<column1 column2 ...>", "space separated list of columns to export", (Function1<String, BoxedUnit>)new Serializable(this, fieldsToExport$2){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef fieldsToExport$2;

                    public final void apply(String columns) {
                        this.fieldsToExport$2.elem = Predef$.MODULE$.refArrayOps((Object[])columns.split(" ")).toList();
                    }
                    {
                        this.fieldsToExport$2 = fieldsToExport$2;
                    }
                });
                this.opt("r", "required-columns", "<column1 column2 ...>", "space separated required columns", (Function1<String, BoxedUnit>)new Serializable(this, fieldsRequired$2){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef fieldsRequired$2;

                    public final void apply(String columns) {
                        this.fieldsRequired$2.elem = Predef$.MODULE$.refArrayOps((Object[])columns.split(" ")).toList();
                    }
                    {
                        this.fieldsRequired$2 = fieldsRequired$2;
                    }
                });
                this.opt("rk", "include-rowkey", "Include the row key in the export", (Function0<BoxedUnit>)new Serializable(this, includeRowKey$2){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef includeRowKey$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.includeRowKey$2.elem = true;
                    }
                    {
                        this.includeRowKey$2 = includeRowKey$2;
                    }
                });
                this.opt("sc", "separator-char", "Separator char to use. Defaults to tab", (Function1<String, BoxedUnit>)new Serializable(this, charSeparator$1){
                    public static final long serialVersionUID = 0L;
                    private final CharRef charSeparator$1;

                    public final void apply(String s) {
                        this.charSeparator$1.elem = s.trim().charAt(0);
                    }
                    {
                        this.charSeparator$1 = charSeparator$1;
                    }
                });
                this.opt("s", "start", "The row key to start with", (Function1<String, BoxedUnit>)new Serializable(this, startkey$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startkey$1;

                    public final void apply(String s) {
                        this.startkey$1.elem = s;
                    }
                    {
                        this.startkey$1 = startkey$1;
                    }
                });
                this.opt("e", "end", "The row key to end with", (Function1<String, BoxedUnit>)new Serializable(this, endkey$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef endkey$1;

                    public final void apply(String s) {
                        this.endkey$1.elem = s;
                    }
                    {
                        this.endkey$1 = endkey$1;
                    }
                });
                this.opt("distinct", "distinct values for the columns only", (Function0<BoxedUnit>)new Serializable(this, distinct$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef distinct$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.distinct$1.elem = true;
                    }
                    {
                        this.distinct$1 = distinct$1;
                    }
                });
                this.opt("json", "export the values as json", (Function0<BoxedUnit>)new Serializable(this, json$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef json$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.json$1.elem = true;
                    }
                    {
                        this.json$1 = json$1;
                    }
                });
                this.intOpt("m", "max-records", "number of records to export", (Function1<Object, BoxedUnit>)new Serializable(this, maxRecords$2){
                    public static final long serialVersionUID = 0L;
                    private final IntRef maxRecords$2;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.maxRecords$2.elem = v;
                    }
                    {
                        this.maxRecords$2 = maxRecords$2;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            FileWriter outWriter = new FileWriter(new File((String)filePath.elem));
            CSVWriter writer = new CSVWriter((Writer)outWriter, charSeparator.elem, '\"');
            if (json.elem) {
                this.exportJson(outWriter, (String)entity.elem, (String)startkey.elem, (String)endkey.elem, maxRecords.elem);
            } else if (distinct.elem) {
                this.exportDistinct(writer, (String)entity.elem, (List<String>)((List)fieldsToExport.elem), (String)startkey.elem, (String)endkey.elem);
            } else {
                this.export(writer, (String)entity.elem, (List<String>)((List)fieldsToExport.elem), (List<String>)((List)fieldsRequired.elem), (List<String>)Nil$.MODULE$, (Option<Map<String, String>>)None$.MODULE$, (String)startkey.elem, (String)endkey.elem, maxRecords.elem, false, includeRowKey.elem);
            }
            writer.flush();
            writer.close();
        }
    }

    public void exportJson(FileWriter writer, String entity, String startKey, String endKey, int maxRecords) {
        PersistenceManager pm = Config$.MODULE$.persistenceManager();
        IntRef counter = new IntRef(0);
        pm.pageOverAll(entity, (Function2<String, Map<String, String>, Object>)new Serializable(writer, entity, maxRecords, counter){
            public static final long serialVersionUID = 0L;
            private final FileWriter writer$2;
            private final String entity$2;
            private final int maxRecords$3;
            private final IntRef counter$1;

            public final boolean apply(String guid, Map<String, String> map) {
                Map finalMap = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new StringBuilder().append((Object)this.entity$2).append((Object)"rowKey").toString()), (Object)guid));
                this.writer$2.write(Json$.MODULE$.toJSON((Map<String, Object>)finalMap));
                this.writer$2.write("\n");
                ++this.counter$1.elem;
                return this.maxRecords$3 > this.counter$1.elem;
            }
            {
                this.writer$2 = writer$2;
                this.entity$2 = entity$2;
                this.maxRecords$3 = maxRecords$3;
                this.counter$1 = counter$1;
            }
        }, startKey, endKey, 1000);
        writer.flush();
        writer.close();
    }

    public void exportDistinct(CSVWriter writer, String entity, List<String> fieldsToExport, String startUuid, String endUuid) {
        PersistenceManager pm = Config$.MODULE$.persistenceManager();
        HashSet valueSet = new HashSet();
        pm.pageOverSelect(entity, (Function2<String, Map<String, String>, Object>)new Serializable(writer, fieldsToExport, valueSet){
            public static final long serialVersionUID = 0L;
            private final CSVWriter writer$3;
            private final List fieldsToExport$3;
            private final HashSet valueSet$1;

            public final boolean apply(String guid, Map<String, String> map) {
                List line = (List)this.fieldsToExport$3.map((Function1)new Serializable(this, map){
                    public static final long serialVersionUID = 0L;
                    private final Map map$1;

                    public final String apply(String field) {
                        return (String)this.map$1.getOrElse((Object)field, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        });
                    }
                    {
                        this.map$1 = map$1;
                    }
                }, List$.MODULE$.canBuildFrom());
                String sline = line.mkString(",");
                if (!this.valueSet$1.contains((Object)sline)) {
                    this.valueSet$1.$plus$eq((Object)sline);
                    this.writer$3.writeNext((String[])line.toArray(ClassTag$.MODULE$.apply(String.class)));
                }
                return true;
            }
            {
                this.writer$3 = writer$3;
                this.fieldsToExport$3 = fieldsToExport$3;
                this.valueSet$1 = valueSet$1;
            }
        }, startUuid, endUuid, 1000, (Seq<String>)fieldsToExport);
    }

    public void export(CSVWriter writer, String entity, List<String> fieldsToExport, List<String> fieldsRequired, List<String> nonNullFields, Option<Map<String, String>> defaultMappings, String startUuid, String endUuid, int maxRecords, boolean includeDeleted, boolean includeRowKey) {
        PersistenceManager pm = Config$.MODULE$.persistenceManager();
        IntRef counter = new IntRef(0);
        List newFields = defaultMappings.isEmpty() ? (List)fieldsToExport.$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FullRecordMapper$.MODULE$.deletedColumn()})), List$.MODULE$.canBuildFrom()) : (List)((List)fieldsToExport.$plus$plus((GenTraversableOnce)((MapLike)defaultMappings.get()).values(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FullRecordMapper$.MODULE$.deletedColumn()})), List$.MODULE$.canBuildFrom());
        pm.pageOverSelect(entity, (Function2<String, Map<String, String>, Object>)new Serializable(writer, fieldsToExport, fieldsRequired, nonNullFields, maxRecords, includeDeleted, includeRowKey, counter){
            public static final long serialVersionUID = 0L;
            private final CSVWriter writer$1;
            private final List fieldsToExport$1;
            private final List fieldsRequired$1;
            private final List nonNullFields$1;
            private final int maxRecords$1;
            private final boolean includeDeleted$1;
            private final boolean includeRowKey$1;
            private final IntRef counter$2;

            public final boolean apply(String guid, Map<String, String> map) {
                if (this.includeDeleted$1 || ((String)map.getOrElse((Object)FullRecordMapper$.MODULE$.deletedColumn(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "false";
                    }
                })).equals("false")) {
                    if (this.fieldsRequired$1.forall((Function1)new Serializable(this, map){
                        public static final long serialVersionUID = 0L;
                        private final Map map$2;

                        public final boolean apply(String field) {
                            return this.map$2.contains((Object)field);
                        }
                        {
                            this.map$2 = map$2;
                        }
                    }) && this.nonNullFields$1.forall((Function1)new Serializable(this, map){
                        public static final long serialVersionUID = 0L;
                        private final Map map$2;

                        public final boolean apply(String field) {
                            return StringUtils.isNotBlank((String)((String)this.map$2.getOrElse((Object)field, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            })));
                        }
                        {
                            this.map$2 = map$2;
                        }
                    })) {
                        ExportUtil$.MODULE$.exportRecord(this.writer$1, (List<String>)this.fieldsToExport$1, guid, map, this.includeRowKey$1);
                    }
                    ++this.counter$2.elem;
                    if (this.counter$2.elem % 10000 == 0) {
                        ExportUtil$.MODULE$.logger().info(new StringBuilder().append((Object)"Exported ").append((Object)BoxesRunTime.boxToInteger((int)this.counter$2.elem)).append((Object)" Last key ").append((Object)guid).toString());
                    }
                }
                return this.maxRecords$1 > this.counter$2.elem;
            }
            {
                this.writer$1 = writer$1;
                this.fieldsToExport$1 = fieldsToExport$1;
                this.fieldsRequired$1 = fieldsRequired$1;
                this.nonNullFields$1 = nonNullFields$1;
                this.maxRecords$1 = maxRecords$1;
                this.includeDeleted$1 = includeDeleted$1;
                this.includeRowKey$1 = includeRowKey$1;
                this.counter$2 = counter$2;
            }
        }, startUuid, endUuid, 1000, (Seq<String>)newFields);
        writer.flush();
    }

    public Option<Map<String, String>> export$default$6() {
        return None$.MODULE$;
    }

    public String export$default$7() {
        return "";
    }

    public String export$default$8() {
        return "";
    }

    public boolean export$default$10() {
        return false;
    }

    public boolean export$default$11() {
        return true;
    }

    public String exportDistinct$default$4() {
        return "";
    }

    public String exportDistinct$default$5() {
        return "";
    }

    public void exportRecord(CSVWriter writer, List<String> fieldsToExport, String guid, Map<String, String> map, boolean includeRowKey) {
        String[] fields = (String[])((TraversableOnce)fieldsToExport.map((Function1)new Serializable(map){
            public static final long serialVersionUID = 0L;
            private final Map map$3;

            public final String apply(String field) {
                return (String)this.map$3.getOrElse((Object)field, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
            }
            {
                this.map$3 = map$3;
            }
        }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] line = includeRowKey ? (String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{guid}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])fields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : fields;
        writer.writeNext(line);
    }

    public boolean exportRecord$default$5() {
        return true;
    }

    private ExportUtil$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"ExportUtil");
    }
}

